/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.impaxee.actions.ui.config;

import com.agfa.pacs.base.swing.IComponentFactory;
import com.agfa.pacs.impaxee.actions.PAction;
import com.agfa.pacs.impaxee.actions.ui.ActionUIUtilities;
import com.agfa.pacs.impaxee.actions.ui.config.ActionDnD;
import com.agfa.pacs.listtext.swingx.plaf.nimbus.NimbusUtilities;
import com.agfa.pacs.logging.ALogger;
import java.awt.Component;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Enumeration;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.DropMode;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.TransferHandler;
import javax.swing.UIManager;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class ActionConfigTree
extends JTree {
    private static final ALogger log = ALogger.getLogger(ActionConfigTree.class);
    private final IComponentFactory componentFactory;

    public ActionConfigTree(IComponentFactory iComponentFactory) {
        this(null, iComponentFactory);
    }

    public ActionConfigTree(DefaultTreeModel defaultTreeModel, IComponentFactory iComponentFactory) {
        super(defaultTreeModel == null ? new DefaultTreeModel(new DefaultMutableTreeNode()) : defaultTreeModel);
        this.componentFactory = iComponentFactory;
        this.setRootVisible(false);
        this.setShowsRootHandles(false);
        this.setCellRenderer(this.createTreeCellRenderer());
        this.setDragEnabled(true);
        this.setDropMode(DropMode.INSERT);
        this.setTransferHandler(new ActionTreeTransferHandler());
        this.putClientProperty("JTree.lineStyle", "None");
        this.getSelectionModel().setSelectionMode(1);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                JPopupMenu jPopupMenu;
                if (SwingUtilities.isRightMouseButton(mouseEvent) && (jPopupMenu = ActionConfigTree.this.createMenu()) != null && jPopupMenu.getComponentCount() > 0) {
                    jPopupMenu.show(ActionConfigTree.this, mouseEvent.getX(), mouseEvent.getY());
                }
            }
        });
    }

    @Override
    public DefaultTreeModel getModel() {
        return (DefaultTreeModel)super.getModel();
    }

    @Override
    public DefaultTreeCellRenderer getCellRenderer() {
        return (DefaultTreeCellRenderer)super.getCellRenderer();
    }

    public int getActionNodeCount() {
        int n = 0;
        Enumeration<TreeNode> enumeration = ((DefaultMutableTreeNode)this.getModel().getRoot()).preorderEnumeration();
        while (enumeration.hasMoreElements()) {
            Object object;
            TreeNode treeNode = enumeration.nextElement();
            if (!(treeNode instanceof DefaultMutableTreeNode) || (object = ((DefaultMutableTreeNode)treeNode).getUserObject()) == null || !(object instanceof ActionNodeObject)) continue;
            ++n;
        }
        return n;
    }

    protected ActionTreeAction[] getMenuActions() {
        return new ActionTreeAction[0];
    }

    protected boolean canHandleDndImport(Component component, PAction pAction, JTree.DropLocation dropLocation) {
        if (dropLocation.getPath() == null) {
            return false;
        }
        return pAction != null;
    }

    protected boolean handleDndExport(Component component, NodeObject nodeObject) {
        DefaultMutableTreeNode defaultMutableTreeNode = this.findNode(nodeObject);
        if (defaultMutableTreeNode != null) {
            this.getModel().removeNodeFromParent(defaultMutableTreeNode);
            return true;
        }
        return false;
    }

    protected boolean handleDndImport(PAction pAction, JTree.DropLocation dropLocation) {
        TreePath treePath = dropLocation.getPath();
        if (treePath.getPathCount() > 2) {
            return false;
        }
        int n = dropLocation.getChildIndex();
        if (n == -1) {
            n = this.getModel().getChildCount(treePath.getLastPathComponent());
        }
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(new ActionNodeObject(pAction));
        DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)treePath.getLastPathComponent();
        this.getModel().insertNodeInto(defaultMutableTreeNode, defaultMutableTreeNode2, n);
        TreePath treePath2 = treePath.pathByAddingChild(defaultMutableTreeNode);
        this.makeVisible(treePath2);
        this.scrollRectToVisible(this.getPathBounds(treePath2));
        return true;
    }

    protected final DefaultMutableTreeNode findNode(NodeObject nodeObject) {
        Enumeration<TreeNode> enumeration = ((DefaultMutableTreeNode)this.getModel().getRoot()).preorderEnumeration();
        while (enumeration.hasMoreElements()) {
            Object object;
            TreeNode treeNode = enumeration.nextElement();
            if (!(treeNode instanceof DefaultMutableTreeNode) || (object = ((DefaultMutableTreeNode)treeNode).getUserObject()) == null || !nodeObject.equals(object)) continue;
            return (DefaultMutableTreeNode)treeNode;
        }
        return null;
    }

    protected void expandAll() {
        this.expandAll(new TreePath(this.getModel().getRoot()));
    }

    protected DefaultTreeCellRenderer createTreeCellRenderer() {
        return new ActionTreeCellRenderer();
    }

    private void expandAll(TreePath treePath) {
        TreeNode treeNode = (TreeNode)treePath.getLastPathComponent();
        if (treeNode.getChildCount() >= 0) {
            Enumeration<? extends TreeNode> enumeration = treeNode.children();
            while (enumeration.hasMoreElements()) {
                TreeNode treeNode2 = enumeration.nextElement();
                TreePath treePath2 = treePath.pathByAddingChild(treeNode2);
                this.expandAll(treePath2);
            }
        }
        this.expandPath(treePath);
    }

    private JPopupMenu createMenu() {
        ActionTreeAction[] actionTreeActionArray = this.getMenuActions();
        if (actionTreeActionArray != null && actionTreeActionArray.length > 0) {
            JPopupMenu jPopupMenu = new JPopupMenu();
            ActionTreeAction[] actionTreeActionArray2 = actionTreeActionArray;
            int n = actionTreeActionArray.length;
            int n2 = 0;
            while (n2 < n) {
                ActionTreeAction actionTreeAction = actionTreeActionArray2[n2];
                if (actionTreeAction.canPerform()) {
                    jPopupMenu.add(this.componentFactory.createMenuItem((Action)actionTreeAction));
                }
                ++n2;
            }
            return jPopupMenu;
        }
        return null;
    }

    public static class ActionNodeObject
    extends NodeObject {
        private PAction action;

        public ActionNodeObject(PAction pAction) {
            this.action = pAction;
        }

        public PAction getAction() {
            return this.action;
        }

        @Override
        public ActionNodeObject copy() {
            return new ActionNodeObject(this.action);
        }

        @Override
        public void configureCellRendererComponent(JTree jTree, Component component, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
            if (component instanceof JLabel) {
                JLabel jLabel = (JLabel)component;
                jLabel.setText(ActionUIUtilities.getActionConfigText(this.action));
                jLabel.setIcon(this.action.getIcon(true));
                if (!bl) {
                    jLabel.setForeground(UIManager.getColor("color.primary.3"));
                }
            }
        }
    }

    public static abstract class ActionTreeAction
    extends AbstractAction {
        protected ActionConfigTree tree;

        public ActionTreeAction(ActionConfigTree actionConfigTree, String string) {
            super(string);
            this.tree = actionConfigTree;
        }

        public final boolean canPerform() {
            return this.canPerform(this.getSelectedNode());
        }

        @Override
        public final void actionPerformed(ActionEvent actionEvent) {
            DefaultMutableTreeNode defaultMutableTreeNode = this.getSelectedNode();
            if (this.canPerform(defaultMutableTreeNode)) {
                this.perform(defaultMutableTreeNode);
            }
        }

        private DefaultMutableTreeNode getSelectedNode() {
            TreePath treePath = this.tree.getSelectionPath();
            Object object = treePath != null ? treePath.getLastPathComponent() : null;
            DefaultMutableTreeNode defaultMutableTreeNode = object != null && object instanceof DefaultMutableTreeNode ? (DefaultMutableTreeNode)object : null;
            return defaultMutableTreeNode;
        }

        protected abstract boolean canPerform(DefaultMutableTreeNode var1);

        protected abstract void perform(DefaultMutableTreeNode var1);
    }

    protected static class ActionTreeCellRenderer
    extends DefaultTreeCellRenderer {
        public ActionTreeCellRenderer() {
            NimbusUtilities.fixJTreeCellRendererBackgroundJava7((DefaultTreeCellRenderer)this);
        }

        @Override
        public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
            Object object2;
            JLabel jLabel = (JLabel)super.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
            if (object instanceof DefaultMutableTreeNode && (object2 = ((DefaultMutableTreeNode)object).getUserObject()) instanceof NodeObject) {
                ((NodeObject)object2).configureCellRendererComponent(jTree, jLabel, bl, bl2, bl3, n, bl4);
            }
            return jLabel;
        }
    }

    class ActionTreeTransferHandler
    extends TransferHandler {
        ActionTreeTransferHandler() {
        }

        @Override
        public int getSourceActions(JComponent jComponent) {
            return 3;
        }

        @Override
        public Transferable createTransferable(JComponent jComponent) {
            TreePath treePath = ((JTree)jComponent).getSelectionPath();
            if (treePath != null) {
                DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
                return new ActionDnD.ActionNodeTransferable((NodeObject)defaultMutableTreeNode.getUserObject());
            }
            return null;
        }

        @Override
        public void exportDone(JComponent jComponent, Transferable transferable, int n) {
            if (n == 2 && transferable instanceof ActionDnD.ActionNodeTransferable) {
                try {
                    NodeObject nodeObject = (NodeObject)((ActionDnD.ActionNodeTransferable)transferable).getTransferData(ActionDnD.ActionNodeFlavor);
                    if (nodeObject != null) {
                        ActionConfigTree.this.handleDndExport(jComponent, nodeObject);
                    }
                }
                catch (Exception exception) {
                    log.error(null, (Throwable)exception);
                }
            }
        }

        @Override
        public boolean canImport(TransferHandler.TransferSupport transferSupport) {
            NodeObject nodeObject;
            block6: {
                try {
                    if (transferSupport.isDrop()) break block6;
                    return false;
                }
                catch (Exception exception) {
                    log.error(null, (Throwable)exception);
                    return false;
                }
            }
            PAction pAction = null;
            if (transferSupport.getTransferable().isDataFlavorSupported(ActionDnD.ActionFlavor)) {
                pAction = (PAction)transferSupport.getTransferable().getTransferData(ActionDnD.ActionFlavor);
            } else if (transferSupport.getTransferable().isDataFlavorSupported(ActionDnD.ActionNodeFlavor) && (nodeObject = (NodeObject)transferSupport.getTransferable().getTransferData(ActionDnD.ActionNodeFlavor)) instanceof ActionNodeObject) {
                pAction = ((ActionNodeObject)nodeObject).getAction();
            }
            return ActionConfigTree.this.canHandleDndImport(transferSupport.getComponent(), pAction, (JTree.DropLocation)transferSupport.getDropLocation());
        }

        @Override
        public boolean importData(TransferHandler.TransferSupport transferSupport) {
            if (!this.canImport(transferSupport)) {
                return false;
            }
            try {
                NodeObject nodeObject;
                PAction pAction = null;
                if (transferSupport.getTransferable().isDataFlavorSupported(ActionDnD.ActionFlavor)) {
                    pAction = (PAction)transferSupport.getTransferable().getTransferData(ActionDnD.ActionFlavor);
                } else if (transferSupport.getTransferable().isDataFlavorSupported(ActionDnD.ActionNodeFlavor) && (nodeObject = (NodeObject)transferSupport.getTransferable().getTransferData(ActionDnD.ActionNodeFlavor)) instanceof ActionNodeObject) {
                    pAction = ((ActionNodeObject)nodeObject).getAction();
                }
                return ActionConfigTree.this.handleDndImport(pAction, (JTree.DropLocation)transferSupport.getDropLocation());
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return false;
            }
        }
    }

    public static abstract class NodeObject {
        public abstract NodeObject copy();

        public abstract void configureCellRendererComponent(JTree var1, Component var2, boolean var3, boolean var4, boolean var5, int var6, boolean var7);
    }
}

