/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.impaxee.actions.ui.config;

import com.agfa.pacs.base.swing.IComponentFactory;
import com.agfa.pacs.impaxee.actions.PAction;
import com.agfa.pacs.impaxee.actions.ui.ActionUIUtilities;
import com.agfa.pacs.impaxee.actions.ui.config.ActionDnD;
import com.agfa.pacs.impaxee.actions.ui.config.IActionConfigItem;
import com.agfa.pacs.impaxee.actions.ui.config.IActionConfigListModel;
import com.agfa.pacs.logging.ALogger;
import java.awt.Component;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DropMode;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.ListModel;
import javax.swing.TransferHandler;
import javax.swing.UIManager;

public class ActionConfigList<T extends IActionConfigItem>
extends JList<T> {
    private static final ALogger log = ALogger.getLogger(ActionConfigList.class);
    private IComponentFactory cfac;

    public ActionConfigList(IActionConfigListModel<T> iActionConfigListModel, IComponentFactory iComponentFactory) {
        super(iActionConfigListModel);
        this.cfac = iComponentFactory;
        this.setSelectionMode(0);
        this.setDragEnabled(true);
        this.setDropMode(DropMode.INSERT);
        this.setTransferHandler(new ActionConfigListTransferHandler());
        this.setCellRenderer(new ActionConfigListCellRenderer());
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                if (mouseEvent.isPopupTrigger()) {
                    this.showPopupMenu(mouseEvent);
                }
            }

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                if (mouseEvent.isPopupTrigger()) {
                    this.showPopupMenu(mouseEvent);
                }
            }

            private void showPopupMenu(MouseEvent mouseEvent) {
                JPopupMenu jPopupMenu = ActionConfigList.this.createMenu();
                if (jPopupMenu != null && jPopupMenu.getComponentCount() > 0) {
                    jPopupMenu.show(ActionConfigList.this, mouseEvent.getX(), mouseEvent.getY());
                }
            }
        });
    }

    @Override
    public IActionConfigListModel<T> getModel() {
        return (IActionConfigListModel)super.getModel();
    }

    @Override
    public void setModel(ListModel<T> listModel) {
        if (!(listModel instanceof IActionConfigListModel)) {
            throw new IllegalArgumentException("listmodel is not supported!");
        }
        super.setModel(listModel);
    }

    public void init(Collection<PAction> collection) {
        ArrayList arrayList = new ArrayList();
        if (collection != null) {
            for (PAction pAction : collection) {
                arrayList.add(this.getModel().createElement(pAction));
            }
        }
        this.getModel().setElements(arrayList);
    }

    public IActionConfigItem findItem(String string) {
        return this.findItem(string, 0);
    }

    public IActionConfigItem findItem(String string, int n) {
        if (string != null && string.length() > 0) {
            String string2 = string;
            string2 = string2.replaceAll("\\*", ".*");
            string2 = string2.replaceAll("\\?", ".");
            string2 = string2.replaceAll("\\+", "\\\\+");
            string2 = ".*" + string2 + ".*";
            int n2 = n >= 0 ? n : 0;
            while (n2 < this.getModel().getSize()) {
                IActionConfigItem iActionConfigItem = (IActionConfigItem)this.getModel().getElementAt(n2);
                String string3 = iActionConfigItem.getAction().getName();
                if (string3 != null && string3.toUpperCase().matches(string2.toUpperCase())) {
                    return iActionConfigItem;
                }
                ++n2;
            }
        }
        return null;
    }

    protected boolean canHandleDndImport(TransferHandler.TransferSupport transferSupport) throws Exception {
        JList.DropLocation dropLocation = (JList.DropLocation)transferSupport.getDropLocation();
        if (dropLocation.getIndex() >= 0) {
            try {
                return transferSupport.getTransferable().getTransferData(ActionDnD.ActionFlavor) != null;
            }
            catch (UnsupportedFlavorException unsupportedFlavorException) {}
        }
        return false;
    }

    protected boolean handleDndExport(JComponent jComponent, Transferable transferable, int n) throws Exception {
        IActionConfigItem iActionConfigItem = (IActionConfigItem)transferable.getTransferData(ActionDnD.ActionItemFlavor);
        this.getModel().removeElement(iActionConfigItem);
        return true;
    }

    protected boolean handleDndImport(TransferHandler.TransferSupport transferSupport) throws Exception {
        JList.DropLocation dropLocation = (JList.DropLocation)transferSupport.getDropLocation();
        PAction pAction = (PAction)transferSupport.getTransferable().getTransferData(ActionDnD.ActionFlavor);
        if (!"SEPARATOR".equals(pAction.getID()) && this.getModel().hasAction(pAction)) {
            Object t = this.getModel().getElement(pAction);
            this.getModel().moveElement(t, dropLocation.getIndex());
            return false;
        }
        Object t = this.getModel().createElement(pAction);
        this.getModel().insertElementAt(t, dropLocation.getIndex());
        return true;
    }

    protected Collection<ActionListAction> getMenuActions() {
        return Collections.emptyList();
    }

    private JPopupMenu createMenu() {
        Collection<ActionListAction> collection = this.getMenuActions();
        if (collection != null && collection.size() > 0) {
            JPopupMenu jPopupMenu = new JPopupMenu();
            for (ActionListAction actionListAction : collection) {
                if (!actionListAction.canPerform()) continue;
                jPopupMenu.add(this.cfac == null ? new JMenuItem(actionListAction) : this.cfac.createMenuItem((Action)actionListAction));
            }
            return jPopupMenu;
        }
        return null;
    }

    class ActionConfigListCellRenderer
    extends DefaultListCellRenderer {
        ActionConfigListCellRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            Component component = super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
            if (component instanceof JLabel) {
                JLabel jLabel = (JLabel)component;
                PAction pAction = ((IActionConfigItem)object).getAction();
                jLabel.setText(ActionUIUtilities.getActionConfigText(pAction));
                jLabel.setIcon(pAction.getIcon(true));
                jLabel.setFont(jLabel.getFont().deriveFont(0));
                if (!bl) {
                    jLabel.setForeground(UIManager.getColor("color.primary.3"));
                }
            }
            return component;
        }
    }

    class ActionConfigListTransferHandler
    extends TransferHandler {
        ActionConfigListTransferHandler() {
        }

        @Override
        public int getSourceActions(JComponent jComponent) {
            return 3;
        }

        @Override
        public Transferable createTransferable(JComponent jComponent) {
            IActionConfigItem iActionConfigItem = (IActionConfigItem)((ActionConfigList)jComponent).getSelectedValue();
            return new ActionDnD.ActionItemTransferable(iActionConfigItem);
        }

        @Override
        public void exportDone(JComponent jComponent, Transferable transferable, int n) {
            if (n == 2) {
                try {
                    ActionConfigList.this.handleDndExport(jComponent, transferable, n);
                }
                catch (Exception exception) {
                    log.error(null, (Throwable)exception);
                }
            }
        }

        @Override
        public boolean canImport(TransferHandler.TransferSupport transferSupport) {
            block3: {
                try {
                    if (transferSupport.isDrop()) break block3;
                    return false;
                }
                catch (Exception exception) {
                    log.error(null, (Throwable)exception);
                    return false;
                }
            }
            return ActionConfigList.this.canHandleDndImport(transferSupport);
        }

        @Override
        public boolean importData(TransferHandler.TransferSupport transferSupport) {
            if (!this.canImport(transferSupport)) {
                return false;
            }
            try {
                return ActionConfigList.this.handleDndImport(transferSupport);
            }
            catch (Exception exception) {
                return false;
            }
        }
    }

    protected abstract class ActionListAction
    extends AbstractAction {
        protected ActionConfigList<T> list;

        public ActionListAction(ActionConfigList<T> actionConfigList2, String string) {
            super(string);
            this.list = actionConfigList2;
        }

        public final boolean canPerform() {
            return this.canPerform(this.getSelectedItem());
        }

        @Override
        public final void actionPerformed(ActionEvent actionEvent) {
            Object t = this.getSelectedItem();
            if (this.canPerform(t)) {
                this.perform(t);
            }
        }

        private T getSelectedItem() {
            return (IActionConfigItem)this.list.getSelectedValue();
        }

        protected abstract boolean canPerform(T var1);

        protected abstract void perform(T var1);
    }
}

