/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.impaxee.actions.ui.config;

import com.agfa.pacs.impaxee.actions.PAction;
import com.agfa.pacs.impaxee.actions.ui.ActionUIUtilities;
import com.agfa.pacs.impaxee.actions.ui.config.IActionConfigItem;
import com.agfa.pacs.impaxee.actions.ui.config.IActionConfigListModel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.AbstractListModel;

public abstract class AbstractActionConfigListModel<T extends IActionConfigItem>
extends AbstractListModel<T>
implements IActionConfigListModel<T> {
    private List<T> items = new ArrayList<T>();

    public AbstractActionConfigListModel(List<PAction> list) {
        if (list != null) {
            for (PAction pAction : list) {
                this.items.add(this.createElement(pAction));
            }
        }
    }

    public AbstractActionConfigListModel(Collection<T> collection) {
        if (collection != null) {
            this.items.addAll(collection);
        }
    }

    public AbstractActionConfigListModel() {
        this((Collection<T>)null);
    }

    @Override
    public boolean hasAction(PAction pAction) {
        for (IActionConfigItem iActionConfigItem : this.items) {
            if (!iActionConfigItem.getAction().equals(pAction)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean hasElement(T t) {
        return this.items.contains(t);
    }

    @Override
    public int getSize() {
        return this.items.size();
    }

    @Override
    public T getElement(PAction pAction) {
        for (IActionConfigItem iActionConfigItem : this.items) {
            if (!iActionConfigItem.getAction().equals(pAction)) continue;
            return (T)iActionConfigItem;
        }
        return null;
    }

    @Override
    public T getElementAt(int n) {
        return (T)((IActionConfigItem)this.items.get(n));
    }

    @Override
    public void setElements(Collection<T> collection) {
        this.items.clear();
        if (collection != null) {
            this.items.addAll(collection);
        }
        this.fireContentsChanged(this, 0, this.items.size());
    }

    @Override
    public void insertElementAt(T t, int n) {
        if (!this.items.contains(t)) {
            this.items.add(t);
            Collections.sort(this.items, new Comparator<T>(){

                @Override
                public int compare(T t, T t2) {
                    String string = ActionUIUtilities.getActionConfigText(t.getAction());
                    String string2 = ActionUIUtilities.getActionConfigText(t2.getAction());
                    if (string != null && string2 != null) {
                        return string.compareTo(string2);
                    }
                    if (string != null) {
                        return -1;
                    }
                    if (string2 != null) {
                        return 1;
                    }
                    return -1;
                }
            });
            this.fireContentsChanged(this, 0, this.getSize());
        }
    }

    @Override
    public void removeElement(T t) {
        int n = this.items.indexOf(t);
        if (this.items.remove(t)) {
            this.fireIntervalRemoved(this, n, n);
        }
    }

    @Override
    public void removeAllElements() {
        this.items.clear();
        this.fireContentsChanged(this, 0, this.items.size());
    }

    @Override
    public void moveElement(T t, int n) {
        int n2 = this.items.indexOf(t);
        if (n2 >= 0) {
            this.items.add(n, t);
            this.items.remove(n2);
            this.fireContentsChanged(this, 0, this.items.size());
        }
    }

    protected Collection<T> getItems() {
        return Collections.unmodifiableCollection(this.items);
    }
}

