/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.impaxee.actions.impl;

import com.agfa.pacs.config.ConfigurationProviderFactory;
import com.agfa.pacs.config.IConfigurationChangeListener;
import com.agfa.pacs.config.IConfigurationProvider;
import com.agfa.pacs.impaxee.actions.impl.AbstractPAction;
import java.awt.Component;

public abstract class SelectablePersistantPAction
extends AbstractPAction
implements IConfigurationChangeListener {
    private static final String CONFIG_PATH = "impaxee.jvision.TOPTOOLBAR.persistance.";
    private String configKey;
    private boolean selected;

    public SelectablePersistantPAction(String string, String string2) {
        super(string2);
        this.configKey = string;
        this.initConfiguration();
    }

    private void initConfiguration() {
        String string = CONFIG_PATH + this.configKey;
        IConfigurationProvider iConfigurationProvider = ConfigurationProviderFactory.getConfig();
        if (iConfigurationProvider.exists(string)) {
            this.selected = iConfigurationProvider.getBoolean(string);
            if (this.selected != this.getDefaultValue()) {
                this.selectionChangedImpl(this.selected);
            }
        } else {
            this.selected = this.getDefaultValue();
        }
        iConfigurationProvider.registerConfigurationChangeListener(string, (IConfigurationChangeListener)this);
    }

    protected abstract boolean getDefaultValue();

    @Override
    public boolean isSelectable() {
        return true;
    }

    @Override
    public boolean isSelected() {
        return this.selected;
    }

    public void configurationChanged(String string) {
        boolean bl = ConfigurationProviderFactory.getConfig().getBoolean(CONFIG_PATH + this.configKey);
        if (bl != this.selected) {
            this.selected = bl;
            this.selectionChangedImpl(this.selected);
            this.fireSelectionChanged();
        }
    }

    protected abstract void selectionChangedImpl(boolean var1);

    @Override
    public final boolean perform(Component component) {
        this.notifyActionPerformed();
        this.selected = !this.selected;
        ConfigurationProviderFactory.getConfig().setBoolean(CONFIG_PATH + this.configKey, this.selected);
        this.selectionChangedImpl(this.selected);
        this.fireSelectionChanged();
        return true;
    }
}

