/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.impaxee.actions;

import com.agfa.pacs.config.ConfigUtilities;
import com.agfa.pacs.config.IConfigurationProvider;
import com.agfa.pacs.impaxee.actions.PAction;
import com.agfa.pacs.impaxee.actions.PActionPersistenceRef;
import com.agfa.pacs.impaxee.actions.PActionRegistry;
import com.agfa.pacs.impaxee.actions.impl.ActionNotFoundException;
import com.agfa.pacs.logging.ALogger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.NoSuchElementException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class PActionPersistenceContainer<T extends PActionPersistenceRef> {
    private static final ALogger log = ALogger.getLogger(PActionPersistenceContainer.class);
    private static final String ACTION_REFS_XML_ELEMENT_NAME = "action-refs";
    private IConfigurationProvider rootCp;
    private String configKey;
    private String defaultConfigKey;
    private boolean modified;
    private List<T> actionRefs;
    private Collection<IActionContainerListener> listeners;

    public PActionPersistenceContainer(IConfigurationProvider iConfigurationProvider, String string, String string2) {
        this.rootCp = iConfigurationProvider;
        this.configKey = string;
        this.defaultConfigKey = string2;
        this.modified = false;
        this.actionRefs = new ArrayList<T>();
        this.init();
    }

    public IConfigurationProvider getConfigurationProvider() {
        return this.rootCp;
    }

    public String getConfigurationKey() {
        return this.configKey;
    }

    public boolean modified() {
        return this.modified;
    }

    public int getActionRefCount() {
        return this.actionRefs.size();
    }

    public Collection<T> getActionRefs() {
        return Collections.unmodifiableList(this.actionRefs);
    }

    public int getIndexOfActionRef(T t) {
        return this.actionRefs.indexOf(t);
    }

    public boolean containsActionRef(T t) {
        return this.actionRefs.contains(t);
    }

    public PAction resolveAction(T t) throws ActionNotFoundException {
        return PActionRegistry.getAction(((PActionPersistenceRef)t).getActionId());
    }

    public boolean insertActionRefAt(T t, int n) throws IndexOutOfBoundsException {
        if (this.actionRefs.contains(t)) {
            return false;
        }
        this.actionRefs.add(n, t);
        this.modified = true;
        this.fireActionRefAdded((PActionPersistenceRef)t);
        return true;
    }

    public boolean addActionRef(T t) {
        return this.insertActionRefAt(t, this.actionRefs.size());
    }

    public boolean removeActionRef(T t) {
        if (this.actionRefs.remove(t)) {
            this.modified = true;
            this.fireActionRefRemoved((PActionPersistenceRef)t);
            return true;
        }
        return false;
    }

    public void removeAll() {
        if (!this.actionRefs.isEmpty()) {
            this.actionRefs.clear();
            this.modified = true;
            this.fireContainerChanged();
        }
    }

    public void moveActionRef(T t, int n) throws IndexOutOfBoundsException, NoSuchElementException, Exception {
        if (!this.actionRefs.contains(t)) {
            throw new NoSuchElementException();
        }
        if (n < 0 || n > this.actionRefs.size()) {
            throw new IndexOutOfBoundsException();
        }
        this.actionRefs.remove(t);
        this.actionRefs.add(n, t);
        this.fireActionRefMoved((PActionPersistenceRef)t);
    }

    public void init() {
        this.initImpl(this.configKey, true);
        this.fireContainerChanged();
    }

    public void init(PActionPersistenceContainer<T> pActionPersistenceContainer) {
        this.actionRefs.clear();
        for (PActionPersistenceRef pActionPersistenceRef : pActionPersistenceContainer.getActionRefs()) {
            this.actionRefs.add(pActionPersistenceRef);
        }
        this.modified = true;
        this.fireContainerChanged();
    }

    public void init(Document document) {
        NodeList nodeList = document.getElementsByTagName("action-ref");
        this.removeAll();
        int n = 0;
        while (n < nodeList.getLength()) {
            Node node = nodeList.item(n);
            if (!"action-ref".equals(node.getParentNode().getNodeName())) {
                T t = null;
                try {
                    t = this.createActionRef(node);
                    this.addActionRef(t);
                }
                catch (Exception exception) {
                    log.error("Reading action '" + t + "' from config failed! Action is skipped!", (Throwable)exception);
                }
            }
            ++n;
        }
        this.modified = true;
        this.fireContainerChanged();
    }

    public void resetToDefault() {
        this.initImpl(this.defaultConfigKey, false);
        this.fireContainerChanged();
    }

    public void resetToRole() {
        if (this.rootCp.exists(this.configKey)) {
            this.rootCp.removeValue(this.configKey);
            this.rootCp.storeAllConfiguration();
            this.rootCp.updateCache(this.configKey);
        }
        this.initImpl(this.configKey, true);
        this.fireContainerChanged();
    }

    public String toXML() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<");
        stringBuilder.append(ACTION_REFS_XML_ELEMENT_NAME);
        stringBuilder.append(">");
        for (PActionPersistenceRef pActionPersistenceRef : this.actionRefs) {
            stringBuilder.append(pActionPersistenceRef.toXML());
        }
        stringBuilder.append("</");
        stringBuilder.append(ACTION_REFS_XML_ELEMENT_NAME);
        stringBuilder.append(">");
        return stringBuilder.toString();
    }

    public void save() throws Exception {
        this.save(false);
    }

    public void save(boolean bl) throws Exception {
        if (!this.modified) {
            return;
        }
        ConfigUtilities.saveToConfigAsXML_UTF16((IConfigurationProvider)this.rootCp, (String)this.configKey, (String)this.toXML());
        if (bl) {
            String string = this.rootCp.getRole();
            if (string != null && !string.isEmpty()) {
                this.rootCp.storeConfigurationForRole(string);
            } else {
                this.rootCp.storeAllConfiguration();
            }
        }
    }

    public void addContainerListener(IActionContainerListener iActionContainerListener) {
        if (this.listeners == null) {
            this.listeners = new ArrayList<IActionContainerListener>();
        }
        if (!this.listeners.contains(iActionContainerListener)) {
            this.listeners.add(iActionContainerListener);
        }
    }

    public void removeContainerListener(IActionContainerListener iActionContainerListener) {
        if (this.listeners != null) {
            this.listeners.remove(iActionContainerListener);
        }
    }

    public Collection<IActionContainerListener> getContainerListeners() {
        if (this.listeners != null) {
            return new ArrayList<IActionContainerListener>(this.listeners);
        }
        return null;
    }

    protected T createActionRef(Node node) throws Exception {
        return (T)PActionPersistenceRef.create(node);
    }

    protected final void setModified(boolean bl) {
        this.modified = bl;
    }

    protected void initImpl(String string, boolean bl) {
        try {
            if (!this.rootCp.exists(string) && this.defaultConfigKey == null) {
                this.removeAll();
                this.modified = true;
            } else {
                Document document = ConfigUtilities.loadXMLFromConfig_UTF16((IConfigurationProvider)this.rootCp, (String)(this.rootCp.exists(string) ? string : this.defaultConfigKey));
                this.init(document);
            }
            if (bl) {
                this.modified = false;
            }
        }
        catch (Exception exception) {
            log.error("Reading action-references from config failed!", (Throwable)exception);
        }
    }

    private void fireActionRefAdded(PActionPersistenceRef pActionPersistenceRef) {
        if (this.listeners != null) {
            for (IActionContainerListener iActionContainerListener : this.listeners) {
                iActionContainerListener.actionRefAdded(this, pActionPersistenceRef);
            }
        }
    }

    private void fireActionRefRemoved(PActionPersistenceRef pActionPersistenceRef) {
        if (this.listeners != null) {
            for (IActionContainerListener iActionContainerListener : this.listeners) {
                iActionContainerListener.actionRefRemoved(this, pActionPersistenceRef);
            }
        }
    }

    private void fireActionRefMoved(PActionPersistenceRef pActionPersistenceRef) {
        if (this.listeners != null) {
            for (IActionContainerListener iActionContainerListener : this.listeners) {
                iActionContainerListener.actionRefMoved(this, pActionPersistenceRef);
            }
        }
    }

    private void fireContainerChanged() {
        if (this.listeners != null) {
            for (IActionContainerListener iActionContainerListener : this.listeners) {
                iActionContainerListener.containerChanged(this);
            }
        }
    }

    public static interface IActionContainerListener {
        public void actionRefAdded(PActionPersistenceContainer<?> var1, PActionPersistenceRef var2);

        public void actionRefRemoved(PActionPersistenceContainer<?> var1, PActionPersistenceRef var2);

        public void actionRefMoved(PActionPersistenceContainer<?> var1, PActionPersistenceRef var2);

        public void containerChanged(PActionPersistenceContainer<?> var1);
    }
}

