/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.impaxee;

import com.agfa.pacs.base.util.DicomUtils;
import com.agfa.pacs.base.util.Product;
import com.agfa.pacs.data.shared.lw.IStudyInfo;
import com.agfa.pacs.impaxee.XmlStringBuilder;
import com.agfa.pacs.impaxee.config.Config;
import com.agfa.pacs.logging.ALogger;
import com.agfa.pacs.login.URLProviderFactory;
import com.agfa.pacs.tools.ComputerName;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.Pair;
import org.apache.commons.lang3.time.FastDateFormat;
import org.dcm4che3.data.Attributes;

public class PerformanceProfiler {
    private static final char DELIMITER = ';';
    private static final long ROLL_OVER_SIZE = 262144L;
    private static final String FILE_NAME = "performance.csv";
    private static final ALogger log = ALogger.getLogger(PerformanceProfiler.class);
    public static final boolean active = Config.impaxee.jvision.monitorPerformance.get();
    private static final PerformanceProfiler instance = new PerformanceProfiler();
    private static final FastDateFormat df = FastDateFormat.getInstance((String)"dd.MM.yyyy HH:mm:ss");
    private static List<TimeStampEntry> timeStampList = new ArrayList<TimeStampEntry>();
    private Map<String, TimeStampEntry> requests = new ConcurrentHashMap<String, TimeStampEntry>(16, 0.75f, 4);
    private PrintWriter writer = null;
    private File myDirectory = null;
    private static final String user = URLProviderFactory.getProvider().getLoginInformation().getUserID();
    private static final String delimUser = String.valueOf(';') + user;
    private static final boolean headless = Product.isHeadless();

    public static PerformanceProfiler getInstance() {
        return instance;
    }

    private PerformanceProfiler() {
        this.openFile();
    }

    private void openFile() {
        if (Product.isCDViewer()) {
            return;
        }
        File file = new File(this.myDirectory, FILE_NAME);
        try {
            if (file.length() > 262144L) {
                file.delete();
            }
            boolean bl = file.exists();
            this.writer = new PrintWriter(new FileOutputStream(file, true), true);
            if (!bl) {
                this.writer.println("Start Date;Study Instance UID;First Display;Full Study;Modality;Object count");
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            log.error("Could not create file", (Throwable)fileNotFoundException);
        }
    }

    public void closeFile() {
        if (this.writer != null) {
            this.writer.flush();
            this.writer.close();
            this.writer = null;
        }
    }

    public void awaitStudyLoad(String string, long l) throws InterruptedException {
        TimeStampEntry timeStampEntry = this.requests.get(string);
        if (timeStampEntry != null) {
            timeStampEntry.lock.await(l, TimeUnit.MILLISECONDS);
        }
    }

    public void setStudyLoaded(String string, int n) {
        TimeStampEntry timeStampEntry = this.requests.get(string);
        if (timeStampEntry != null) {
            timeStampEntry.setStamp(TimeStampType.STUDY_LOADED);
            timeStampEntry.setObjectCount(n);
            if (timeStampEntry.print(this.writer)) {
                log.info("Study fully loaded:" + string);
                this.requests.remove(string);
                timeStampList.add(timeStampEntry);
            }
        }
    }

    public static String buildXmlString() {
        XmlStringBuilder xmlStringBuilder = new XmlStringBuilder();
        String string = ComputerName.getComputerId();
        xmlStringBuilder.appendString("<?xml version=\"1.0\" encoding=\"UTF-8\" ?>");
        xmlStringBuilder.appendString("<statistics>");
        HashSet<Pair> hashSet = new HashSet<Pair>();
        for (TimeStampEntry timeStampEntry : timeStampList) {
            Pair pair = Pair.of((Object)timeStampEntry.studyInstanceUID, (Object)timeStampEntry.start);
            if (hashSet.contains(pair)) continue;
            hashSet.add(pair);
            Date date = new Date(timeStampEntry.start);
            xmlStringBuilder.appendOpeningTag("study");
            xmlStringBuilder.appendAttribute("StartDate", df.format(date), false);
            xmlStringBuilder.appendAttribute("StudyInstanceUid", timeStampEntry.studyInstanceUID, false);
            xmlStringBuilder.appendAttribute("FirstDisplay", timeStampEntry.getTime(TimeStampType.FIRST_DISPLAY), false);
            xmlStringBuilder.appendAttribute("StudyLoaded", timeStampEntry.getTime(TimeStampType.STUDY_LOADED), false);
            xmlStringBuilder.appendAttribute("Modality", timeStampEntry.modality, false);
            xmlStringBuilder.appendAttribute("ObjectCount", Integer.toString(timeStampEntry.objectCount), false);
            xmlStringBuilder.appendAttribute("User", user, false);
            xmlStringBuilder.appendAttribute("Machine", string, true);
            xmlStringBuilder.appendTag("study", true);
        }
        xmlStringBuilder.appendString("</statistics>");
        return xmlStringBuilder.getXmlString();
    }

    public void setFirstDisplay(String string) {
        TimeStampEntry timeStampEntry = this.requests.get(string);
        if (timeStampEntry != null) {
            timeStampEntry.setStamp(TimeStampType.FIRST_DISPLAY);
            if (timeStampEntry.print(this.writer)) {
                this.requests.remove(string);
                timeStampList.add(timeStampEntry);
            }
        }
    }

    public void addStudyOpened(IStudyInfo iStudyInfo, boolean bl) {
        String string;
        if (active && !this.requests.containsKey(string = iStudyInfo.getKey())) {
            this.requests.put(string, new TimeStampEntry(iStudyInfo, bl));
        }
    }

    private static class TimeStampEntry {
        private long start = System.currentTimeMillis();
        private String studyInstanceUID = null;
        private long[] timeStamps = new long[TimeStampType.values().length];
        private String modality;
        private int objectCount;
        private boolean prior;
        final CountDownLatch lock;

        public TimeStampEntry(IStudyInfo iStudyInfo, boolean bl) {
            this.modality = DicomUtils.getModalitiesInStudiesAsString((Attributes)iStudyInfo.getAttributes(), (boolean)true, (boolean)true);
            this.studyInstanceUID = iStudyInfo.getKey();
            this.lock = new CountDownLatch(1);
            this.prior = headless ? true : bl;
        }

        public void setStamp(TimeStampType timeStampType) {
            this.timeStamps[timeStampType.ordinal()] = System.currentTimeMillis();
            if (timeStampType == TimeStampType.STUDY_LOADED) {
                this.lock.countDown();
            }
        }

        public void setObjectCount(int n) {
            this.objectCount = n;
        }

        public boolean print(PrintWriter printWriter) {
            if (!this.prior) {
                long[] lArray = this.timeStamps;
                int n = this.timeStamps.length;
                int n2 = 0;
                while (n2 < n) {
                    long l = lArray[n2];
                    if (l == 0L) {
                        return false;
                    }
                    ++n2;
                }
            }
            if (printWriter == null) {
                return true;
            }
            Date date = new Date(this.start);
            StringBuilder stringBuilder = new StringBuilder(df.format(date)).append(';');
            stringBuilder.append(this.studyInstanceUID).append(';');
            stringBuilder.append(this.getTime(TimeStampType.FIRST_DISPLAY)).append(';');
            stringBuilder.append(this.getTime(TimeStampType.STUDY_LOADED)).append(';');
            stringBuilder.append(this.modality).append(';');
            stringBuilder.append(Integer.toString(this.objectCount));
            stringBuilder.append(delimUser);
            printWriter.println(stringBuilder.toString());
            return true;
        }

        private String getTime(TimeStampType timeStampType) {
            long l = this.timeStamps[timeStampType.ordinal()];
            if (l == 0L) {
                return "";
            }
            return Long.toString(l - this.start);
        }
    }

    private static enum TimeStampType {
        FIRST_DISPLAY,
        STUDY_LOADED;

    }
}

