/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.impaxee.glue.monitoring;

import com.agfa.pacs.impaxee.glue.monitoring.IModifiedSeries;
import com.agfa.pacs.impaxee.glue.monitoring.ModifiedSeriesState;
import com.agfa.pacs.impaxee.gui.selection.DisplaySetSelectionData;
import com.agfa.pacs.impaxee.hanging.IDisplaySet;
import com.agfa.pacs.impaxee.splitsort.CrossStudyDisplaySetComparator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import javax.swing.JComponent;

public class ModifiedDisplaySet
implements IModifiedSeries,
Comparable<ModifiedDisplaySet> {
    private static final CrossStudyDisplaySetComparator COMPARATOR = new CrossStudyDisplaySetComparator();
    private IDisplaySet displaySet;
    private final Collection<ModifiedSeriesState> states;

    private ModifiedDisplaySet(IDisplaySet iDisplaySet, ModifiedSeriesState modifiedSeriesState) {
        this(iDisplaySet, EnumSet.of(modifiedSeriesState));
    }

    private ModifiedDisplaySet(IDisplaySet iDisplaySet, Collection<ModifiedSeriesState> collection) {
        this.displaySet = iDisplaySet;
        this.states = collection;
    }

    static List<ModifiedDisplaySet> createList(Collection<IDisplaySet> collection, Collection<IDisplaySet> collection2) {
        ArrayList<ModifiedDisplaySet> arrayList = new ArrayList<ModifiedDisplaySet>(collection.size() + collection2.size());
        for (IDisplaySet iDisplaySet : collection) {
            EnumSet<ModifiedSeriesState> enumSet = EnumSet.of(ModifiedSeriesState.CHANGED);
            if (collection2.remove(iDisplaySet)) {
                enumSet.add(ModifiedSeriesState.REMOVED);
            }
            arrayList.add(new ModifiedDisplaySet(iDisplaySet, enumSet));
        }
        for (IDisplaySet iDisplaySet : collection2) {
            arrayList.add(new ModifiedDisplaySet(iDisplaySet, ModifiedSeriesState.REMOVED));
        }
        Collections.sort(arrayList);
        return arrayList;
    }

    @Override
    public JComponent getIcon() {
        return DisplaySetSelectionData.getDisplaySetIcon((IDisplaySet)this.displaySet, (boolean)false, (boolean)false);
    }

    @Override
    public Collection<ModifiedSeriesState> getStates() {
        return this.states;
    }

    @Override
    public String getDescription() {
        return DisplaySetSelectionData.getDisplaySetLabel((IDisplaySet)this.displaySet);
    }

    @Override
    public int compareTo(ModifiedDisplaySet modifiedDisplaySet) {
        return COMPARATOR.compare(this.displaySet, modifiedDisplaySet.displaySet);
    }
}

