/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.impaxee.glue.dnd;

import com.agfa.pacs.data.shared.dnd.DataInfoFlavor;
import com.agfa.pacs.data.shared.dnd.DataInfoTransferData;
import com.agfa.pacs.data.shared.instanceinfo.impl.IMPAXEEWADOInstanceInfo;
import com.agfa.pacs.data.shared.lw.IDataInfoSource;
import com.agfa.pacs.data.shared.lw.ILoadableInfo;
import com.agfa.pacs.data.shared.lw.IObjectInfo;
import com.agfa.pacs.impaxee.glue.data.DataObjectUtilities;
import com.agfa.pacs.impaxee.glue.dnd.IXMLWadoImageList;
import com.agfa.pacs.impaxee.glue.dnd.XMLWadoImageList;
import com.agfa.pacs.logging.ALogger;
import com.tiani.base.data.IFrameObjectData;
import com.tiani.jvision.vis.Vis2;
import com.tiani.jvision.vis.VisData;
import com.tiani.jvision.vis.VisDisplayData;
import com.tiani.jvision.vis.dnd.IVisDisplayDataFlavorProvider;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class VisDisplayDataFlavorProvider
implements IVisDisplayDataFlavorProvider {
    private static final ALogger log = ALogger.getLogger(VisDisplayDataFlavorProvider.class);
    public static final DataFlavor WADO_FLAVOR = new DataFlavor(IXMLWadoImageList.class, "Dicom Wado Flavor");
    private static final DataFlavor[] flavors = new DataFlavor[]{DataInfoFlavor.FLAVOR, WADO_FLAVOR};

    public DataFlavor[] getSupportedFlavors() {
        return flavors;
    }

    public boolean isFlavorSupported(DataFlavor dataFlavor) {
        if (flavors != null && dataFlavor != null) {
            DataFlavor[] dataFlavorArray = flavors;
            int n = flavors.length;
            int n2 = 0;
            while (n2 < n) {
                DataFlavor dataFlavor2 = dataFlavorArray[n2];
                if (dataFlavor.equals(dataFlavor2)) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    public Object getTransferData(DataFlavor dataFlavor, Vis2 vis2) throws UnsupportedFlavorException {
        if (this.isFlavorSupported(dataFlavor)) {
            if (DataInfoFlavor.FLAVOR.equals(dataFlavor)) {
                ArrayList<IFrameObjectData> arrayList = new ArrayList<IFrameObjectData>();
                arrayList.add(vis2.getData().getFrameData());
                DataInfoTransferData dataInfoTransferData = new DataInfoTransferData();
                List<IObjectInfo> list = DataObjectUtilities.createObjectInfos(arrayList);
                if (list != null) {
                    dataInfoTransferData.setDataInfo(new ArrayList<IObjectInfo>(list));
                }
                return dataInfoTransferData;
            }
            if (WADO_FLAVOR.equals(dataFlavor)) {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("<images>");
                VisDisplayData visDisplayData = vis2.getData().getParent();
                List<VisData> list = visDisplayData == null ? Collections.singletonList(vis2.getData()) : visDisplayData.getSelectedVis();
                for (VisData visData : list) {
                    try {
                        ILoadableInfo iLoadableInfo = visData.getFrameData().getLoadableDataInfo();
                        URL uRL = IMPAXEEWADOInstanceInfo.makeFullURL((IDataInfoSource)iLoadableInfo.getSource(), (String)iLoadableInfo.getStudyUID(), (String)iLoadableInfo.getSeriesUID(), (String)iLoadableInfo.getSOPInstanceUID());
                        if (uRL == null) continue;
                        stringBuilder.append("<image url=\"");
                        stringBuilder.append(VisDisplayDataFlavorProvider.escapeXMLCharacters(uRL.toString()));
                        stringBuilder.append("\"/>");
                    }
                    catch (Exception exception) {
                        log.error(null, (Throwable)exception);
                    }
                }
                stringBuilder.append("</images>");
                return new XMLWadoImageList(stringBuilder.toString());
            }
        }
        throw new UnsupportedFlavorException(dataFlavor);
    }

    private static String escapeXMLCharacters(String string) {
        string = string.replaceAll("&", "&amp;");
        string = string.replaceAll("<", "&lt;");
        string = string.replaceAll(">", "&gt;");
        string = string.replaceAll("\"", "&quot;");
        string = string.replaceAll("'", "&apos;");
        return string;
    }
}

