/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.impaxee.glue.dicomobjectrenderer;

import com.agfa.pacs.listtext.dicomobject.presentation.rendering.PresentationRenderContext;
import com.tiani.jvision.image.WindowHandlerBase;
import com.tiani.jvision.image.WindowHandlerNuk;
import com.tiani.jvision.renderer.IRDCRenderer;
import com.tiani.util.expressions.IEvaluablePrivateData;

public class RendererEvaluableData
implements IEvaluablePrivateData {
    private IRDCRenderer renderer;
    private String device = "screen";

    public RendererEvaluableData(IRDCRenderer iRDCRenderer, PresentationRenderContext presentationRenderContext) {
        this.renderer = iRDCRenderer;
        if (presentationRenderContext != null) {
            this.device = presentationRenderContext.getDevice();
        }
    }

    private String getWindowNukMaxAsString(WindowHandlerBase windowHandlerBase) {
        if (windowHandlerBase != null && windowHandlerBase instanceof WindowHandlerNuk) {
            return this.getPercentageOfMaxString(windowHandlerBase, windowHandlerBase.getCenter() + windowHandlerBase.getWidth() / 2.0);
        }
        return null;
    }

    private String getWindowNukMinAsString(WindowHandlerBase windowHandlerBase) {
        if (windowHandlerBase != null && windowHandlerBase instanceof WindowHandlerNuk) {
            return this.getPercentageOfMaxString(windowHandlerBase, windowHandlerBase.getCenter() - windowHandlerBase.getWidth() / 2.0);
        }
        return null;
    }

    private String getPercentageOfMaxString(WindowHandlerBase windowHandlerBase, double d) {
        double d2 = this.renderer.getRawDataContainer().getHistogram().getMax();
        double d3 = windowHandlerBase.dataToLogical(d2);
        double d4 = 100.0 * d / d3;
        return d4 >= 0.0 ? String.valueOf(d4) : "-";
    }

    public Object resolveString(String string) {
        WindowHandlerBase windowHandlerBase = this.renderer.getWindowHandler();
        if (string.equals("WINDOW_CENTER")) {
            if (windowHandlerBase != null) {
                return windowHandlerBase.getCenter();
            }
            return null;
        }
        if (string.equals("WINDOW_WIDTH")) {
            if (windowHandlerBase != null) {
                return windowHandlerBase.getWidth();
            }
            return null;
        }
        if (string.equals("WINDOW_NUK_MAX")) {
            return this.getWindowNukMaxAsString(windowHandlerBase);
        }
        if (string.equals("WINDOW_NUK_MIN")) {
            return this.getWindowNukMinAsString(windowHandlerBase);
        }
        if (string.equals("ZOOM_FACTOR")) {
            double d = this.renderer.getAreaFitHandler().getAbsoluteZoomFactor();
            if (Double.isNaN(d)) {
                return null;
            }
            return d;
        }
        if (string.equals("OUTPUT_DEVICE")) {
            return this.device;
        }
        if (string.equals("TYPE")) {
            return "None";
        }
        return this.renderer.resolveString(string);
    }
}

