/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.impaxee.glue.datahandler;

import com.agfa.pacs.data.shared.instanceinfo.IInstanceInfo;
import com.agfa.pacs.data.shared.lw.DataInfoUtilities;
import com.agfa.pacs.data.shared.lw.IDataInfoSource;
import com.agfa.pacs.data.shared.lw.IObjectInfo;
import com.agfa.pacs.data.shared.lw.IStudyInfo;
import com.agfa.pacs.data.shared.store.IStoreHandler;
import com.agfa.pacs.data.shared.store.IStoreProvider;
import com.agfa.pacs.data.shared.store.StoreProviderFactory;
import com.agfa.pacs.data.shared.worklist.IWorklistContext;
import com.agfa.pacs.impaxee.data.fetcher.IStore;
import com.agfa.pacs.impaxee.glue.data.ImpaxEEDataObject;
import com.agfa.pacs.impaxee.glue.data.ImpaxEEStudyData;
import com.agfa.pacs.impaxee.glue.datainfo.ImpaxEEInstanceInfo;
import com.agfa.pacs.impaxee.glue.datanode.ImpaxEEDataInfoNodeProvider;
import com.agfa.pacs.listtext.lta.store.StoreUtils;
import com.tiani.base.data.IObjectData;
import com.tiani.base.data.IStudyData;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.dcm4che3.data.Attributes;

public class DataStoreManager
implements IStore {
    private static DataStoreManager instance = null;
    private IStoreProvider storeProvider = StoreProviderFactory.getInstance().getStoreProvider();

    private DataStoreManager() {
    }

    public static synchronized DataStoreManager getInstance() {
        if (instance == null) {
            instance = new DataStoreManager();
        }
        return instance;
    }

    public boolean supportsWorklists() {
        return this.storeProvider.supportsWorklists();
    }

    public Collection<IWorklistContext> getAvailableWorklistContexts() {
        return this.storeProvider.getAvailableWorklistContexts();
    }

    public IStoreHandler store(IObjectData iObjectData, IStudyData iStudyData, Collection<IWorklistContext> collection) {
        return this.store(Collections.singletonList(iObjectData), iStudyData, collection);
    }

    private static IObjectInfo createDataInfoWithUpdatedSource(IObjectData iObjectData) {
        List<IObjectInfo> list;
        ImpaxEEInstanceInfo impaxEEInstanceInfo = null;
        if (iObjectData instanceof ImpaxEEDataObject) {
            impaxEEInstanceInfo = new ImpaxEEInstanceInfo((ImpaxEEDataObject)iObjectData);
        }
        if ((list = DataStoreManager.createDataInfo(iObjectData)) == null || list.size() == 0) {
            return null;
        }
        IObjectInfo iObjectInfo = list.get(0);
        IInstanceInfo iInstanceInfo = iObjectInfo.getInstanceInfo();
        if (iInstanceInfo != null && !(iInstanceInfo instanceof ImpaxEEInstanceInfo)) {
            iObjectInfo.setInstanceInfo((IInstanceInfo)impaxEEInstanceInfo);
            iObjectInfo.setSource((IDataInfoSource)ImpaxEEDataInfoNodeProvider.getInstance());
        }
        return iObjectInfo;
    }

    public IStoreHandler store(Collection<IObjectData> collection, IStudyData iStudyData, Collection<IWorklistContext> collection2) {
        ArrayList<IObjectInfo> arrayList = new ArrayList<IObjectInfo>();
        for (IObjectData iObjectData : collection) {
            IObjectInfo iObjectInfo = DataStoreManager.createDataInfoWithUpdatedSource(iObjectData);
            if (iObjectInfo == null) continue;
            arrayList.add(iObjectInfo);
        }
        if (arrayList.isEmpty()) {
            return null;
        }
        return this.storeProvider.store(arrayList, DataStoreManager.createStudyInfo(iStudyData), collection2);
    }

    public boolean store(Attributes attributes, IStudyData iStudyData) {
        return StoreUtils.storeObjects((IDataInfoSource)DataStoreManager.createStudyInfo(iStudyData).getSource(), (Attributes[])new Attributes[]{attributes});
    }

    private static List<IObjectInfo> createDataInfo(IObjectData iObjectData) {
        return DataInfoUtilities.getLevel(((ImpaxEEDataObject)iObjectData).getDataInfo(), IObjectInfo.class);
    }

    private static IStudyInfo createStudyInfo(IStudyData iStudyData) {
        if (iStudyData != null && iStudyData instanceof ImpaxEEStudyData) {
            return (IStudyInfo)((ImpaxEEStudyData)iStudyData).getDataInfo();
        }
        return null;
    }
}

