/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.impaxee.glue.data;

import com.agfa.pacs.cache.ByteArrayContainer;
import com.agfa.pacs.data.shared.data.IDicomDataListener;
import com.agfa.pacs.data.shared.data.cache.DicomCacheFactory;
import com.agfa.pacs.data.shared.data.cache.IDicomCache;
import com.agfa.pacs.data.shared.instanceinfo.IInstanceInfo;
import com.agfa.pacs.data.shared.instanceinfo.impl.IMPAXEEWADOInstanceInfo;
import com.agfa.pacs.data.shared.lw.IDataInfo;
import com.agfa.pacs.data.shared.lw.ILoadableInfo;
import com.agfa.pacs.data.shared.lw.IObjectInfo;
import com.agfa.pacs.data.shared.pixel.IPixelDataInfo;
import com.agfa.pacs.impaxee.ImpaxEEUtils;
import com.agfa.pacs.impaxee.glue.data.ImpaxEEDataObject;
import com.agfa.pacs.listtext.lta.base.tagdictionary.PrivateTagDictionary;
import com.agfa.pacs.logging.ALogger;
import com.tiani.base.data.IImageInformation;
import com.tiani.base.data.IObjectData;
import com.tiani.base.data.IObjectListener;
import com.tiani.base.data.ISeriesData;
import com.tiani.base.data.ImageInformation2;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.io.DicomOutputStream;

public abstract class ImpaxEEObjectData
extends ImpaxEEDataObject<IObjectInfo>
implements IObjectData,
IDicomDataListener {
    private static final ALogger LOGGER = ALogger.getLogger(ImpaxEEObjectData.class);
    private static final IDicomCache DICOM_CACHE = DicomCacheFactory.getInstance().getDicomCache();
    private ISeriesData parent;
    protected volatile int loadState = 0;
    protected List<IObjectListener> listeners;
    private volatile IImageInformation imageInformation;

    public ImpaxEEObjectData(IObjectInfo iObjectInfo) {
        super(iObjectInfo);
    }

    public abstract IObjectInfo getFullDataInfo();

    public Attributes getMergedDatasetFromQueryObject() {
        Attributes attributes = new Attributes();
        IDataInfo iDataInfo = this.getQueryObject().getTreeParent();
        attributes.addAll(iDataInfo.getTreeParent().getTreeParent().getAttributes());
        attributes.addAll(iDataInfo.getTreeParent().getAttributes());
        attributes.addAll(iDataInfo.getAttributes());
        attributes.addAll(this.getDicomObject());
        return attributes;
    }

    public String getSOPInstanceUID() {
        return ((IObjectInfo)this.getDataInfo()).getSOPInstanceUID();
    }

    public boolean hasError() {
        return this.loadState == -1;
    }

    public ILoadableInfo getLoadableDataInfo() {
        return (ILoadableInfo)this.dataInfo;
    }

    public String getUID() {
        return ((IObjectInfo)this.getDataInfo()).getSOPInstanceUID();
    }

    public String getSOPClassUID() {
        return ((IObjectInfo)this.getDataInfo()).getSOPClassUID();
    }

    public void setParent(ISeriesData iSeriesData) {
        this.parent = iSeriesData;
    }

    public ISeriesData getParent() {
        return this.parent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IImageInformation getImageInformation() {
        IImageInformation iImageInformation = this.imageInformation;
        if (iImageInformation == null) {
            ImpaxEEObjectData impaxEEObjectData = this;
            synchronized (impaxEEObjectData) {
                iImageInformation = this.imageInformation;
                if (iImageInformation == null) {
                    this.imageInformation = iImageInformation = new ImageInformation2(this.getDicomObject(), false);
                }
            }
        }
        return iImageInformation;
    }

    public void resetLoadState() {
        this.loadState = 0;
    }

    public boolean isStartedBeingLoaded() {
        return this.loadState >= 1;
    }

    public boolean isFullyLoaded() {
        return this.loadState >= 4;
    }

    public boolean isHeaderInitialised() {
        return this.loadState >= 3;
    }

    public final void addListener(IObjectListener iObjectListener) {
        if (this.loadState == 1) {
            iObjectListener.lossyObjectFinished((IObjectData)this);
        }
        if (this.loadState >= 4) {
            iObjectListener.objectFinished((IObjectData)this);
            return;
        }
        if (this.listeners == null) {
            this.listeners = new CopyOnWriteArrayList<IObjectListener>();
            this.listeners.add(iObjectListener);
        } else if (!this.listeners.contains(iObjectListener)) {
            this.listeners.add(iObjectListener);
        }
        if (this.loadState == 1) {
            iObjectListener.lossyObjectFinished((IObjectData)this);
        }
        if (this.loadState >= 4) {
            iObjectListener.objectFinished((IObjectData)this);
        }
    }

    private void notifyLoadFinished() {
        if (this.listeners != null) {
            for (IObjectListener iObjectListener : this.listeners) {
                try {
                    iObjectListener.objectFinished((IObjectData)this);
                }
                catch (Throwable throwable) {
                    log.error("Notify final exception", throwable);
                }
            }
            this.listeners = null;
        }
    }

    public final synchronized void initFromDicomObject(Attributes attributes) {
        String string;
        String string2 = attributes.getString(0x20000D);
        if (!DICOM_CACHE.hasDataset(string2, string = attributes.getString(524312))) {
            String string3 = attributes.getString(131088);
            if (string3 != null) {
                try {
                    ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(32768);
                    DicomOutputStream dicomOutputStream = new DicomOutputStream((OutputStream)byteArrayOutputStream, "1.2.840.10008.1.2.1");
                    dicomOutputStream.writeDataset(null, attributes);
                    dicomOutputStream.close();
                    ByteArrayContainer byteArrayContainer = new ByteArrayContainer(byteArrayOutputStream.toByteArray());
                    DICOM_CACHE.putDataset(string2, string, byteArrayContainer, string3);
                }
                catch (IOException iOException) {
                    LOGGER.error("Failed to put dataset into cache", (Throwable)iOException);
                }
            } else {
                DICOM_CACHE.putDataset(string2, string, attributes);
            }
        }
        this.initFromCachedDicomObject(attributes);
    }

    protected synchronized void initFromCachedDicomObject(Attributes attributes) {
        if (this.getDataInfo() != null && !((IObjectInfo)this.getDataInfo()).getSOPInstanceUID().equals(attributes.getString(524312))) {
            throw new IllegalArgumentException("different SOP Instance UID: " + ((IObjectInfo)this.getDataInfo()).getSOPInstanceUID() + " vs. " + attributes.getString(524312));
        }
        this.loadState = 2;
        this.setDicomObject(attributes);
        if (this.imageInformation != null) {
            this.imageInformation.reinit(attributes);
        }
        this.replaceBySmallCopy(attributes);
        ISeriesData iSeriesData = this.getParent();
        if (iSeriesData != null && !iSeriesData.isStartedBeingLoaded()) {
            iSeriesData.setDicomObject(attributes);
        }
    }

    protected abstract void replaceBySmallCopy(Attributes var1);

    public void dicomDataAvailable(String string, Attributes attributes, boolean bl) {
        this.initFromCachedDicomObject(attributes);
    }

    public void dicomDataError(String string, String string2, Throwable throwable) {
        this.loadState = -1;
        if (!(throwable instanceof FileNotFoundException)) {
            ImpaxEEUtils.handleLoadingProblem((String)string, (String)string2, (Throwable)throwable);
        }
        log.error(string2, throwable);
    }

    public void dicomDataFinished(String string, IDicomDataListener.Status status, Attributes attributes) {
        if (status == IDicomDataListener.Status.Success) {
            if (attributes != null) {
                this.getDicomObject().addAll(attributes);
            }
            this.loadState = 4;
            this.notifyLoadFinished();
            this.parent.notifyObjectLoaded();
        } else if (status == IDicomDataListener.Status.LossySuccess) {
            this.lossyDicomDataFinished();
        }
    }

    public void pixelDataAvailable(String string, IPixelDataInfo iPixelDataInfo, int n) {
    }

    public IDicomDataListener getDataListener() {
        return this;
    }

    @Override
    public String resolveString(int n) {
        if (PrivateTagDictionary.isPrivateTag((int)n) && !PRIVATE_TAG_DICTIONARY.isWrappingPrivateTag(Integer.valueOf(n))) {
            return this.getParent().resolveString(n);
        }
        return super.resolveString(n);
    }

    public String getModality() {
        return this.getParent().getModality();
    }

    public String getSeriesDescription() {
        return this.getParent().getSeriesDescription();
    }

    public boolean storeToCache() {
        this.imageInformation = null;
        return true;
    }

    public void cleanUp() {
        this.listeners = null;
        this.imageInformation = null;
    }

    private synchronized void lossyDicomDataFinished() {
        this.loadState = 1;
        ((IObjectInfo)this.getQueryObject()).setInstanceInfo((IInstanceInfo)IMPAXEEWADOInstanceInfo.singleton);
        this.parent.notifyObjectLoaded();
        if (this.listeners != null) {
            for (IObjectListener iObjectListener : this.listeners) {
                iObjectListener.lossyObjectFinished((IObjectData)this);
            }
        }
    }
}

