/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.impaxee.glue.cycling;

import com.agfa.pacs.base.swing.IComponentFactory;
import com.agfa.pacs.base.swing.progress.IActivityIndicator;
import com.agfa.pacs.base.swing.util.EventUtil;
import com.agfa.pacs.base.swing.util.FocusUtil;
import com.agfa.pacs.base.swing.util.GUI;
import com.agfa.pacs.base.swing.util.ProgressUtil;
import com.agfa.pacs.base.util.Product;
import com.agfa.pacs.config.ConfigurationProviderFactory;
import com.agfa.pacs.data.shared.dicom.Level;
import com.agfa.pacs.data.shared.lw.DataInfoUtilities;
import com.agfa.pacs.data.shared.lw.IDataInfo;
import com.agfa.pacs.data.shared.lw.IDataInfoSource;
import com.agfa.pacs.data.shared.lw.IDataProviderIdentifier;
import com.agfa.pacs.data.shared.lw.IObjectInfo;
import com.agfa.pacs.data.shared.lw.IPatientInfo;
import com.agfa.pacs.data.shared.lw.ISeriesInfo;
import com.agfa.pacs.data.shared.lw.IStudyInfo;
import com.agfa.pacs.data.shared.node.IDataInfoNode;
import com.agfa.pacs.data.shared.util.PatientKeyUtils;
import com.agfa.pacs.impaxee.PerformanceProfiler;
import com.agfa.pacs.impaxee.config.Config;
import com.agfa.pacs.impaxee.data.manager.DataManager;
import com.agfa.pacs.impaxee.data.manager.DataManagerListenerAdapter;
import com.agfa.pacs.impaxee.data.manager.IDataManagerListener;
import com.agfa.pacs.impaxee.data.manager.IDisplaySetListener;
import com.agfa.pacs.impaxee.glue.cycling.LoadRequest;
import com.agfa.pacs.impaxee.glue.cycling.Messages;
import com.agfa.pacs.impaxee.glue.data.ImpaxEEPatientData;
import com.agfa.pacs.impaxee.glue.data.ImpaxEEStudyContainer;
import com.agfa.pacs.impaxee.glue.data.ImpaxEEStudyData;
import com.agfa.pacs.impaxee.glue.monitoring.AutomaticStudyMonitoring;
import com.agfa.pacs.impaxee.gui.ComponentFactory;
import com.agfa.pacs.impaxee.hanging.IDisplaySet;
import com.agfa.pacs.impaxee.hanging.IHanging;
import com.agfa.pacs.impaxee.hanging.IHangingSession;
import com.agfa.pacs.impaxee.hanging.IPatientRepresentation;
import com.agfa.pacs.impaxee.hanging.IStudyContainer;
import com.agfa.pacs.impaxee.hanging.gui.UnsavedHangingsManager;
import com.agfa.pacs.impaxee.hanging.impl.HangingCaseDisplay;
import com.agfa.pacs.impaxee.sessions.SessionBuilder;
import com.agfa.pacs.listtext.base.Base;
import com.agfa.pacs.listtext.cycling.ICycleListProvider;
import com.agfa.pacs.listtext.cycling.RelevancyManager;
import com.agfa.pacs.listtext.cycling.impl.AbstractCycleListProvider;
import com.agfa.pacs.listtext.cycling.prefs.CycleListPreferences;
import com.agfa.pacs.listtext.cycling.prefs.ICycleListPreferences;
import com.agfa.pacs.listtext.lta.base.LTAUtil;
import com.agfa.pacs.listtext.lta.filter.FilterHelper;
import com.agfa.pacs.listtext.lta.filter.FilterUtilities;
import com.agfa.pacs.listtext.lta.filter.IPersistantFilter;
import com.agfa.pacs.listtext.lta.util.SendError;
import com.agfa.pacs.listtext.lta.util.SimplePatient;
import com.agfa.pacs.listtext.lta.util.referencedobject.ReferencedObjectUtilities;
import com.agfa.pacs.listtext.swingx.util.SwingUtilities2;
import com.agfa.pacs.logging.ALogger;
import com.agfa.pacs.security.permission.Permissions;
import com.tiani.base.data.IPatientData;
import com.tiani.base.data.IStudyData;
import com.tiani.config.LayoutConfig;
import com.tiani.gui.util.panel.flexible.FlexiblePanel;
import com.tiani.jvision.main.JVision2;
import com.tiani.jvision.main.MainFrame2;
import com.tiani.jvision.patinfo.DataSelectionListenerAdapter;
import com.tiani.jvision.patinfo.DataSelectionManager;
import com.tiani.jvision.patinfo.IDataSelectionListener;
import com.tiani.util.message.Message;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Point;
import java.awt.Window;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.dcm4che3.data.Attributes;

public class ImpaxEECycleListProvider
extends AbstractCycleListProvider {
    private static ALogger logger = ALogger.getLogger(ImpaxEECycleListProvider.class);
    private static final long FIX_OCCUPIED_MEMORY = Product.isReducedVersion() ? 0x5000000 : 0xB400000;
    public static final long AVAILABLE_MEMORY = Math.round((double)(Runtime.getRuntime().maxMemory() - FIX_OCCUPIED_MEMORY) * Config.impaxee.jvision.memory.FillLimit.get());
    private static final String ID = "IMPAX_EE";
    protected static final int TEXT_AREA_CANCEL_INIT_REQUEST_EVENT = eventEngine.getEventID("TEXT_AREA_CANCEL_INIT_REQUEST");
    private static ImpaxEECycleListProvider instance;
    private PerformanceProfiler profiler = PerformanceProfiler.getInstance();
    private IDataSelectionListener dataSelectionListener;
    private RemovingDataManagerListener dataManagerListener;
    private final DataManager dm = DataManager.getInstance();
    private SessionBuilder lastSession = null;
    private final ICycleListPreferences prefs;
    private AtomicReference<Set<String>> blindReportedStudies = new AtomicReference();
    private IActivityIndicator activityIndicator;

    public static ImpaxEECycleListProvider getInstance() {
        return instance;
    }

    public ImpaxEECycleListProvider() {
        instance = this;
        this.dataSelectionListener = new PatientAndHangingDataSelectionListener();
        this.dataManagerListener = new RemovingDataManagerListener();
        this.prefs = new CycleListPreferences(ConfigurationProviderFactory.getConfig());
        DataSelectionManager.getInstance().addListener(this.dataSelectionListener);
        DataManager.getInstance().addListener((IDataManagerListener)this.dataManagerListener);
        DataManager.getInstance().addDisplaySetListener((IDisplaySetListener)this.dataManagerListener);
        AutomaticStudyMonitoring.init();
    }

    public String getId() {
        return ID;
    }

    public IStudyInfo[] getSessions() {
        HashSet<IStudyInfo> hashSet = new HashSet<IStudyInfo>();
        for (IPatientRepresentation iPatientRepresentation : DataManager.getInstance().getPatientRepresentations()) {
            for (IHangingSession iHangingSession : iPatientRepresentation.getSessions()) {
                if (iHangingSession.getStudyInstance() == null) continue;
                hashSet.add(iHangingSession.getStudyInstance());
            }
        }
        return hashSet.toArray(new IStudyInfo[hashSet.size()]);
    }

    public String getDescription() {
        return "ImpaxEE";
    }

    public IStudyInfo[] getStudies() {
        ArrayList<IStudyInfo> arrayList = new ArrayList<IStudyInfo>();
        for (IStudyData iStudyData : DataManager.getInstance().getAllStudies()) {
            IStudyInfo iStudyInfo = (IStudyInfo)((ImpaxEEStudyData)iStudyData).getDataInfo();
            if (iStudyInfo == null || arrayList.contains(iStudyInfo)) continue;
            arrayList.add(iStudyInfo);
        }
        return arrayList.toArray(new IStudyInfo[0]);
    }

    public void setStudiesForBlindReporting(Set<String> set) {
        if (set != null && !set.isEmpty()) {
            this.blindReportedStudies.set(set);
        }
    }

    public IStudyInfo[] getDisplayedStudies() {
        return this.getDisplayedStudies(DataSelectionManager.getInstance().getCurrentPatient());
    }

    public IPatientInfo getDisplayedPatient() {
        IPatientData iPatientData;
        IPatientRepresentation iPatientRepresentation = DataSelectionManager.getInstance().getCurrentPatient();
        if (iPatientRepresentation != null && (iPatientData = iPatientRepresentation.getPatientData()) instanceof ImpaxEEPatientData) {
            return (IPatientInfo)((ImpaxEEPatientData)iPatientData).getDataInfo();
        }
        return null;
    }

    private IStudyInfo[] getDisplayedStudies(IPatientRepresentation iPatientRepresentation) {
        ArrayList<IStudyInfo> arrayList = new ArrayList<IStudyInfo>();
        if (iPatientRepresentation != null) {
            for (IStudyData iStudyData : iPatientRepresentation.getPatientData().getStudies()) {
                if (!(iStudyData instanceof ImpaxEEStudyData)) continue;
                arrayList.add((IStudyInfo)((ImpaxEEStudyData)iStudyData).getDataInfo());
            }
        }
        return arrayList.toArray(new IStudyInfo[0]);
    }

    public boolean isStudyDisplayed(String string) {
        if (string != null) {
            IStudyInfo[] iStudyInfoArray;
            IStudyInfo[] iStudyInfoArray2 = iStudyInfoArray = this.getDisplayedStudies();
            int n = iStudyInfoArray.length;
            int n2 = 0;
            while (n2 < n) {
                IStudyInfo iStudyInfo = iStudyInfoArray2[n2];
                if (string.equals(iStudyInfo.getStudyUID())) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    public boolean mergePatientsAndDisplay(IPatientInfo iPatientInfo, List<? extends IDataInfo> list) throws Exception {
        List list2 = DataInfoUtilities.getLevel(list, IPatientInfo.class);
        ArrayList<String> arrayList = new ArrayList<String>();
        String string = iPatientInfo.getKey();
        IPatientInfo iPatientInfo2 = null;
        for (Object object : list2) {
            if (!object.getKey().equals(string)) {
                arrayList.add(object.getKey());
                continue;
            }
            iPatientInfo2 = object;
        }
        if (iPatientInfo2 != null) {
            Object object;
            this.dm.markTemporaryMerged(string, arrayList);
            object = new ArrayList();
            List list3 = DataInfoUtilities.extractChildrenBelongingToParent((IDataInfo)iPatientInfo2, list);
            object.addAll(list3);
            list.removeAll(list3);
            object.addAll(list);
            return this.addToCycleList((List<? extends IDataInfo>)object, null, false, true, null, true);
        }
        this.dm.markTemporaryMerged(string, arrayList);
        return this.addToCycleList(list, null, false, true, null, true);
    }

    protected boolean areMultiplePatientsAllowed() {
        return !Config.impaxee.jvision.SEQPANEL.LoadOnlyOnePatient.get();
    }

    public boolean isSupportingPatientMerge() {
        return true;
    }

    public boolean canPatientBeMerged(IPatientInfo iPatientInfo) {
        if (this.dm.getLoadedPatientData(iPatientInfo.getKey()) != null) {
            return false;
        }
        return !this.dm.isTemporaryMergeActiveForPatient(iPatientInfo.getKey());
    }

    public boolean isPatientMergedTo(IPatientInfo iPatientInfo, IPatientInfo iPatientInfo2) {
        return this.dm.isPatientMergedTo(iPatientInfo.getKey(), iPatientInfo2.getKey());
    }

    public void handleDisplayedStudiesChanged(IStudyInfo[] iStudyInfoArray, IStudyData iStudyData, IStudyData iStudyData2) {
        if (iStudyData != null) {
            int n = 0;
            int n2 = 0;
            while (n2 < iStudyInfoArray.length) {
                if (iStudyInfoArray[n2].getKey().equals(iStudyData.getKey())) {
                    n = n2;
                    break;
                }
                ++n2;
            }
            if (n != 0) {
                IStudyInfo iStudyInfo = iStudyInfoArray[n];
                iStudyInfoArray[n] = iStudyInfoArray[0];
                iStudyInfoArray[0] = iStudyInfo;
            }
        }
        if (this.isTextAreaSyncEnabled()) {
            this.syncTextArea(iStudyInfoArray, false);
        }
        this.fireDisplayedStudiesChanged(iStudyInfoArray, iStudyData2 == null ? null : (IStudyInfo)iStudyData2.getQueryObject());
    }

    public void showMessagePopup(final String string, final Integer n) {
        EventUtil.invoke((Runnable)new Runnable(){

            @Override
            public void run() {
                Point point;
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("<html><center>");
                stringBuilder.append(string);
                stringBuilder.append("</center></html>");
                Component component = JVision2.getMainFrame().getSeriesPalette(true).getUIComponent();
                if (component.isShowing()) {
                    point = component.getLocationOnScreen();
                    point.x += 5;
                    point.y -= 5;
                } else {
                    FlexiblePanel flexiblePanel = JVision2.getMainFrame().getTopToolbar();
                    if (flexiblePanel.isShowing()) {
                        point = flexiblePanel.getLocationOnScreen();
                        point.x += 5;
                        point.y += flexiblePanel.getHeight() - 5;
                    } else {
                        point = new Point(5, 5);
                    }
                }
                SwingUtilities2.showFloatingMessageWindow((String)stringBuilder.toString(), (Window)JVision2.getMainFrame().getOwner(), (IComponentFactory)ComponentFactory.instance, (Point)point, (Dimension)GUI.getScaledDiagnosticDimension((int)250, (int)85), (boolean)true, (Integer)n, (boolean)true, null);
            }
        });
    }

    public void removeAllFromCycleList() {
        DataManager.getInstance().removeAllPatients(true);
    }

    public static List<? extends IDataInfo> getDataToLoad(List<? extends IDataInfo> list) throws Exception {
        List list2 = ImpaxEECycleListProvider.getDataToOpen(list, (ICycleListPreferences)ImpaxEECycleListProvider.getInstance().getCycleListPreferences());
        List list3 = ImpaxEECycleListProvider.checkToAddReferencedObjects((List)list2, (ICycleListPreferences)ImpaxEECycleListProvider.getInstance().getCycleListPreferences(), (ICycleListProvider)ImpaxEECycleListProvider.getInstance());
        List list4 = DataInfoUtilities.cloneData((List)((List)list3.get(0)));
        return list4;
    }

    public synchronized void showActivityIndicator() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (ImpaxEECycleListProvider.this.activityIndicator != null) {
                    return;
                }
                try {
                    ImpaxEECycleListProvider.this.activityIndicator = ProgressUtil.createActivityIndicator((Component)JVision2.getMainFrame(), (int)LayoutConfig.getInstance().getScreenColumns(), (boolean)true, (IActivityIndicator.DisplayMode)IActivityIndicator.DisplayMode.LAYER);
                    ImpaxEECycleListProvider.this.activityIndicator.setText(Messages.getString("ImpaxEECycleListProvider.FetchData"));
                    ImpaxEECycleListProvider.this.activityIndicator.show();
                }
                catch (Exception exception) {}
            }
        });
    }

    public synchronized void hideActivityIndicator() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (ImpaxEECycleListProvider.this.activityIndicator != null) {
                    ImpaxEECycleListProvider.this.activityIndicator.close();
                    ImpaxEECycleListProvider.this.activityIndicator = null;
                }
            }
        });
    }

    protected boolean addToCycleListImpl(final List<List<? extends IDataInfo>> list, final Object object, final boolean bl, final boolean bl2, final String string, boolean bl3) {
        if (!bl3 && list.size() > 1) {
            this.showMultiplePatientWarning();
            return false;
        }
        if (!Permissions.getInstance().isAllowed("ViewUnreported")) {
            for (List<? extends IDataInfo> object22 : list) {
                List list2 = DataInfoUtilities.getLevel(object22, (Level)Level.Study);
                for (IStudyInfo iStudyInfo : list2) {
                    String string2 = iStudyInfo.getString(3276810);
                    if ("READ".equals(string2)) continue;
                    logger.warn("Trying to open unreported Study:" + iStudyInfo.getKey() + " prohibited");
                    SendError.sendErrorMessage((Exception)new Exception("You cannot review unreported study!"));
                    return false;
                }
            }
        }
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                ImpaxEECycleListProvider.this.addToImageArea(list, object, bl, bl2, string);
            }
        };
        if (bl2) {
            new Thread(runnable, "ImpaxEE-AddToCycleList-Thread").start();
        } else {
            runnable.run();
        }
        return true;
    }

    protected boolean addToCycleList(List<? extends IDataInfo> list, Object object, boolean bl, boolean bl2, String string, boolean bl3) throws Exception {
        for (IStudyInfo iStudyInfo : DataInfoUtilities.getLevel(list, IStudyInfo.class)) {
            this.addStudy2Profiler(iStudyInfo);
        }
        return super.addToCycleList(list, object, bl, bl2, string, bl3);
    }

    protected void addStudy2Profiler(IStudyInfo iStudyInfo) {
        this.profiler.addStudyOpened(iStudyInfo, false);
    }

    protected void showMultiplePatientWarning() {
        Message.warning((String)Messages.getString("ImpaxEECycleListProvider.MultipleUnallowedOpenTitle"), (Object)Messages.getString("ImpaxEECycleListProvider.MultipleUnallowedOpenMessage"));
    }

    protected boolean addToCycleListPriorImpl(IStudyInfo iStudyInfo, List<? extends IDataInfo> list) {
        IPatientRepresentation iPatientRepresentation = this.dm.getPatientRepresentation(iStudyInfo.getTreeParent().getKey());
        if (iPatientRepresentation == null || iPatientRepresentation.getStudyContainers().isEmpty()) {
            ArrayList<List<? extends IDataInfo>> arrayList = new ArrayList<List<? extends IDataInfo>>();
            arrayList.add(list);
            this.addToCycleListImpl(arrayList, null, false, false, null, false);
            return true;
        }
        List list2 = DataInfoUtilities.getLevel(list, (Level)Level.Study);
        for (IStudyContainer iStudyContainer : iPatientRepresentation.getStudyContainers()) {
            for (IStudyInfo iStudyInfo2 : list2) {
                int n = ((ImpaxEEStudyContainer)iStudyContainer).addPrior(iStudyInfo2);
                iStudyContainer.loadRelevantPrior(n);
            }
        }
        FocusUtil.requestFocusAfterImageLoading((Window)JVision2.getMainFrame(), (Window)LTAUtil.getMainWindow());
        return true;
    }

    protected boolean removeFromCycleListImpl(List<? extends IDataInfo> list) {
        logger.debug("Trying to REMOVE " + list.size() + " objects from the cyclelist...");
        ArrayList<IPatientData> arrayList = new ArrayList<IPatientData>(2);
        ArrayList<Object> arrayList2 = new ArrayList<Object>(2);
        block0: for (IDataInfo iDataInfo : list) {
            Object object;
            if (iDataInfo instanceof IPatientInfo && !arrayList.contains(iDataInfo)) {
                object = this.dm.getPatientRepresentation(iDataInfo.getKey());
                if (object == null) continue;
                arrayList.add(object.getPatientData());
                continue;
            }
            if (iDataInfo instanceof IStudyInfo && !arrayList2.contains(iDataInfo)) {
                object = this.dm.getStudy(iDataInfo.getKey());
                if (object != null) {
                    arrayList2.add(object);
                    continue;
                }
                boolean bl = false;
                for (IPatientRepresentation iPatientRepresentation : this.dm.getPatientRepresentations()) {
                    for (IHangingSession iHangingSession : iPatientRepresentation.getSessions()) {
                        if (iHangingSession.getStudyInstance() != iDataInfo) continue;
                        IDisplaySet[] iDisplaySetArray = iHangingSession.getSplitAndSortRuntime().getDisplaySets();
                        int n = iDisplaySetArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            IDisplaySet iDisplaySet = iDisplaySetArray[n2];
                            if (!arrayList2.contains(iDisplaySet.getStudy())) {
                                arrayList2.add(iDisplaySet.getStudy());
                            }
                            ++n2;
                        }
                        bl = true;
                        break;
                    }
                    if (bl) continue block0;
                }
                continue;
            }
            if (iDataInfo instanceof ISeriesInfo) {
                throw new UnsupportedOperationException();
            }
            if (!(iDataInfo instanceof IObjectInfo)) continue;
            throw new UnsupportedOperationException();
        }
        if (arrayList.isEmpty()) {
            arrayList = null;
        }
        if (arrayList2.isEmpty()) {
            arrayList2 = null;
        }
        UnsavedHangingsManager unsavedHangingsManager = new UnsavedHangingsManager();
        if (arrayList != null) {
            for (IPatientData iPatientData : arrayList) {
                unsavedHangingsManager.manageSave((JFrame)JVision2.getMainFrame(), DataManager.getInstance().getPatientRepresentation(iPatientData.getKey()), null);
            }
        }
        if (arrayList2 != null) {
            for (IStudyData iStudyData : arrayList2) {
                unsavedHangingsManager.manageSave((JFrame)JVision2.getMainFrame(), DataManager.getInstance().getPatientRepresentation(iStudyData.getParent().getKey()), iStudyData);
            }
        }
        if (arrayList2 != null) {
            ArrayList<IHangingSession> arrayList3 = new ArrayList<IHangingSession>();
            for (Object object : arrayList2) {
                IPatientRepresentation iPatientRepresentation;
                iPatientRepresentation = this.dm.getPatientRepresentation(object.getParent().getKey());
                String string = object.getKey();
                IDisplaySet[] iDisplaySetArray = iPatientRepresentation.getDecompositionRuntime().getDisplaySets();
                int n = iDisplaySetArray.length;
                int n3 = 0;
                while (n3 < n) {
                    IHangingSession iHangingSession;
                    iHangingSession = iDisplaySetArray[n3];
                    if (iHangingSession.getOneObject().getParent().getParent().getKey().equals(string)) {
                        arrayList3.add(iHangingSession);
                    }
                    ++n3;
                }
            }
            this.dm.removeDisplaySet(arrayList3.toArray(new IDisplaySet[arrayList3.size()]), true);
        }
        if (arrayList != null) {
            for (IPatientData iPatientData : arrayList) {
                IPatientRepresentation iPatientRepresentation = this.dm.getPatientRepresentation(iPatientData.getKey());
                this.dm.removeDisplaySet(iPatientRepresentation.getDecompositionRuntime().getDisplaySets(), true);
            }
        }
        return true;
    }

    protected boolean displayFromCycleListImpl(List<? extends IDataInfo> list) {
        List list2 = DataInfoUtilities.getLevel(list, (Level)Level.Study);
        if (!list2.isEmpty()) {
            DataSelectionManager dataSelectionManager = DataSelectionManager.getInstance();
            if (this.lastSession != null && ((IStudyInfo)list2.get(0)).getTreeParent().getKey().equals(this.lastSession.getPatientKey())) {
                Collection collection = this.lastSession.getContainedStudies();
                if (!collection.isEmpty()) {
                    IStudyData iStudyData = (IStudyData)collection.iterator().next();
                    List list3 = DataInfoUtilities.cloneAndCutBelowStudies(Collections.singletonList((IStudyInfo)((ImpaxEEStudyData)iStudyData).getDataInfo()));
                    RelevancyManager.getInstance().startSearchRelevant(null, list3);
                }
                this.lastSession.display();
                FocusUtil.requestFocusAfterImageLoading((Window)JVision2.getMainFrame(), (Window)LTAUtil.getMainWindow());
                return true;
            }
            dataSelectionManager.displayCurrentPatient(((IStudyInfo)list2.get(0)).getTreeParent().getKey());
            FocusUtil.requestFocusAfterImageLoading((Window)JVision2.getMainFrame(), (Window)LTAUtil.getMainWindow());
            this.lastSession = null;
            return true;
        }
        return false;
    }

    private IStudyInfo[] extractStudyInfos(IStudyData[] iStudyDataArray) {
        ArrayList<IStudyInfo> arrayList = new ArrayList<IStudyInfo>();
        IStudyData[] iStudyDataArray2 = iStudyDataArray;
        int n = iStudyDataArray.length;
        int n2 = 0;
        while (n2 < n) {
            IStudyInfo iStudyInfo;
            IStudyData iStudyData = iStudyDataArray2[n2];
            IStudyInfo iStudyInfo2 = iStudyInfo = iStudyData instanceof ImpaxEEStudyData ? (IStudyInfo)((ImpaxEEStudyData)iStudyData).getDataInfo() : null;
            if (iStudyData != null) {
                arrayList.add(iStudyInfo);
            }
            ++n2;
        }
        return arrayList.toArray(new IStudyInfo[arrayList.size()]);
    }

    protected void handleStudiesAdded(IStudyData[] iStudyDataArray) {
        this.fireStudiesAdded(this.extractStudyInfos(iStudyDataArray));
    }

    protected void handleStudiesRemoved(IStudyData[] iStudyDataArray) {
        this.fireStudiesRemoved(this.extractStudyInfos(iStudyDataArray));
    }

    protected void handleAllStudiesRemoved() {
        this.fireAllStudiesRemoved();
    }

    private String getLoggingKey(IDataInfo iDataInfo) {
        return PatientKeyUtils.generatePatientKey((String)iDataInfo.getString(0x100020), null, (String)iDataInfo.getString(0x100021));
    }

    private void addToImageArea(List<List<? extends IDataInfo>> list, Object object, boolean bl, boolean bl2, String string) {
        try {
            this.showActivityIndicator();
            DataManager.getInstance().setPreferablyLoadKeyImagesEnabled(this.prefs.isPreferredLoadingEnabled());
            boolean bl3 = true;
            if (!bl2 && !EventQueue.isDispatchThread()) {
                Thread.currentThread().setPriority(1);
            }
            Iterator<List<? extends IDataInfo>> iterator = list.iterator();
            while (iterator.hasNext()) {
                List list2;
                List<IDataInfo> list3 = iterator.next();
                iterator.remove();
                IPatientInfo iPatientInfo = (IPatientInfo)DataInfoUtilities.getLevel(list3, IPatientInfo.class).get(0);
                if (Base.isUsingThinArchive()) {
                    this.checkAndExpandThinSliceArchive(list3);
                }
                if (this.checkMemory(list3)) {
                    return;
                }
                LoadRequest loadRequest = new LoadRequest(bl && Base.isLoadRelevantWith());
                Set set = this.blindReportedStudies.getAndSet(null);
                if (set != null) {
                    loadRequest.setBlindReportedStudies(set);
                }
                loadRequest.setDisplayedPatient(bl3);
                if (string != null) {
                    loadRequest.setPreferredHanging(string);
                    HangingCaseDisplay.prepareWaitForHP();
                }
                List list4 = DataInfoUtilities.getObjectLevel(list3);
                logger.info("Study expanded");
                loadRequest.setLoadAsSingleDisplay(object);
                SessionBuilder sessionBuilder = loadRequest.loadData(list4);
                if (bl3) {
                    this.lastSession = sessionBuilder;
                }
                logger.info("Patient " + this.getLoggingKey((IDataInfo)iPatientInfo) + ": " + list4.size() + " objects ADDED to the cyclelist");
                if (bl3 && bl2 && !(list2 = DataInfoUtilities.getLevel((Collection)list4, (Level)Level.Study)).isEmpty()) {
                    this.displayFromCycleList(Collections.singletonList((IStudyInfo)list2.get(0)));
                }
                bl3 = false;
                logger.info("Loading finished");
                if (EventQueue.isDispatchThread()) continue;
                Thread.currentThread().setPriority(1);
            }
        }
        finally {
            this.hideActivityIndicator();
        }
    }

    private boolean studyComplete(IStudyInfo iStudyInfo) {
        if (!iStudyInfo.childrenAvailable()) {
            return false;
        }
        int n = iStudyInfo.getInt(2101766);
        return n == iStudyInfo.children().size();
    }

    private void checkAndExpandThinSliceArchive(List<IDataInfo> list) {
        for (IDataInfo list22 : list) {
            if (list22.getHierarchyLevel().compareTo((Enum)Level.Study) <= 0) continue;
            logger.info("Thin-slice handling not on series/object level");
            return;
        }
        List list2 = DataInfoUtilities.getLevel(list, IStudyInfo.class);
        for (IStudyInfo iStudyInfo : list2) {
            IDataProviderIdentifier iDataProviderIdentifier = iStudyInfo.getSource().getIdentifier();
            String string = iDataProviderIdentifier.getPropertiesOwner().properties().getProperty("thinSliceArchive");
            if (string == null) continue;
            list.addAll(ImpaxEECycleListProvider.expandThinSliceArchive(iStudyInfo, Base.getConfiguredDataInfoNodeByName((String)string)));
        }
    }

    public static List<IObjectInfo> expandThinSliceArchive(IStudyInfo iStudyInfo, IDataInfoNode iDataInfoNode) {
        if (iDataInfoNode == null) {
            return Collections.emptyList();
        }
        try {
            Object object2;
            IPersistantFilter iPersistantFilter = FilterUtilities.getStudyForUID((String)iStudyInfo.getStudyUID());
            iPersistantFilter.setMinLevel(Level.Series);
            IDataInfo iDataInfo = FilterHelper.performSyncSearch((IPersistantFilter)iPersistantFilter, (IDataInfoSource)iDataInfoNode);
            List list = DataInfoUtilities.getLevel((IDataInfo)iDataInfo, ISeriesInfo.class);
            List list2 = DataInfoUtilities.getLevel((IDataInfo)iStudyInfo, ISeriesInfo.class);
            HashSet<String> hashSet = new HashSet<String>();
            for (Object object2 : list2) {
                hashSet.add(object2.getSeriesUID());
            }
            object2 = new ArrayList(256);
            for (ISeriesInfo iSeriesInfo : list) {
                if (hashSet.contains(iSeriesInfo.getSeriesUID())) continue;
                iSeriesInfo.getAttributes().setProperty("ThinArchive", (Object)true);
                iStudyInfo.addChild((IDataInfo)iSeriesInfo);
                object2.addAll(DataInfoUtilities.getLevel((IDataInfo)iSeriesInfo, IObjectInfo.class));
            }
            return object2;
        }
        catch (Exception exception) {
            logger.error("Thin slice archive search failed", (Throwable)exception);
            Message.warning((Object)Messages.getString("ImpaxEECycleListProvider.ThinSliceSearchFailed"));
            return Collections.emptyList();
        }
    }

    private boolean checkMemory(List<? extends IDataInfo> list) {
        if (Product.isCDViewer()) {
            return false;
        }
        int n = 0;
        for (IDataInfo iDataInfo : list) {
            if (iDataInfo instanceof IObjectInfo) {
                ++n;
                continue;
            }
            if (iDataInfo instanceof ISeriesInfo) {
                n += iDataInfo.getInt(2101769);
                continue;
            }
            if (iDataInfo instanceof IStudyInfo) {
                n += iDataInfo.getInt(2101768);
                continue;
            }
            if (!(iDataInfo instanceof IPatientInfo)) continue;
            for (IDataInfo iDataInfo2 : DataInfoUtilities.getLevel((IDataInfo)iDataInfo, (Level)Level.Study)) {
                n += iDataInfo2.getInt(2101768);
            }
        }
        long l = this.dm.getRequiredMemory(n);
        if (AVAILABLE_MEMORY < l) {
            logger.info("Not enough memory for patient loading.Required:" + l);
            EventUtil.invokeSynchronous((Runnable)new Runnable(){

                @Override
                public void run() {
                    MainFrame2.getFrames()[0].toFront();
                    MainFrame2.getFrames()[0].requestFocus();
                    JOptionPane.showMessageDialog(MainFrame2.getFrames()[0], Messages.getString("ImpaxEECycleListProvider.TooMuchMemory"));
                }
            });
            return true;
        }
        return false;
    }

    public void blankDisplay() {
        DataSelectionManager.getInstance().setCurrentPatient(null);
        if (JVision2.getMainFrame() != null) {
            JVision2.getMainFrame().clearAllDisplays();
        }
    }

    public List<Window> getAllWindows() {
        if (JVision2.getMainFrame() == null) {
            return Collections.emptyList();
        }
        return Collections.singletonList(JVision2.getMainFrame());
    }

    public ICycleListPreferences getCycleListPreferences() {
        return this.prefs;
    }

    public boolean supportsPriorRules() {
        return true;
    }

    public boolean supportsThinThickArchives() {
        return true;
    }

    public boolean markPatientsMerged(ReferencedObjectUtilities.ReferencedResult referencedResult) {
        Object object2;
        if (referencedResult.getMergedDataCount() > 1) {
            JOptionPane.showMessageDialog(null, Messages.getString("TemporaryMergeSession.MultipleMerge.Message"), Messages.getString("TemporaryMergeSession.MultipleMerge.Title"), 0);
            return false;
        }
        List list = DataInfoUtilities.mergeDuplicates((List)referencedResult.toOpen);
        List list2 = DataInfoUtilities.getLevel((Collection)list, IPatientInfo.class);
        String string = referencedResult.getMergedData(0).getObject().getTreeParent().getTreeParent().getTreeParent().getKey();
        StringBuilder stringBuilder = new StringBuilder();
        String string2 = "";
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Object object2 : list2) {
            if (!object2.getKey().equals(string)) {
                arrayList.add(object2.getKey());
            }
            SimplePatient simplePatient = new SimplePatient(object2);
            if (object2.getKey().equals(string)) {
                string2 = simplePatient.toString();
            }
            stringBuilder.append("- ").append(simplePatient.toString()).append('\n');
        }
        object2 = MessageFormat.format(Messages.getString("TemporaryMergeSession"), stringBuilder.toString(), string2);
        int n = JOptionPane.showConfirmDialog(null, object2, Messages.getString("TemporaryMergePatientsAction_TemporaryPatientMerge"), 2, 2, UIManager.getIcon("OptionPane.warningIcon"));
        if (n == 2) {
            return false;
        }
        this.dm.markTemporaryMerged(string, arrayList);
        Collections.sort(referencedResult.toOpen, new MergedPatientSorter(string));
        return true;
    }

    private static class MergedPatientSorter
    implements Comparator<IDataInfo> {
        private String patientKey;

        public MergedPatientSorter(String string) {
            this.patientKey = string;
        }

        @Override
        public int compare(IDataInfo iDataInfo, IDataInfo iDataInfo2) {
            boolean bl;
            boolean bl2 = PatientKeyUtils.generatePatientKey((Attributes)iDataInfo.getAttributes()).equals(this.patientKey);
            if (bl2 ^ (bl = PatientKeyUtils.generatePatientKey((Attributes)iDataInfo2.getAttributes()).equals(this.patientKey))) {
                return 0;
            }
            return bl2 ? -1 : 1;
        }
    }

    private class PatientAndHangingDataSelectionListener
    extends DataSelectionListenerAdapter {
        private PatientAndHangingDataSelectionListener() {
        }

        public void newPatientSelected(DataSelectionManager dataSelectionManager, IPatientRepresentation iPatientRepresentation, IPatientRepresentation iPatientRepresentation2, IPatientRepresentation iPatientRepresentation3) {
            IStudyContainer iStudyContainer;
            IHanging iHanging = dataSelectionManager.getActiveHanging();
            IStudyData iStudyData = null;
            if (iHanging != null && (iStudyContainer = iHanging.getStudyContainer()) != null) {
                iStudyData = iStudyContainer.getBaseStudy();
            }
            if (iStudyData != null) {
                ImpaxEECycleListProvider.this.handleDisplayedStudiesChanged(ImpaxEECycleListProvider.this.getDisplayedStudies(iPatientRepresentation2), iStudyData, iStudyData);
            } else {
                ImpaxEECycleListProvider.this.handleDisplayedStudiesChanged(null, null, null);
            }
        }

        public void newActiveStudySelected(IStudyData iStudyData) {
            IStudyData iStudyData2 = null;
            IHanging iHanging = DataSelectionManager.getInstance().getActiveHanging();
            if (iHanging != null && iHanging.getStudyContainer() != null) {
                iStudyData2 = iHanging.getStudyContainer().getBaseStudy();
            }
            ImpaxEECycleListProvider.this.handleDisplayedStudiesChanged(ImpaxEECycleListProvider.this.getDisplayedStudies(), iStudyData, iStudyData2);
        }
    }

    private class RemovingDataManagerListener
    extends DataManagerListenerAdapter
    implements IDisplaySetListener {
        private RemovingDataManagerListener() {
        }

        public void patientRemoved(IPatientRepresentation iPatientRepresentation) {
            logger.debug("Handling patient removal notification (key: " + ImpaxEECycleListProvider.this.getLoggingKey(iPatientRepresentation.getPatientData().getQueryObject()) + ")");
            Collection collection = iPatientRepresentation.getPatientData().getStudies();
            LinkedList<IStudyInfo> linkedList = new LinkedList<IStudyInfo>();
            for (IStudyData iStudyData : collection) {
                if (!(iStudyData instanceof ImpaxEEStudyData)) continue;
                linkedList.add((IStudyInfo)((ImpaxEEStudyData)iStudyData).getDataInfo());
            }
            if (ImpaxEECycleListProvider.this.dm.getPatientDatas().size() == 1) {
                if (ImpaxEECycleListProvider.this.dm.getPatientDatas().get(0) == iPatientRepresentation.getPatientData()) {
                    ImpaxEECycleListProvider.this.handleAllStudiesRemoved();
                }
            } else if (ImpaxEECycleListProvider.this.dm.getPatientDatas().size() == 0) {
                ImpaxEECycleListProvider.this.handleAllStudiesRemoved();
            }
        }

        public void studyAdded(IStudyData iStudyData) {
            ImpaxEECycleListProvider.this.handleStudiesAdded(new IStudyData[]{iStudyData});
        }

        public void studyRemoved(IStudyData iStudyData) {
            logger.info("Handling study removal (" + iStudyData.getStudyInstanceUID() + ")");
            ImpaxEECycleListProvider.this.handleStudiesRemoved(new IStudyData[]{iStudyData});
        }

        public void displaySetAdded(IPatientRepresentation iPatientRepresentation, List<IDisplaySet> list) {
        }

        public void displaySetsRemoved(IDisplaySet[] iDisplaySetArray) {
        }

        public void repaintDisplaySets() {
        }
    }
}

