/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.dicom.exporter.image;

import com.agfa.pacs.listtext.dicom.exporter.image.IImageEncoder;
import com.agfa.pacs.logging.ALogger;
import com.sun.image.codec.jpeg.ImageFormatException;
import com.sun.image.codec.jpeg.JPEGCodec;
import com.sun.image.codec.jpeg.JPEGEncodeParam;
import com.sun.image.codec.jpeg.JPEGImageEncoder;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriter;

public class JPEGEncoder
implements IImageEncoder {
    private static final ALogger log = ALogger.getLogger(JPEGEncoder.class);
    private float compressionRate = 1.0f;
    private Integer dpi = 300;

    @Override
    public void encode(File file, BufferedImage bufferedImage) {
        FileOutputStream fileOutputStream = null;
        try {
            try {
                fileOutputStream = new FileOutputStream(file);
                JPEGImageEncoder jPEGImageEncoder = JPEGCodec.createJPEGEncoder((OutputStream)fileOutputStream);
                JPEGEncodeParam jPEGEncodeParam = jPEGImageEncoder.getDefaultJPEGEncodeParam(bufferedImage);
                jPEGEncodeParam.setDensityUnit(1);
                jPEGEncodeParam.setXDensity(this.dpi.intValue());
                jPEGEncodeParam.setYDensity(this.dpi.intValue());
                jPEGEncodeParam.setQuality(this.compressionRate, false);
                jPEGImageEncoder.setJPEGEncodeParam(jPEGEncodeParam);
                jPEGImageEncoder.encode(bufferedImage);
                ImageIO.write((RenderedImage)bufferedImage, "jpg", fileOutputStream);
            }
            catch (ImageFormatException imageFormatException) {
                log.error("Encoding error" + (Object)((Object)imageFormatException));
                try {
                    if (fileOutputStream != null) {
                        fileOutputStream.close();
                    }
                }
                catch (IOException iOException) {
                    log.error("Error on closing OutputStream" + iOException);
                }
            }
            catch (IOException iOException) {
                log.error("Encoding error" + iOException);
                try {
                    if (fileOutputStream != null) {
                        fileOutputStream.close();
                    }
                }
                catch (IOException iOException2) {
                    log.error("Error on closing OutputStream" + iOException2);
                }
            }
        }
        finally {
            try {
                if (fileOutputStream != null) {
                    fileOutputStream.close();
                }
            }
            catch (IOException iOException) {
                log.error("Error on closing OutputStream" + iOException);
            }
        }
    }

    @Override
    public void setDpi(int n) {
        this.dpi = n;
    }

    @Override
    public void setCompressionRate(float f) {
        this.compressionRate = f;
    }

    @Override
    public void setImageWriter(ImageWriter imageWriter) {
    }
}

