/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.dicom.exporter.image;

import com.agfa.pacs.data.shared.pixel.ImageIOUtils;
import com.agfa.pacs.listtext.dicom.exporter.image.IImageEncoder;
import com.agfa.pacs.logging.ALogger;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import javax.imageio.IIOImage;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.metadata.IIOInvalidTreeException;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.metadata.IIOMetadataNode;
import javax.imageio.stream.FileImageOutputStream;
import org.w3c.dom.NodeList;

public class DefaultImageEncoder
implements IImageEncoder {
    private static final ALogger log = ALogger.getLogger(DefaultImageEncoder.class);
    private ImageWriter imageWriter;
    private ImageWriteParam imageWriteParam = null;
    private int dpi = 300;

    @Override
    public void encode(File file, BufferedImage bufferedImage) {
        ImageWriteParam imageWriteParam = this.imageWriter.getDefaultWriteParam();
        FileImageOutputStream fileImageOutputStream = null;
        try {
            try {
                ImageIOUtils.acquireJAI();
                fileImageOutputStream = new FileImageOutputStream(file);
                try {
                    this.imageWriter.setOutput(fileImageOutputStream);
                    IIOMetadata iIOMetadata = null;
                    iIOMetadata = this.setDpiMetadata(this.imageWriter.getDefaultImageMetadata(new ImageTypeSpecifier(bufferedImage), imageWriteParam));
                    IIOImage iIOImage = new IIOImage(bufferedImage, null, iIOMetadata);
                    this.imageWriter.write(null, iIOImage, imageWriteParam);
                    fileImageOutputStream.flush();
                }
                finally {
                    this.imageWriter.reset();
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
                log.error("Could not find file", (Throwable)fileNotFoundException);
                try {
                    ImageIOUtils.releaseJAI();
                    if (fileImageOutputStream != null) {
                        fileImageOutputStream.close();
                    }
                }
                catch (IOException iOException) {
                    log.error("Error on closing ImageOutputStream", (Throwable)iOException);
                }
            }
            catch (IOException iOException) {
                log.error("Error on initialzing ImageOutputStream", (Throwable)iOException);
                try {
                    ImageIOUtils.releaseJAI();
                    if (fileImageOutputStream != null) {
                        fileImageOutputStream.close();
                    }
                }
                catch (IOException iOException2) {
                    log.error("Error on closing ImageOutputStream", (Throwable)iOException2);
                }
            }
        }
        finally {
            try {
                ImageIOUtils.releaseJAI();
                if (fileImageOutputStream != null) {
                    fileImageOutputStream.close();
                }
            }
            catch (IOException iOException) {
                log.error("Error on closing ImageOutputStream", (Throwable)iOException);
            }
        }
    }

    private IIOMetadata setDpiMetadata(IIOMetadata iIOMetadata) {
        if (iIOMetadata != null) {
            if (iIOMetadata.isReadOnly()) {
                log.warn("Cannot set DPI metadata, because the metadata is read-only.");
                return iIOMetadata;
            }
            String string = "javax_imageio_1.0";
            IIOMetadataNode iIOMetadataNode = (IIOMetadataNode)iIOMetadata.getAsTree(string);
            if (iIOMetadataNode != null) {
                IIOMetadataNode iIOMetadataNode2 = this.getChildNode(iIOMetadataNode, iIOMetadataNode, "Dimension");
                this.setDpiValue(iIOMetadataNode, iIOMetadataNode2, "HorizontalPixelSize");
                this.setDpiValue(iIOMetadataNode, iIOMetadataNode2, "VerticalPixelSize");
                try {
                    iIOMetadata.mergeTree(string, iIOMetadataNode);
                }
                catch (IIOInvalidTreeException iIOInvalidTreeException) {
                    log.error("Error on processing metadata", (Throwable)iIOInvalidTreeException);
                }
            }
        }
        return iIOMetadata;
    }

    private void setDpiValue(IIOMetadataNode iIOMetadataNode, IIOMetadataNode iIOMetadataNode2, String string) {
        String string2 = Float.toString(25.4f / (float)this.dpi);
        this.getChildNode(iIOMetadataNode, iIOMetadataNode2, string).setAttribute("value", string2);
    }

    private IIOMetadataNode getChildNode(IIOMetadataNode iIOMetadataNode, IIOMetadataNode iIOMetadataNode2, String string) {
        IIOMetadataNode iIOMetadataNode3;
        NodeList nodeList = iIOMetadataNode.getElementsByTagName(string);
        if (nodeList.getLength() == 0) {
            iIOMetadataNode3 = new IIOMetadataNode(string);
            iIOMetadataNode2.appendChild(iIOMetadataNode3);
        } else {
            iIOMetadataNode3 = (IIOMetadataNode)nodeList.item(0);
        }
        return iIOMetadataNode3;
    }

    @Override
    public void setDpi(int n) {
        this.dpi = n;
    }

    @Override
    public void setCompressionRate(float f) {
        this.imageWriteParam = this.imageWriter.getDefaultWriteParam();
        if (this.imageWriteParam.canWriteCompressed()) {
            String[] stringArray = this.imageWriteParam.getCompressionTypes();
            String string = stringArray[0];
            this.imageWriteParam.setCompressionMode(2);
            this.imageWriteParam.setCompressionType(string);
            this.imageWriteParam.setCompressionQuality(f);
        }
    }

    @Override
    public void setImageWriter(ImageWriter imageWriter) {
        this.imageWriter = imageWriter;
    }
}

