/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.data.export.internal;

import com.agfa.pacs.data.export.internal.AbstractSynchronizedDataSink;
import com.agfa.pacs.logging.ALogger;
import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class ZipDataSink
extends AbstractSynchronizedDataSink {
    private static final ALogger log = ALogger.getLogger(ZipDataSink.class);
    private ZipOutputStream zipOutputStream;

    public ZipDataSink(ZipOutputStream zipOutputStream) {
        this.zipOutputStream = zipOutputStream;
    }

    @Override
    public OutputStream getOutputStream(String string, String[] stringArray) {
        this.lock();
        try {
            String string2 = this.concat(stringArray, "/");
            ZipEntry zipEntry = new ZipEntry(string2);
            this.zipOutputStream.putNextEntry(zipEntry);
            return this.zipOutputStream;
        }
        catch (IOException iOException) {
            log.error("IO Exception", (Throwable)iOException);
            return null;
        }
    }

    @Override
    public void closeOutputStream(String string) {
        this.unlock();
    }

    private String concat(String[] stringArray, String string) {
        StringBuffer stringBuffer = new StringBuffer(stringArray[0]);
        int n = 1;
        while (n < stringArray.length) {
            stringBuffer.append(String.valueOf(string) + stringArray[n]);
            ++n;
        }
        return stringBuffer.toString();
    }
}

