/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.data.export.internal;

import com.agfa.pacs.data.export.IFileIDsSource;
import com.agfa.pacs.data.export.internal.IDSource;
import com.agfa.pacs.data.export.internal.ImpaxEEProfile;
import com.agfa.pacs.data.shared.IDataSource;
import com.agfa.pacs.data.shared.dicom.Level;
import com.agfa.pacs.data.shared.lw.IDataInfo;
import com.agfa.pacs.data.shared.lw.IObjectInfo;
import com.agfa.pacs.data.shared.util.PatientKeyUtils;
import com.agfa.pacs.tools.CompareUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.channels.FileChannel;
import java.util.HashMap;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.data.VR;
import org.dcm4che3.media.DicomDirWriter;
import org.dcm4che3.util.UIDUtils;

public class DicomDirCreator
implements IDataSource,
IFileIDsSource {
    private static final ImpaxEEProfile appProfile = new ImpaxEEProfile();
    private String fileSetID;
    private File dirFile;
    private DicomDirWriter dicomDirWriter;
    private boolean flatStructure;
    private HashMap<ObjectKey, String> fileIDs = new HashMap();

    public DicomDirCreator(String string, boolean bl) throws IOException {
        this.fileSetID = string;
        this.dirFile = File.createTempFile("listtext", "dicomdir");
        this.dirFile.deleteOnExit();
        this.flatStructure = bl;
        this.init();
    }

    public DicomDirCreator(String string, File file) throws IOException {
        this.fileSetID = string;
        this.dirFile = file;
        this.flatStructure = false;
        this.init();
    }

    public String getFileSetID() {
        return this.fileSetID;
    }

    private void init() throws IOException {
        DicomDirWriter.createEmptyDirectory((File)this.dirFile, (String)UIDUtils.createUID(), (String)this.fileSetID, null, null);
        this.dicomDirWriter = DicomDirWriter.open((File)this.dirFile);
    }

    public synchronized String[] addToDicomDir(IObjectInfo iObjectInfo, Attributes attributes) throws IOException {
        return this.addToDicomDir(iObjectInfo, attributes, null);
    }

    public synchronized String[] addToDicomDir(IObjectInfo iObjectInfo, Attributes attributes, Attributes attributes2) throws IOException {
        if (!attributes.contains(131074)) {
            attributes.setString(131074, VR.UI, attributes.getString(524310));
        }
        if (!attributes.contains(131075)) {
            attributes.setString(131075, VR.UI, attributes.getString(524312));
        }
        String[] stringArray = iObjectInfo == null ? this.getFileIDs(attributes, 0) : this.getFileIDs(iObjectInfo, 0);
        Attributes attributes3 = appProfile.makePatientDirectoryRecord(attributes);
        Attributes attributes4 = appProfile.makeStudyDirectoryRecord(attributes);
        Attributes attributes5 = appProfile.makeSeriesDirectoryRecord(attributes);
        Attributes attributes6 = appProfile.makeInstanceDirectoryRecord(attributes, stringArray);
        if (attributes2 != null) {
            attributes6.newSequence(0x880200, 1).add(attributes2);
        }
        attributes3 = this.dicomDirWriter.findOrAddPatientRecord(attributes3);
        attributes4 = this.dicomDirWriter.findOrAddStudyRecord(attributes3, attributes4);
        attributes5 = this.dicomDirWriter.findOrAddSeriesRecord(attributes4, attributes5);
        this.dicomDirWriter.addLowerDirectoryRecord(attributes5, attributes6);
        return stringArray;
    }

    public synchronized void commitDicomDir() throws IOException {
        this.dicomDirWriter.commit();
    }

    public synchronized void rollbackDicomDir() throws IOException {
        this.dicomDirWriter.rollback();
    }

    public synchronized void finishDicomDir() throws IOException {
        this.dicomDirWriter.close();
    }

    private String getFileID(IDataInfo iDataInfo) {
        return this.getFileID(iDataInfo.getHierarchyLevel(), iDataInfo.getKey());
    }

    private String getFileID(Level level, String string) {
        ObjectKey objectKey = new ObjectKey(level, string);
        if (!this.fileIDs.containsKey(objectKey)) {
            this.fileIDs.put(objectKey, IDSource.createFileID());
        }
        return this.fileIDs.get(objectKey);
    }

    @Override
    public synchronized String[] getFileIDs(IObjectInfo iObjectInfo, int n) {
        if (this.flatStructure) {
            String[] stringArray = new String[]{this.getFileID((IDataInfo)iObjectInfo)};
            return stringArray;
        }
        String[] stringArray = new String[]{this.getFileID(iObjectInfo.getTreeParent().getTreeParent().getTreeParent()), this.getFileID(iObjectInfo.getTreeParent().getTreeParent()), this.getFileID(iObjectInfo.getTreeParent()), this.getFileID((IDataInfo)iObjectInfo)};
        return stringArray;
    }

    @Override
    public synchronized String[] getFileIDs(Attributes attributes, int n) {
        if (this.flatStructure) {
            String[] stringArray = new String[]{this.getFileID(Level.Object, attributes.getString(524312))};
            return stringArray;
        }
        String[] stringArray = new String[]{this.getFileID(Level.Patient, PatientKeyUtils.generatePatientKey((Attributes)attributes)), this.getFileID(Level.Study, attributes.getString(0x20000D)), this.getFileID(Level.Series, attributes.getString(0x20000E)), this.getFileID(Level.Object, attributes.getString(524312))};
        return stringArray;
    }

    public long getSize() throws IOException {
        return this.dirFile.length();
    }

    public InputStream getAsInputStream() throws IOException {
        return new FileInputStream(this.dirFile);
    }

    public void writeToOutputStream(OutputStream outputStream) throws IOException {
        block7: {
            try (FileInputStream fileInputStream = null;){
                int n;
                fileInputStream = new FileInputStream(this.dirFile);
                if (outputStream instanceof FileOutputStream) {
                    FileOutputStream fileOutputStream = (FileOutputStream)outputStream;
                    FileChannel fileChannel = fileInputStream.getChannel();
                    fileChannel.transferTo(0L, fileChannel.size(), fileOutputStream.getChannel());
                    break block7;
                }
                int n2 = 65536;
                byte[] byArray = new byte[n2];
                while ((n = fileInputStream.read(byArray, 0, n2)) >= 0) {
                    outputStream.write(byArray, 0, n);
                }
            }
        }
    }

    private static class ObjectKey {
        private final Level level;
        private final String key;

        public ObjectKey(Level level, String string) {
            this.level = level;
            this.key = string;
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (!(object instanceof ObjectKey)) {
                return false;
            }
            ObjectKey objectKey = (ObjectKey)object;
            return CompareUtils.equals((Object)this.level, (Object)objectKey.level) && CompareUtils.equals((Object)this.key, (Object)objectKey.key);
        }

        public int hashCode() {
            int n = 17;
            n = 37 * n + CompareUtils.hashCode((Object)this.level);
            n = 37 * n + CompareUtils.hashCode((Object)this.key);
            return n;
        }
    }
}

