/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.data.export.blackening;

import com.agfa.pacs.cache.ByteArrayContainer;
import com.agfa.pacs.cache.DataCacheProviderFactory;
import com.agfa.pacs.data.export.ImageObject;
import com.agfa.pacs.data.export.blackening.BlackeningBox;
import com.agfa.pacs.data.export.blackening.BlackeningInfo;
import com.agfa.pacs.data.shared.export.IProcessingElement;
import com.agfa.pacs.data.shared.export.ProcessingProperty;
import com.agfa.pacs.data.shared.pixel.IPixelDataFrame;
import com.agfa.pacs.data.shared.pixel.IPixelDataFrameProvider;
import com.agfa.pacs.data.shared.pixel.IPixelDataInfo;
import com.agfa.pacs.data.shared.pixel.PhotometricInterpretation;
import com.agfa.pacs.data.shared.pixel.PixelDataFramePixelDataInfo;
import com.agfa.pacs.data.shared.pixel.PixelDataFrameUtilities;
import com.agfa.pacs.logging.ALogger;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.data.VR;

public class Blackening
implements IProcessingElement {
    private static final ALogger log = ALogger.getLogger(Blackening.class);
    private static final String TARGET_TS = "1.2.840.10008.1.2";
    public static final String ID = "Blackening";
    public static final String BLACKENING_COLOR = "blackeningColor";
    private static final Set<String> presentationStateSOPClasses = new HashSet<String>(Arrays.asList("1.2.840.10008.5.1.4.1.1.11.1", "1.2.840.10008.5.1.4.1.1.11.2", "1.2.840.10008.5.1.4.1.1.11.3", "1.2.840.10008.5.1.4.1.1.11.4", "1.2.840.10008.5.1.4.1.1.11.5"));
    private static final byte[] maskStart;
    private static final short[] maskEnd;
    private int blackeningColor = 0;
    private BlackeningInfo blackeningInfo;

    static {
        byte[] byArray = new byte[8];
        byArray[1] = 1;
        byArray[2] = 3;
        byArray[3] = 7;
        byArray[4] = 15;
        byArray[5] = 31;
        byArray[6] = 63;
        byArray[7] = 127;
        maskStart = byArray;
        maskEnd = new short[]{255, 254, 252, 248, 240, 224, 192, 128};
    }

    public void cleanUp() {
        this.blackeningInfo = null;
    }

    public void finishProcessing() {
    }

    public String getErrorMessage() {
        return null;
    }

    public void prepareProcessing(Properties properties, List<? extends Object> list) {
        if (properties.containsKey("blackeningInfo")) {
            this.blackeningInfo = (BlackeningInfo)properties.get("blackeningInfo");
        }
        if (properties.containsKey(BLACKENING_COLOR)) {
            this.blackeningColor = (Integer)properties.get(BLACKENING_COLOR);
        }
    }

    public Object process(Object object) {
        ImageObject imageObject;
        ImageObject imageObject2 = (ImageObject)object;
        if (this.blackeningInfo == null || !this.blackeningInfo.containsBlackening()) {
            return object;
        }
        if (imageObject2.getFrameCount() == 0) {
            if (this.blackeningInfo.containsBlackening() && presentationStateSOPClasses.contains(imageObject2.getDataset().getString(524310))) {
                imageObject2.setDataset(imageObject2.getDataset());
                this.clearAllOverlayData(imageObject2.getDataset());
            }
            return imageObject2;
        }
        if (imageObject2.getFrameCount() == 1) {
            List<BlackeningBox> list = this.blackeningInfo.getBlackening(imageObject2.getObjectInfo(), 0);
            if (list.size() > 0) {
                imageObject = new ImageObject();
                this.blackenFrame(imageObject2, imageObject, list, 0);
            } else {
                imageObject = imageObject2;
            }
        } else {
            imageObject = new ImageObject();
            int n = 0;
            while (n < imageObject2.getFrameCount()) {
                List<BlackeningBox> list = this.blackeningInfo.getBlackening(imageObject2.getObjectInfo(), n);
                this.blackenFrame(imageObject2, imageObject, list, n);
                ++n;
            }
        }
        return imageObject;
    }

    private void clearAllOverlayData(Attributes attributes) {
        int n = 0;
        while (n < 16) {
            int n2 = n * 2 << 16;
            if (attributes.contains(n2 + 0x60003000)) {
                byte[] byArray = null;
                try {
                    byArray = attributes.getBytes(n2 + 0x60003000);
                }
                catch (IOException iOException) {
                    log.error("Failed to read overlay data from dicom object", (Throwable)iOException);
                }
                if (byArray != null) {
                    int n3 = 0;
                    while (n3 < byArray.length) {
                        byArray[n3] = 0;
                        ++n3;
                    }
                }
            }
            ++n;
        }
    }

    private void blackenFrame(ImageObject imageObject, ImageObject imageObject2, List<BlackeningBox> list, int n) {
        int n2;
        int n3;
        int n4;
        int n5;
        Object object;
        if (n == 0) {
            imageObject2.setDataset(imageObject.getDataset());
        }
        Attributes attributes = imageObject2.getDataset();
        if (list.size() != 0) {
            int n6 = 0;
            while (n6 < 16) {
                int n7 = n6 * 2 << 16;
                if (attributes.contains(n7 + 0x60003000)) {
                    object = null;
                    try {
                        object = attributes.getBytes(n7 + 0x60003000);
                    }
                    catch (IOException iOException) {
                        log.error("Failed to read overlay data from dicom object", (Throwable)iOException);
                    }
                    if (object != null) {
                        int n8 = attributes.getInt(n7 + 1610612757, 1);
                        int n9 = attributes.getInt(n7 + 1610612817, 1);
                        n5 = n - n9 + 1;
                        if (n5 >= 0 && n5 < n8) {
                            int n10 = attributes.getInt(n7 + 0x60000011, 0);
                            int n11 = attributes.getInt(n7 + 0x60000010, 0);
                            n4 = n5 * (n10 * n11 + (8 - n10 * n11 % 8));
                            int[] nArray = attributes.getInts(n7 + 0x60000050);
                            for (BlackeningBox blackeningBox : list) {
                                n3 = Math.max((int)blackeningBox.getP1()[0] - (nArray[1] - 1), 0);
                                n2 = Math.max((int)blackeningBox.getP1()[1] - (nArray[0] - 1), 0);
                                int n12 = Math.min((int)blackeningBox.getP2()[0] - (nArray[1] - 1), n10 - 1);
                                int n13 = Math.min((int)blackeningBox.getP2()[1] - (nArray[0] - 1), n11 - 1);
                                if (n3 >= n12 || n2 >= n13) continue;
                                int n14 = n12 - n3 + 1;
                                int n15 = n2;
                                while (n15 <= n13) {
                                    this.clearBits((byte[])object, n4 + n15 * n10 + n3, n14);
                                    ++n15;
                                }
                            }
                        }
                    }
                }
                ++n6;
            }
        }
        IPixelDataInfo iPixelDataInfo = imageObject.getFrame(n);
        String string = attributes.getString(524312);
        object = PixelDataFrameUtilities.createPixelDataFrame((IPixelDataFrameProvider)PixelDataFrameUtilities.DefaultPixelDataFrameProvider, (IPixelDataInfo)iPixelDataInfo, (String)string);
        Object object2 = object.getOriginalData();
        Object object3 = Blackening.copyData(object2, object);
        for (BlackeningBox blackeningBox : list) {
            int n16;
            int n17;
            n4 = (int)blackeningBox.getP1()[0];
            if (n4 >= object.getWidth() || (n17 = (int)blackeningBox.getP1()[1]) >= object.getHeight()) continue;
            int n18 = (int)blackeningBox.getP2()[0];
            if (n18 >= object.getWidth()) {
                n18 = object.getWidth() - 1;
            }
            if ((n16 = (int)blackeningBox.getP2()[1]) >= object.getHeight()) {
                n16 = object.getHeight() - 1;
            }
            n3 = n18 - n4 + 1;
            n2 = n17;
            while (n2 <= n16) {
                n5 = n2 * object.getWidth() + (int)blackeningBox.getP1()[0];
                this.clearPart(object3, n5, n3, object.getPixelDataClass());
                ++n2;
            }
        }
        if (n == 0) {
            attributes.setString(131088, VR.UI, TARGET_TS);
            attributes.setInt(2621446, VR.US, new int[]{0});
            PhotometricInterpretation photometricInterpretation = PhotometricInterpretation.get((String)attributes.getString(2621444));
            if (photometricInterpretation == PhotometricInterpretation.YBRFull || photometricInterpretation == PhotometricInterpretation.YBRFull422 || photometricInterpretation == PhotometricInterpretation.YBRIrreversibleColorTransforamtion || photometricInterpretation == PhotometricInterpretation.YBRPartial420 || photometricInterpretation == PhotometricInterpretation.YBRPartial422 || photometricInterpretation == PhotometricInterpretation.YBRReversibleColorTransforamtion) {
                attributes.setString(2621444, VR.CS, PhotometricInterpretation.RGBColor.dicom());
            }
        }
        IPixelDataFrame iPixelDataFrame = PixelDataFrameUtilities.createPixelDataFrame((Attributes)attributes, (Object)object3);
        PixelDataFramePixelDataInfo pixelDataFramePixelDataInfo = new PixelDataFramePixelDataInfo(iPixelDataFrame, attributes);
        imageObject2.setFrame((IPixelDataInfo)pixelDataFramePixelDataInfo, n);
    }

    private void clearBits(byte[] byArray, int n, int n2) {
        int n3 = n / 8;
        int n4 = (n + n2) / 8;
        if (n3 == n4) {
            int n5 = n3;
            byArray[n5] = (byte)(byArray[n5] & (maskStart[n % 8] | maskEnd[(n + n2) % 8]));
        } else {
            int n6 = n3;
            byArray[n6] = (byte)(byArray[n6] & maskStart[n % 8]);
            Arrays.fill(byArray, n3 + 1, n4, (byte)0);
            if (n4 < byArray.length) {
                int n7 = n4;
                byArray[n7] = (byte)(byArray[n7] & maskEnd[(n + n2) % 8]);
            }
        }
    }

    private static Object copyData(Object object, IPixelDataFrame<?> iPixelDataFrame) {
        Class clazz = iPixelDataFrame.getPixelDataClass();
        int n = iPixelDataFrame.getNumPixels();
        if (byte[].class == clazz) {
            byte[] byArray = DataCacheProviderFactory.getCache().allocBytes((long)n);
            System.arraycopy(object, 0, byArray, 0, n);
            return byArray;
        }
        if (short[].class == clazz) {
            short[] sArray = DataCacheProviderFactory.getCache().allocShorts((long)n);
            System.arraycopy(object, 0, sArray, 0, n);
            return sArray;
        }
        if (int[].class == clazz) {
            int[] nArray = DataCacheProviderFactory.getCache().allocInts((long)n);
            System.arraycopy(object, 0, nArray, 0, n);
            return nArray;
        }
        if (ByteArrayContainer.class == clazz) {
            byte[] byArray = DataCacheProviderFactory.getCache().allocBytes((long)n);
            System.arraycopy(object, 0, byArray, 0, n);
            return new ByteArrayContainer(byArray, 0, n);
        }
        throw new IllegalArgumentException("Unknown type for pixel data: " + clazz);
    }

    private void clearPart(Object object, int n, int n2, Class<?> clazz) {
        if (clazz == byte[].class) {
            Arrays.fill((byte[])object, n, n + n2, (byte)this.blackeningColor);
        } else if (clazz == short[].class) {
            Arrays.fill((short[])object, n, n + n2, (short)this.blackeningColor);
        } else if (clazz == int[].class) {
            Arrays.fill((int[])object, n, n + n2, this.blackeningColor);
        } else if (clazz == ByteArrayContainer.class) {
            Arrays.fill(((ByteArrayContainer)object).getData(), n, n + n2, (byte)this.blackeningColor);
        } else {
            throw new IllegalArgumentException("Unknown type for pixel data: " + clazz);
        }
    }

    public ProcessingProperty[] queryProperties() {
        return null;
    }

    public boolean supportsConcurrentProcessing() {
        return true;
    }
}

