/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.data.export;

import com.agfa.pacs.base.util.DateTimeUtils;
import com.agfa.pacs.base.util.PersonNameUtilities;
import com.agfa.pacs.data.export.ImageObject;
import com.agfa.pacs.data.export.Messages;
import com.agfa.pacs.data.shared.lw.IObjectInfo;
import java.text.MessageFormat;
import java.util.Date;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.data.PersonName;

public class ProcessingExceptionMessageFactory {
    private ProcessingExceptionMessageFactory() {
    }

    static String getProcessingExceptionMessage(String string, ImageObject imageObject) {
        IObjectInfo iObjectInfo = imageObject.getObjectInfo();
        if (iObjectInfo == null) {
            return ProcessingExceptionMessageFactory.getProcessingExceptionMessage(string, imageObject.getDataset(), null);
        }
        return ProcessingExceptionMessageFactory.getProcessingExceptionMessage(string, iObjectInfo);
    }

    static String getProcessingExceptionMessage(String string, IObjectInfo iObjectInfo) {
        return ProcessingExceptionMessageFactory.getProcessingExceptionMessage(string, iObjectInfo.getDicomObjectMerged(), iObjectInfo.getInstanceInfo() == null ? null : iObjectInfo.getInstanceInfo().getURIString());
    }

    static String getProcessingExceptionMessage(String string, Attributes attributes, String string2) {
        String string3 = attributes == null ? Messages.getString("ProcessingExceptionMessageFactory.UnknownPatient") : ProcessingExceptionMessageFactory.getPatientStudyDescription(attributes);
        if (string2 == null) {
            return MessageFormat.format(Messages.getString(String.valueOf(string) + ".UnknownFile"), string3);
        }
        return MessageFormat.format(Messages.getString(String.valueOf(string) + ".SpecificFile"), string3, string2);
    }

    private static String getPatientStudyDescription(Attributes attributes) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(PersonNameUtilities.personNameToHR((PersonName)new PersonName(attributes.getString(0x100010), true)));
        String string = attributes.getString(528432);
        Date date = attributes.getDate(524320);
        if (string != null || date != null) {
            String string2 = string == null ? MessageFormat.format(Messages.getString("ProcessingExceptionMessageFactory.StudyWithDate"), DateTimeUtils.date2String((Date)date)) : (date == null ? MessageFormat.format(Messages.getString("ProcessingExceptionMessageFactory.StudyWithName"), string) : MessageFormat.format(Messages.getString("ProcessingExceptionMessageFactory.StudyWithNameAndDate"), string, DateTimeUtils.date2String((Date)date)));
            stringBuilder.append(" (");
            stringBuilder.append(string2);
            stringBuilder.append(')');
        }
        return stringBuilder.toString();
    }
}

