/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.data.export;

import com.agfa.pacs.data.export.ImageObject;
import com.agfa.pacs.data.shared.data.IDicomDataListener;
import com.agfa.pacs.data.shared.pixel.IPixelDataInfo;
import com.agfa.pacs.logging.ALogger;
import org.dcm4che3.data.Attributes;

public class ImageObjectDicomDataListener
implements IDicomDataListener {
    private static final ALogger log = ALogger.getLogger(ImageObjectDicomDataListener.class);
    private final ImageObject imageObject;

    public ImageObjectDicomDataListener(ImageObject imageObject) {
        this.imageObject = imageObject;
    }

    public void dicomDataAvailable(String string, Attributes attributes, boolean bl) {
        if (!bl) {
            this.imageObject.setDatasetAndFinish(attributes);
        } else {
            this.imageObject.setDataset(attributes);
        }
    }

    public void dicomDataError(String string, String string2, Throwable throwable) {
        log.error("dicomDataError: " + string2, throwable);
        this.imageObject.failed();
    }

    public void dicomDataFinished(String string, IDicomDataListener.Status status, Attributes attributes) {
        if (attributes != null) {
            this.imageObject.setPostPixelDataset(attributes);
        }
        this.imageObject.finished();
    }

    public void pixelDataAvailable(String string, IPixelDataInfo iPixelDataInfo, int n) {
        this.imageObject.setFrame(iPixelDataInfo, n);
    }
}

