/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.data.export;

import com.agfa.pacs.data.shared.dicom.UIDType;
import com.agfa.pacs.data.shared.dicom.UIDUtilities;
import com.agfa.pacs.data.shared.lw.IObjectInfo;
import com.agfa.pacs.data.shared.pixel.IPixelDataInfo;
import com.agfa.pacs.data.shared.util.OverlayUtils;
import org.dcm4che3.data.Attributes;

public class ImageObject {
    private Attributes dataset;
    private IObjectInfo objectInfo;
    private Attributes postPixelDataset;
    private IPixelDataInfo[] frames;
    private boolean finishReceived = false;
    private boolean finished = false;
    private boolean failed = false;

    public IPixelDataInfo getFrame(int n) {
        return this.frames[n];
    }

    public int getFrameCount() {
        return this.frames.length;
    }

    public Attributes getPostPixelDataset() {
        return this.postPixelDataset;
    }

    public void setPostPixelDataset(Attributes attributes) {
        this.postPixelDataset = attributes;
    }

    public Attributes getDataset() {
        return this.dataset;
    }

    public void setNumberOfFrames(int n) {
        this.frames = new IPixelDataInfo[n];
    }

    public IObjectInfo getObjectInfo() {
        return this.objectInfo;
    }

    public void setDatasetAndFinish(Attributes attributes) {
        this.setDataset(attributes);
        if (this.frames == null) {
            this.frames = new IPixelDataInfo[0];
        }
        if (this.finishReceived && !this.finished) {
            this.finished();
        }
    }

    public void setDataset(Attributes attributes) {
        Attributes attributes2 = new Attributes(attributes);
        OverlayUtils.addCachedOverlayData((Attributes)attributes2);
        this.dataset = attributes2;
    }

    public void setObjectInfo(IObjectInfo iObjectInfo) {
        this.objectInfo = iObjectInfo;
    }

    public void setFrame(IPixelDataInfo iPixelDataInfo, int n) {
        if (this.frames == null) {
            String string = iPixelDataInfo.getTransferSyntaxUID();
            boolean bl = UIDUtilities.isTransferSyntaxType((String)string, (UIDType)UIDType.Video);
            if (this.dataset == null) {
                throw new IllegalArgumentException("Set Frame received before dicomDataAvailable");
            }
            if (this.dataset.containsValue(0x280008) && !bl) {
                int n2 = this.dataset.getInt(0x280008, 0);
                this.frames = new IPixelDataInfo[n2];
            } else {
                this.frames = new IPixelDataInfo[1];
            }
        }
        this.frames[n] = iPixelDataInfo;
        if (this.finishReceived && !this.finished) {
            this.finished();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finished() {
        ImageObject imageObject;
        this.finishReceived = true;
        if (this.dataset == null) {
            return;
        }
        IPixelDataInfo[] iPixelDataInfoArray = this.frames;
        int n = this.frames.length;
        int n2 = 0;
        while (n2 < n) {
            imageObject = iPixelDataInfoArray[n2];
            if (imageObject == null) {
                return;
            }
            ++n2;
        }
        imageObject = this;
        synchronized (imageObject) {
            this.notifyAll();
            this.finished = true;
        }
    }

    boolean isFinished() {
        return this.finished;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void failed() {
        ImageObject imageObject = this;
        synchronized (imageObject) {
            this.notifyAll();
            this.failed = true;
        }
    }

    boolean isFailed() {
        return this.failed;
    }
}

