/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.data.export;

import com.agfa.pacs.base.util.AgeUtil;
import com.agfa.pacs.data.export.ImageObject;
import com.agfa.pacs.data.shared.export.IProcessingElement;
import com.agfa.pacs.data.shared.export.ProcessingProperty;
import com.agfa.pacs.data.shared.lw.DataInfoUtilities;
import com.agfa.pacs.logging.ALogger;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ThreadLocalRandom;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.data.ElementDictionary;
import org.dcm4che3.data.Sequence;
import org.dcm4che3.data.VR;
import org.dcm4che3.util.UIDUtils;

public class Anonymize
implements IProcessingElement {
    private static final ALogger LOG = ALogger.getLogger(Anonymize.class);
    public static final String REPLACEMENT = "REPLACEMENT";
    public static final String CONDITIONAL_REPLACEMENT = "CONDITIONAL_REPLACEMENT";
    public static final String RETAIN_SEX = "RETAIN_SEX";
    public static final String RETAIN_AGE = "RETAIN_AGE";
    public static final String RETAIN_DESCRIPTIONS = "RETAIN_DESCRIPTIONS";
    public static final String RETAIN_ALL_DATA = "RETAIN_ALL_DATA";
    public static final String RETAIN_DIMENSIONS = "RETAIN_DIMENSIONS";
    public static final String RECODE_UIDS = "RECODE_UIDS";
    public static final String EXCLUDE_OWN_SC = "EXCLUDE_OWN_SC";
    private Map<String, PersonDeidentifier> map = new HashMap<String, PersonDeidentifier>();
    private Map<String, String> centralUIDMap = new ConcurrentHashMap<String, String>();
    private Attributes replacement = null;
    private Attributes conditionalReplacement = null;
    private boolean retainPatientAge;
    private boolean retainPatientNumbers;
    private boolean retainPatientSex;
    private boolean retainDescription;
    private boolean retainAllPatientData;
    private boolean recodeUIDs;
    private int patientCount = 0;
    private static final int[] REPLACE_STUDY_TAGS = new int[]{0x200010};
    private static final int[] CLEAR_TAGS = new int[]{524368, 0x100020, 0x100021, 0x100030, 1048626};
    private static final int[] REMOVE_TAGS = new int[]{524416, 524417, 524432, 524434, 524436, 528400, 528432, 528446, 528448, 528456, 528464, 528480, 528496, 528512, 532753, 0x100010, 0x101005, 0x101060, 0x101040, 805962116, 1057108, 3671040, 0x100040, 0x101000, 0x101002, 0x101001, 0x101010, 0x101020, 0x101030, 0x101090, 1057120, 1057152, 1057200, 0x104000, 0x181000, 0x101040, 1057108, 67110241, 3293184, 0x380300, 3280946, 3280947, 0x401001, 4194933};
    private static final int[] REPLACE_UID_TAGS = new int[]{524312, 0x20000E, 0x20000D, 0x200052, 528725, 805699620, 805699778, 0x200200, 524308, 267314, 524567, 528743, 536592, 561443, 1576962};
    private static int[] ADDITIONAL_REMOVE_TAGS = null;
    private final char[] randomChars = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'Q', 'X', 'Y', 'Z'};
    private final Map<Integer, ACTION> allTags = new HashMap<Integer, ACTION>();

    public static int[] getRemoveTags() {
        return REMOVE_TAGS;
    }

    public static void setAdditionalTagsToBeRemoved(int[] nArray) {
        ADDITIONAL_REMOVE_TAGS = Arrays.copyOf(nArray, nArray.length);
    }

    public static int[] getClearTags() {
        return CLEAR_TAGS;
    }

    public void setRetainPatientAge(boolean bl) {
        this.retainPatientAge = bl;
    }

    public void setRetainPatientNumbers(boolean bl) {
        this.retainPatientNumbers = bl;
    }

    public void setRetainAllPatientData(boolean bl) {
        this.retainAllPatientData = bl;
    }

    public void fillUIDMap(Map<String, String> map) {
        for (PersonDeidentifier personDeidentifier : this.map.values()) {
            personDeidentifier.fillUIDMap(map);
        }
        this.centralUIDMap.putAll(map);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deidentify(Attributes attributes) {
        if (attributes == null) {
            return;
        }
        String string = DataInfoUtilities.compilePatientKey((Attributes)attributes);
        PersonDeidentifier personDeidentifier = null;
        personDeidentifier = this.map.get(string);
        if (personDeidentifier != null) {
            personDeidentifier.deidentify(attributes, true);
            return;
        }
        Map<String, PersonDeidentifier> map = this.map;
        synchronized (map) {
            personDeidentifier = this.map.get(string);
            if (personDeidentifier != null) {
                personDeidentifier.deidentify(attributes, true);
                return;
            }
            personDeidentifier = new PersonDeidentifier(this.replacement == null ? null : new Attributes(this.replacement), attributes);
            personDeidentifier.fillUIDMap(this.centralUIDMap);
            this.map.put(string, personDeidentifier);
        }
        personDeidentifier.deidentify(attributes, true);
    }

    public Attributes getDeidentifiedAttributes(Attributes attributes) {
        this.deidentify(attributes);
        return attributes;
    }

    public void finishProcessing() {
    }

    public void conditionalCopyTo(Attributes attributes) {
        if (this.conditionalReplacement != null) {
            attributes.addSelected(this.conditionalReplacement, attributes);
        }
    }

    public void cleanUp() {
        this.replacement = null;
        this.map = null;
        this.centralUIDMap = null;
    }

    public String getErrorMessage() {
        return null;
    }

    public static boolean isAnonymizing(Properties properties) {
        return properties.containsKey(CONDITIONAL_REPLACEMENT) || properties.containsKey(REPLACEMENT) || properties.containsKey(RECODE_UIDS);
    }

    public void prepareProcessing(Properties properties, List<? extends Object> list) {
        if (properties.containsKey(REPLACEMENT)) {
            this.replacement = (Attributes)properties.get(REPLACEMENT);
        }
        if (properties.containsKey(RETAIN_SEX)) {
            this.retainPatientSex = (Boolean)properties.get(RETAIN_SEX);
        }
        if (properties.containsKey(RETAIN_AGE)) {
            this.retainPatientAge = (Boolean)properties.get(RETAIN_AGE);
        }
        if (properties.containsKey(RETAIN_DESCRIPTIONS)) {
            this.retainDescription = (Boolean)properties.get(RETAIN_DESCRIPTIONS);
        }
        if (properties.containsKey(RETAIN_DIMENSIONS)) {
            this.retainPatientNumbers = (Boolean)properties.get(RETAIN_DIMENSIONS);
        }
        if (properties.containsKey(RETAIN_ALL_DATA)) {
            this.retainAllPatientData = (Boolean)properties.get(RETAIN_ALL_DATA);
        }
        if (properties.containsKey(CONDITIONAL_REPLACEMENT)) {
            this.conditionalReplacement = (Attributes)properties.get(CONDITIONAL_REPLACEMENT);
        }
        if (properties.containsKey(RECODE_UIDS)) {
            this.recodeUIDs = (Boolean)properties.get(RECODE_UIDS);
        }
        if (!this.retainAllPatientData) {
            this.recodeUIDs = true;
        }
        if (properties.containsKey(EXCLUDE_OWN_SC) && !((Boolean)properties.get(EXCLUDE_OWN_SC)).booleanValue()) {
            properties.put("SECONDARY_CAPTURE_INCLUDED_IN_ANONYMIZED_EXPORT", Boolean.TRUE);
        }
        if (this.retainAllPatientData && this.recodeUIDs) {
            int[] nArray = REPLACE_UID_TAGS;
            int n = REPLACE_UID_TAGS.length;
            int n2 = 0;
            while (n2 < n) {
                int n3 = nArray[n2];
                this.allTags.put(n3, ACTION.UID);
                ++n2;
            }
            if (this.replacement == null) {
                this.allTags.remove(0x20000D);
            }
        } else if (!this.retainAllPatientData) {
            int n;
            int[] nArray = CLEAR_TAGS;
            int n4 = CLEAR_TAGS.length;
            int n5 = 0;
            while (n5 < n4) {
                n = nArray[n5];
                this.allTags.put(n, ACTION.Clear);
                ++n5;
            }
            nArray = REMOVE_TAGS;
            n4 = REMOVE_TAGS.length;
            n5 = 0;
            while (n5 < n4) {
                n = nArray[n5];
                this.allTags.put(n, ACTION.Remove);
                ++n5;
            }
            if (ADDITIONAL_REMOVE_TAGS != null) {
                nArray = ADDITIONAL_REMOVE_TAGS;
                n4 = ADDITIONAL_REMOVE_TAGS.length;
                n5 = 0;
                while (n5 < n4) {
                    n = nArray[n5];
                    this.allTags.put(n, ACTION.Remove);
                    ++n5;
                }
            }
            nArray = REPLACE_UID_TAGS;
            n4 = REPLACE_UID_TAGS.length;
            n5 = 0;
            while (n5 < n4) {
                n = nArray[n5];
                this.allTags.put(n, ACTION.UID);
                ++n5;
            }
            if (this.retainDescription) {
                this.allTags.remove(528432);
                this.allTags.remove(528446);
            }
            if (this.retainPatientSex) {
                this.allTags.remove(0x100040);
            }
        }
    }

    public Object process(Object object) {
        if (object instanceof ImageObject) {
            if (this.replacement != null || this.conditionalReplacement != null || this.retainAllPatientData && this.recodeUIDs) {
                ImageObject imageObject = (ImageObject)object;
                this.deidentify(imageObject.getDataset());
                imageObject.setObjectInfo(null);
            }
            return object;
        }
        throw new IllegalArgumentException("Wrong type");
    }

    public ProcessingProperty[] queryProperties() {
        ProcessingProperty[] processingPropertyArray = new ProcessingProperty[]{new ProcessingProperty(REPLACEMENT, Attributes.class, null), new ProcessingProperty(RETAIN_AGE, Boolean.class, null), new ProcessingProperty(RETAIN_SEX, Boolean.class, null), new ProcessingProperty(RETAIN_DESCRIPTIONS, Boolean.class, null), new ProcessingProperty(RETAIN_ALL_DATA, Boolean.class, null), new ProcessingProperty(RETAIN_DIMENSIONS, Boolean.class, null)};
        return processingPropertyArray;
    }

    public boolean supportsConcurrentProcessing() {
        return true;
    }

    private static enum ACTION {
        Clear,
        Remove,
        UID;

    }

    private class PersonDeidentifier {
        private Attributes patientReplacement = null;
        private final Map<String, String> uidMap = new Hashtable<String, String>();
        private final Map<String, Attributes> studyReplacements = new Hashtable<String, Attributes>();

        public PersonDeidentifier(Attributes attributes, Attributes attributes2) {
            this.patientReplacement = attributes;
            this.setPatientID();
        }

        private void setPatientID() {
            if (Anonymize.this.retainAllPatientData && (this.patientReplacement == null || !this.patientReplacement.containsValue(0x100020))) {
                return;
            }
            String string = Anonymize.this.patientCount == 0 ? (this.patientReplacement.containsValue(0x100020) ? this.patientReplacement.getString(0x100020) : "") : (!this.patientReplacement.containsValue(0x100020) ? Integer.toString(Anonymize.this.patientCount) : String.valueOf(this.patientReplacement.getString(0x100020)) + "_" + Integer.toString(Anonymize.this.patientCount));
            this.patientReplacement.setString(0x100020, VR.LO, string);
            Anonymize anonymize = Anonymize.this;
            anonymize.patientCount = anonymize.patientCount + 1;
        }

        public void fillUIDMap(Map<String, String> map) {
            this.uidMap.putAll(map);
        }

        public void deidentify(Attributes attributes, boolean bl) {
            String string;
            Attributes attributes2 = null;
            if (bl && (attributes2 = this.studyReplacements.get(string = attributes.getString(0x20000D))) == null) {
                attributes2 = this.createStudyReplacement(attributes, string);
            }
            int[] nArray = attributes.tags();
            int n = nArray.length;
            int n2 = 0;
            while (n2 < n) {
                int n3 = nArray[n2];
                if (attributes.containsValue(n3)) {
                    Sequence sequence;
                    ACTION aCTION = (ACTION)((Object)Anonymize.this.allTags.get(n3));
                    VR vR = ElementDictionary.vrOf((int)n3, null);
                    if (aCTION != null) {
                        this.replace(attributes, n3, vR, aCTION);
                    } else if (vR == VR.SQ && (sequence = attributes.getSequence(n3)) != null && !sequence.isEmpty()) {
                        int n4 = 0;
                        while (n4 < sequence.size()) {
                            Attributes attributes3 = (Attributes)sequence.get(n4);
                            this.deidentify(attributes3, false);
                            ++n4;
                        }
                    }
                }
                ++n2;
            }
            if (bl) {
                if (this.patientReplacement != null) {
                    attributes.addAll(this.patientReplacement);
                }
                if (attributes2 != null && !attributes2.isEmpty()) {
                    attributes.addAll(attributes2);
                }
                Anonymize.this.conditionalCopyTo(attributes);
                if (Anonymize.this.retainAllPatientData) {
                    this.removeNullElements(attributes);
                }
            }
        }

        private synchronized Attributes createStudyReplacement(Attributes attributes, String string) {
            Attributes attributes2 = new Attributes();
            if (Anonymize.this.retainPatientAge) {
                if (attributes.containsValue(0x100030) && attributes.containsValue(524320)) {
                    Date date = attributes.getDate(2251937253163056L);
                    try {
                        attributes2.setString(0x101010, VR.AS, AgeUtil.getAge((Date)attributes.getDate(4503805786849330L), (Date)date));
                    }
                    catch (Exception exception) {
                        LOG.warn("Could not calculate patient age", (Throwable)exception);
                    }
                } else if (attributes.containsValue(0x101010)) {
                    attributes2.addSelected(attributes, new int[]{0x101010});
                }
            }
            if (Anonymize.this.retainPatientNumbers) {
                attributes2.addSelected(attributes, new int[]{0x101020, 0x101030});
            }
            int[] nArray = REPLACE_STUDY_TAGS;
            int n = nArray.length;
            int n2 = 0;
            while (n2 < n) {
                int n3 = nArray[n2];
                if (attributes.contains(n3)) {
                    VR vR = ElementDictionary.vrOf((int)n3, null);
                    attributes2.setString(n3, vR, this.createRandomString(attributes.getString(n3), vR));
                }
                ++n2;
            }
            this.studyReplacements.put(string, attributes2);
            return attributes2;
        }

        private void replace(Attributes attributes, int n, VR vR, ACTION aCTION) {
            if (this.patientReplacement != null && this.patientReplacement.contains(n)) {
                attributes.setString(n, vR, this.patientReplacement.getString(n));
                return;
            }
            if (aCTION == ACTION.Remove) {
                attributes.remove(n);
                return;
            }
            if (aCTION == ACTION.Clear) {
                attributes.setNull(n, vR);
                return;
            }
            if (aCTION == ACTION.UID) {
                String string = attributes.getString(n);
                if (this.uidMap.containsKey(string)) {
                    attributes.setString(n, vR, this.uidMap.get(string));
                } else {
                    String string2 = this.generateUID();
                    attributes.setString(n, vR, string2);
                    this.uidMap.put(string, string2);
                }
            }
        }

        private String generateUID() {
            return UIDUtils.createUID();
        }

        private void removeNullElements(Attributes attributes) {
            if (this.patientReplacement != null) {
                int[] nArray = this.patientReplacement.tags();
                int n = nArray.length;
                int n2 = 0;
                while (n2 < n) {
                    int n3 = nArray[n2];
                    if (!this.patientReplacement.containsValue(n3)) {
                        attributes.remove(n3);
                    }
                    ++n2;
                }
            }
        }

        private String createRandomString(String string, VR vR) {
            if (string == null) {
                string = "";
            }
            StringBuilder stringBuilder = new StringBuilder();
            ThreadLocalRandom threadLocalRandom = ThreadLocalRandom.current();
            if (vR.code() == VR.PN.code()) {
                int n = 0;
                while (n < string.length()) {
                    stringBuilder.append(string.charAt(n) == '^' || string.charAt(n) == '=' ? string.charAt(n) : Anonymize.this.randomChars[((Random)threadLocalRandom).nextInt(26)]);
                    ++n;
                }
            } else if (vR.isIntType()) {
                stringBuilder.append(((Random)threadLocalRandom).nextInt(9) + 1);
                int n = 1;
                while (n < string.length()) {
                    stringBuilder.append(((Random)threadLocalRandom).nextInt(10));
                    ++n;
                }
            } else {
                int n = 0;
                while (n < string.length()) {
                    stringBuilder.append(Anonymize.this.randomChars[((Random)threadLocalRandom).nextInt(26)]);
                    ++n;
                }
            }
            return stringBuilder.toString();
        }
    }
}

