/*
 * Decompiled with CFR 0.152.
 */
package at.bestsolution.efxclipse.runtime.osgi.patch;

import at.bestsolution.efxclipse.runtime.osgi.patch.PFAdaptorHook;
import at.bestsolution.efxclipse.runtime.osgi.patch.PFConfigurator;
import at.bestsolution.efxclipse.runtime.osgi.patch.PFStorageHook;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import org.eclipse.osgi.baseadaptor.BaseData;
import org.eclipse.osgi.baseadaptor.bundlefile.BundleEntry;
import org.eclipse.osgi.baseadaptor.bundlefile.BundleFile;
import org.eclipse.osgi.framework.internal.core.AbstractBundle;
import org.eclipse.osgi.internal.baseadaptor.DevClassPathHelper;
import org.osgi.framework.Bundle;
import org.osgi.service.packageadmin.PackageAdmin;

public class PFBundleFile
extends BundleFile {
    private final BundleFile wrapped;
    private final BaseData patchedData;
    private final PFAdaptorHook pfAdaptorHook;
    private boolean processed = false;
    private BundleFile[] patches;

    public PFBundleFile(BundleFile bundleFile, BaseData baseData, PFAdaptorHook pFAdaptorHook) {
        super(bundleFile.getBaseFile());
        this.wrapped = bundleFile;
        this.patchedData = baseData;
        this.pfAdaptorHook = pFAdaptorHook;
    }

    public void close() throws IOException {
        this.wrapped.close();
    }

    public boolean containsDir(String string) {
        return this.wrapped.containsDir(string);
    }

    public BundleEntry getEntry(String string) {
        BundleFile[] bundleFileArray = this.getPatches();
        if (bundleFileArray == null) {
            return this.wrapped.getEntry(string);
        }
        if ("META-INF/MANIFEST.MF".equals(string)) {
            return this.wrapped.getEntry(string);
        }
        int n = 0;
        while (n < bundleFileArray.length) {
            BundleEntry bundleEntry = bundleFileArray[n].getEntry(string);
            if (bundleEntry != null) {
                if (PFConfigurator.DEBUG) {
                    System.out.println("Found patch for \"" + string + "\" in \"" + bundleFileArray[n] + "\"");
                }
                return bundleEntry;
            }
            ++n;
        }
        return this.wrapped.getEntry(string);
    }

    public Enumeration getEntryPaths(String string) {
        return this.wrapped.getEntryPaths(string);
    }

    public File getFile(String string, boolean bl) {
        BundleFile[] bundleFileArray = this.getPatches();
        if (bundleFileArray == null) {
            return this.wrapped.getFile(string, bl);
        }
        int n = 0;
        while (n < bundleFileArray.length) {
            File file = bundleFileArray[n].getFile(string, bl);
            if (file != null) {
                return file;
            }
            ++n;
        }
        return this.wrapped.getFile(string, bl);
    }

    public void open() throws IOException {
        this.wrapped.open();
    }

    private synchronized BundleFile[] getPatches() {
        if (this.processed) {
            return this.patches;
        }
        Bundle bundle = this.patchedData.getBundle();
        if (bundle == null) {
            return null;
        }
        if ((3 & bundle.getState()) != 0) {
            return null;
        }
        PackageAdmin packageAdmin = this.pfAdaptorHook.getPackageAdmin();
        if (packageAdmin == null) {
            return null;
        }
        ArrayList<Object> arrayList = new ArrayList<Object>();
        try {
            if ((packageAdmin.getBundleType(bundle) & 1) != 0) {
                return null;
            }
            arrayList.add(bundle);
            Bundle[] bundleArray = packageAdmin.getFragments(bundle);
            if (bundleArray == null) {
                return null;
            }
            ArrayList<BundleFile> arrayList2 = new ArrayList<BundleFile>(bundleArray.length);
            int n = 0;
            while (n < bundleArray.length) {
                AbstractBundle abstractBundle = (AbstractBundle)bundleArray[n];
                BaseData baseData = (BaseData)abstractBundle.getBundleData();
                PFStorageHook pFStorageHook = (PFStorageHook)baseData.getStorageHook(PFStorageHook.KEY);
                if (pFStorageHook.isPatchFragment()) {
                    String[] stringArray;
                    if (PFConfigurator.DEBUG) {
                        System.out.println("Found patch fragment: " + baseData.toString());
                    }
                    arrayList2.add(baseData.getBundleFile());
                    arrayList.add(abstractBundle);
                    if (DevClassPathHelper.inDevelopmentMode() && (stringArray = DevClassPathHelper.getDevClassPath((String)baseData.getSymbolicName())) != null) {
                        int n2 = 0;
                        while (n2 < stringArray.length) {
                            File file = baseData.getBundleFile().getFile(stringArray[n], false);
                            arrayList2.add(this.pfAdaptorHook.createDevClasspathBundleFile(file, baseData));
                            ++n2;
                        }
                    }
                }
                this.patches = arrayList2.toArray(new BundleFile[arrayList2.size()]);
                ++n;
            }
        }
        finally {
            this.pfAdaptorHook.listenToPatches(arrayList, this);
            this.processed = true;
        }
        return this.patches;
    }

    synchronized void resetPatches() {
        this.processed = false;
        this.patches = null;
    }

    public String toString() {
        return this.patchedData.toString();
    }
}

