/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.memcache.internal;

import com.agfa.pacs.cache.IMemoryAlertListener;
import com.agfa.pacs.cache.MemoryAlertHandler;
import com.agfa.pacs.logging.ALogger;
import com.agfa.pacs.memcache.CacheItem;
import com.agfa.pacs.memcache.DataCache;
import com.agfa.pacs.memcache.IPersistenceQueue;
import com.agfa.pacs.memcache.ItemState;
import com.agfa.pacs.memcache.internal.GlobalLRU;
import com.agfa.pacs.memcache.internal.MemoryManagementLink;
import java.lang.ref.ReferenceQueue;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public class PoolGuard
extends Thread
implements IMemoryAlertListener {
    private static final ALogger a = ALogger.getLogger(PoolGuard.class);
    private static long b;
    private final DataCache c;
    private AtomicInteger d = new AtomicInteger();
    private volatile boolean e = false;
    private Semaphore f = new Semaphore(0);

    public PoolGuard(DataCache dataCache) {
        super("PoolGuard");
        this.c = dataCache;
        this.setDaemon(true);
        try {
            MemoryManagementLink.init(dataCache, this);
            return;
        }
        catch (Throwable throwable) {
            a.error("mem link init failed", throwable);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public void run() {
        System.runFinalization();
        int n = 0;
        ReferenceQueue<Object> referenceQueue = CacheItem.collectedItems;
        while (true) {
            if (this.e) {
                this.f.release();
                return;
            }
            ++n;
            try {
                Object object;
                Object object2 = this.c.getGlobalLRU();
                do {
                    object = referenceQueue.poll();
                    CacheItem.referenceDisposed(object, (GlobalLRU)object2);
                } while (object != null);
                if (n % 100 == 0) {
                    this.c.purgeEmptyGroups();
                }
                if (b > 0L && (b = MemoryAlertHandler.firePersistentMemoryAlert((long)b, (boolean)false)) < 1000000L) {
                    b = 0L;
                }
                if (this.c.getParameters().keepFootprintSmall()) {
                    object2 = object = this.c.getPersistenceQueue();
                    // MONITORENTER : object
                    if (object.isEmpty()) {
                        object.wait();
                    } else {
                        this.setPriority(1);
                        this.writePersistentQueueContent(false);
                        this.setPriority(5);
                    }
                    // MONITOREXIT : object2
                }
                try {
                    Thread.sleep(Math.max(0L, 500L));
                }
                catch (InterruptedException interruptedException) {}
                System.currentTimeMillis();
                if (this.c.getParameters().isCleanThresholdExceeded()) {
                    this.writePersistentQueueContent(true);
                } else {
                    this.writePersistentQueueContent(false);
                }
                System.currentTimeMillis();
                if (n % 100 != 0) continue;
                this.c.getOnDisk().ensureDiskSizeWithFree();
                continue;
            }
            catch (ThreadDeath threadDeath) {
                this.f.release();
                return;
            }
            catch (Throwable throwable) {
                a.error("unknown error in pool guard!", throwable);
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writePersistentQueueContent(boolean bl) {
        IPersistenceQueue iPersistenceQueue = this.c.getPersistenceQueue();
        if (iPersistenceQueue.isEmpty()) {
            return;
        }
        if (bl) {
            this.setPriority(10);
        }
        this.d.incrementAndGet();
        try {
            while (!iPersistenceQueue.isEmpty()) {
                CacheItem cacheItem;
                IPersistenceQueue iPersistenceQueue2 = iPersistenceQueue;
                synchronized (iPersistenceQueue2) {
                    cacheItem = iPersistenceQueue.isEmpty() ? null : iPersistenceQueue.poll();
                }
                if (cacheItem == null) continue;
                cacheItem.writePersistent();
            }
        }
        finally {
            this.d.decrementAndGet();
            if (bl) {
                this.setPriority(1);
            }
        }
    }

    public void waitUntilPersistentFinished() {
        while (this.d.get() > 0) {
            try {
                Thread.sleep(20L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public synchronized void shutdownWithoutWriting() {
        this.e = true;
        this.c.getPersistenceQueue().clear();
        a.debug("Persistence queue cleared.");
        this.interrupt();
        try {
            boolean bl = this.f.tryAcquire(15L, TimeUnit.SECONDS);
            if (!bl) {
                a.warn("Shutdown semaphore could not be acquired within the waiting time.");
                return;
            }
        }
        catch (InterruptedException interruptedException) {
            a.warn("Shutdown semaphore could not be acquired.");
        }
    }

    public long memoryAlert(long l, boolean bl) {
        if (l < 0L) {
            l = Long.MAX_VALUE;
        }
        long l2 = this.freeMemory(l);
        return l - l2;
    }

    public long freeMemory(long l) {
        GlobalLRU globalLRU = this.c.getGlobalLRU();
        if ((l = PoolGuard.a(l, globalLRU, l)) <= 0L) {
            return l;
        }
        l = !this.c.getParameters().usePersistentStorage() ? MemoryAlertHandler.firePersistentMemoryAlert((long)l, (boolean)true) : this.a(l, globalLRU);
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long a(long l, GlobalLRU globalLRU) {
        CacheItem cacheItem;
        IPersistenceQueue iPersistenceQueue = this.c.getPersistenceQueue();
        ArrayList<CacheItem> arrayList = null;
        do {
            IPersistenceQueue iPersistenceQueue2 = iPersistenceQueue;
            synchronized (iPersistenceQueue2) {
                cacheItem = iPersistenceQueue.isEmpty() ? null : iPersistenceQueue.poll();
                iPersistenceQueue.notify();
            }
            if (cacheItem == null) continue;
            globalLRU.lockForWrite();
            try {
                boolean bl = false;
                CacheItem cacheItem2 = cacheItem;
                synchronized (cacheItem2) {
                    if (cacheItem.getUnsyncedState() == ItemState.PERSISTENT && !cacheItem.isReferencedUnsynced()) {
                        cacheItem.addReferenceUnsynced();
                        bl = true;
                    }
                    cacheItem.notify();
                }
                if (bl) {
                    cacheItem.writePersistent();
                    cacheItem2 = cacheItem;
                    synchronized (cacheItem2) {
                        if (cacheItem.getUnsyncedState() == ItemState.PERSONALIZED) {
                            l -= cacheItem.getManagementGroup().getSizeEstimate(cacheItem.releaseReferenceAndClaimItemSynced());
                        }
                        continue;
                    }
                }
                if (arrayList == null) {
                    arrayList = new ArrayList<CacheItem>();
                }
                arrayList.add(cacheItem);
            }
            finally {
                globalLRU.unlockForWrite();
            }
        } while (l > 0L && cacheItem != null);
        if (arrayList != null) {
            IPersistenceQueue iPersistenceQueue3 = iPersistenceQueue;
            synchronized (iPersistenceQueue3) {
                int n = 0;
                while (n < arrayList.size()) {
                    cacheItem = (CacheItem)arrayList.get(n);
                    iPersistenceQueue.addAtBottom(cacheItem);
                    ++n;
                }
            }
        }
        return l;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static long a(long l, GlobalLRU globalLRU, long l2) {
        CacheItem cacheItem;
        ArrayList<CacheItem> arrayList = new ArrayList<CacheItem>(globalLRU.size());
        globalLRU.lockForRead();
        try {
            Iterator<CacheItem> iterator = globalLRU.getItemIterator(30);
            while (iterator.hasNext() && l2 > 0L) {
                cacheItem = iterator.next();
                if (!cacheItem.isClaimableAndHasDataUnsynced()) continue;
                arrayList.add(cacheItem);
                long l3 = cacheItem.getManagementGroup().getSizeEstimate(null);
                l2 -= l3;
            }
        }
        finally {
            globalLRU.unlockForRead();
        }
        int n = 0;
        while (n < arrayList.size()) {
            cacheItem = (CacheItem)arrayList.get(n);
            Object object = cacheItem.claimItemSynced();
            if (object != null) {
                globalLRU.remove(cacheItem);
                cacheItem.getManagementGroup().removeItem(cacheItem);
                l -= cacheItem.getManagementGroup().getSizeEstimate(null);
            }
            ++n;
        }
        return l;
    }

    public static void requestPersistentAlert(long l) {
        b = l;
    }
}

