/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.memcache.internal;

import com.agfa.pacs.cache.CacheID;
import com.agfa.pacs.cache.GrouplessID;
import com.agfa.pacs.cache.IDataCacheProvider;
import com.agfa.pacs.logging.ALogger;
import com.agfa.pacs.memcache.CacheItem;
import com.agfa.pacs.memcache.CacheParameters;
import com.agfa.pacs.memcache.DataCache;
import com.agfa.pacs.memcache.ItemState;
import com.agfa.pacs.memcache.internal.GlobalLRU;
import com.agfa.pacs.memcache.internal.PoolGuard;
import com.agfa.pacs.tools.FileUtil;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;

public class DiskItemsHash {
    private static final ALogger b = ALogger.getLogger(DiskItemsHash.class);
    private Hashtable<CacheID, CacheItem> c;
    private final CacheParameters d;
    private final String e;
    public long nonControllable;
    public long diskCacheSize;
    LinkedHashMap<String, String> a;
    public static final String NOT_TOUCHED = "0";
    public static final String TOUCHED = "1";
    public static final String RESERVED = "2";
    private final DataCache f;
    private boolean g;
    private boolean h;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getGroupNames() {
        String[] stringArray;
        int n = 0;
        LinkedHashMap<String, String> linkedHashMap = this.a;
        synchronized (linkedHashMap) {
            stringArray = new String[this.a.size()];
            for (String string : this.a.keySet()) {
                stringArray[n++] = string;
            }
        }
        return stringArray;
    }

    public DiskItemsHash(DataCache dataCache, String string) {
        this.f = dataCache;
        this.d = dataCache.getParameters();
        this.e = string;
        this.c = new Hashtable();
        this.a = new LinkedHashMap();
        if (this.d.usePersistentStorage()) {
            new Thread((Runnable)new a(this, new File(String.valueOf(this.d.getLocation()) + "locks"), 0), "DiskCacheInitializer").start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CacheItem getItem(CacheID cacheID, Class<?> clazz, DataCache dataCache) {
        CacheItem cacheItem = this.c.get(cacheID);
        if (cacheItem != null) {
            GlobalLRU globalLRU = dataCache.getGlobalLRU();
            globalLRU.lockForWrite();
            try {
                CacheItem cacheItem2 = globalLRU.getUnsynced(cacheID);
                if (cacheItem2 == null) {
                    globalLRU.putUnsynced(cacheID, cacheItem);
                }
            }
            finally {
                globalLRU.unlockForWrite();
            }
            return cacheItem;
        }
        String string = cacheID.getGroup();
        if (string != null && this.d.isPermanent()) {
            Object object;
            String string2;
            Object object2 = this.a;
            synchronized (object2) {
                block32: {
                    string2 = (String)this.a.remove(string);
                    if (string2 != null) break block32;
                    return null;
                }
                if (string2 == NOT_TOUCHED) {
                    this.a.put(string, RESERVED);
                } else {
                    this.a.put(string, string2);
                }
            }
            object2 = dataCache.getGroupFor(clazz, cacheID, -1L);
            if (object2 == null || object2.isDestroyed()) {
                object = new File(String.valueOf(this.d.getLocation()) + File.separatorChar + cacheID);
                long l = ((File)object).length();
                object2 = dataCache.getGroupFor(clazz, cacheID, l);
            }
            if (object2.persistentItemExists(cacheID)) {
                object = dataCache.getGlobalLRU();
                ((GlobalLRU)object).lockForWrite();
                try {
                    cacheItem = ((GlobalLRU)object).getUnsynced(cacheID);
                    if (cacheItem == null) {
                        cacheItem = object2.createItem(null, cacheID, 30);
                        ((GlobalLRU)object).putUnsynced(cacheID, cacheItem);
                    }
                }
                finally {
                    ((GlobalLRU)object).unlockForWrite();
                }
                Serializable serializable = this.c;
                synchronized (serializable) {
                    if (!this.c.containsKey(cacheID)) {
                        this.c.put(cacheID, cacheItem);
                    }
                }
                if (string2 == NOT_TOUCHED) {
                    serializable = new File(String.valueOf(this.d.getLocation()) + string);
                    ((File)serializable).setLastModified(System.currentTimeMillis());
                }
                serializable = this.a;
                synchronized (serializable) {
                    this.a.put(string, TOUCHED);
                }
                return cacheItem;
            }
            if (string2 == NOT_TOUCHED) {
                object = this.a;
                synchronized (object) {
                    if (this.a.put(string, NOT_TOUCHED) == TOUCHED) {
                        this.a.put(string, TOUCHED);
                    }
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void freeDiskSpace(long l) {
        if (this.a.isEmpty()) {
            return;
        }
        long l2 = 0L;
        boolean bl = false;
        while (l2 < l && !this.a.isEmpty()) {
            boolean bl2;
            Object object;
            LinkedHashMap<String, String> linkedHashMap = this.a;
            synchronized (linkedHashMap) {
                object = this.a.keySet().iterator().next();
                bl2 = this.a.get(object) != NOT_TOUCHED;
                if (!bl2) {
                    this.a.remove(object);
                }
            }
            if (bl2) {
                if (this.g) {
                    this.g = false;
                    this.b();
                    continue;
                }
                if (bl) {
                    return;
                }
                PoolGuard.requestPersistentAlert(2L * (this.diskCacheSize - this.d.getDiskSizeLimit()));
                if (this.g) {
                    this.b();
                    this.g = false;
                }
                bl = true;
                continue;
            }
            long l3 = 0L;
            File file = new File(String.valueOf(this.d.getLocation()) + IDataCacheProvider.persistenceModifiers[1] + File.separatorChar + (String)object);
            object = file.listFiles();
            if (object != null) {
                File[] fileArray = object;
                int n = ((File[])object).length;
                int n2 = 0;
                while (n2 < n) {
                    object = fileArray[n2];
                    l3 += ((File)object).length();
                    ((File)object).delete();
                    ++n2;
                }
            }
            file.delete();
            l2 += l3;
            this.b(l3);
        }
    }

    public void ensureDiskSize() {
        this.freeDiskSpace(this.diskCacheSize - this.d.getDiskSizeLimit());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void b() {
        HashMap<String, String> hashMap;
        HashMap<String, String> hashMap2 = new HashMap<String, String>();
        LinkedHashMap<String, String> object5 = this.a;
        synchronized (object5) {
            hashMap = new HashMap<String, String>(this.a);
        }
        Hashtable<CacheID, CacheItem> hashtable = this.c;
        synchronized (hashtable) {
            for (CacheID cacheID : this.c.keySet()) {
                Object object = cacheID.getGroup();
                if (object == null) {
                    object = cacheID.getID();
                    object = ((String)object).substring(((String)object).indexOf(File.separatorChar) + 1);
                }
                hashMap.remove(object);
                hashMap2.put((String)object, cacheID.getID());
            }
        }
        LinkedHashMap<String, String> linkedHashMap = this.a;
        synchronized (linkedHashMap) {
            LinkedHashMap<String, String> linkedHashMap2 = new LinkedHashMap<String, String>();
            for (Map.Entry entry : this.a.entrySet()) {
                if (hashMap.get(entry.getKey()) == null) {
                    linkedHashMap2.put((String)entry.getKey(), TOUCHED);
                    continue;
                }
                if (entry.getValue() != RESERVED) continue;
                linkedHashMap2.put((String)entry.getKey(), RESERVED);
            }
            this.a.clear();
            for (String string : hashMap.keySet()) {
                this.a.put(string, NOT_TOUCHED);
            }
            this.a.putAll(linkedHashMap2);
        }
        if (b.isDebugEnabled()) {
            for (Map.Entry entry : hashMap2.entrySet()) {
                b.debug("not untouched " + (String)entry.getKey() + " becau1se of " + (String)entry.getValue());
            }
        }
    }

    private synchronized void a(long l) {
        this.diskCacheSize += l;
    }

    private synchronized void b(long l) {
        this.diskCacheSize -= l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(CacheItem cacheItem, long l) {
        if (cacheItem.getUnsyncedState() == ItemState.DELETED) {
            return;
        }
        this.a(l);
        if (cacheItem.getID().getType() == 1) {
            String string = cacheItem.getID().getGroup();
            if (string == null) {
                string = cacheItem.getID().toString();
                string = string.substring(string.indexOf(File.separatorChar) + 1);
            }
            LinkedHashMap<String, String> linkedHashMap = this.a;
            synchronized (linkedHashMap) {
                this.a.remove(string);
                this.a.put(string, TOUCHED);
            }
        }
        Hashtable<CacheID, CacheItem> hashtable = this.c;
        synchronized (hashtable) {
            this.c.put(cacheItem.getID(), cacheItem);
            return;
        }
    }

    public synchronized CacheItem sniffItem(CacheID cacheID) {
        return this.c.get(cacheID);
    }

    @SuppressWarnings(value={"SWL_SLEEP_WITH_LOCK_HELD"})
    public synchronized void deleteItem(CacheItem object, boolean n) {
        this.c.remove(((CacheItem)object).getID());
        this.g = true;
        if (!(n == 0 && !(((CacheItem)object).getID() instanceof GrouplessID) && this.d.isPermanent() || ((File)(object = new File(String.valueOf(this.d.getLocation()) + ((CacheItem)object).getID()))).delete() || !((File)object).exists() || ((File)object).delete())) {
            n = 0;
            while (!((File)object).delete() && n < 100) {
                try {
                    Thread.sleep(20L);
                }
                catch (InterruptedException interruptedException) {}
                ++n;
            }
        }
    }

    public synchronized void removeFromList(CacheItem cacheItem) {
        this.c.remove(cacheItem.getID());
    }

    public boolean exists(CacheID object) {
        CacheItem cacheItem = this.c.get(object);
        if (cacheItem != null) {
            return true;
        }
        if (object.getType() == 1 && this.d.isPermanent()) {
            object = new File(String.valueOf(this.d.getLocation()) + object);
            return object.exists();
        }
        return false;
    }

    public void clearTempData() {
        File file = new File(String.valueOf(this.d.getLocation()) + File.separatorChar + IDataCacheProvider.persistenceModifiers[0]);
        FileUtil.remove((File)file);
    }

    public void setDeleteOccured() {
        this.g = true;
    }

    public void ensureDiskSizeWithFree() {
        File file = new File(this.f.getParameters().getLocation());
        long l = 4000000000L;
        try {
            l = file.getFreeSpace();
        }
        catch (NoSuchMethodError noSuchMethodError) {}
        long l2 = this.d.getMinimumFreeDisk();
        if (l < l2) {
            l -= 500000000L;
        }
        this.freeDiskSpace(Math.max(l2 - l, this.diskCacheSize - this.d.getDiskSizeLimit()));
    }

    public boolean startupComplete() {
        return this.h;
    }

    private final class a
    implements Runnable {
        private Map<String, String> a;
        private final long b;
        private final boolean c = DiskItemsHash.a().isDebugEnabled();
        private /* synthetic */ DiskItemsHash d;

        private a(DiskItemsHash object, File file) {
            this.d = object;
            this.b = System.currentTimeMillis();
            long l = 0L;
            if (this.c) {
                l = System.nanoTime();
            }
            object = file.listFiles();
            this.a = new HashMap<String, String>();
            File[] fileArray = object;
            int n = ((File[])object).length;
            int n2 = 0;
            while (n2 < n) {
                object = fileArray[n2];
                if (!((File)object).delete()) {
                    this.a.put(((File)object).getName().toLowerCase(Locale.getDefault()), ((File)object).getName());
                }
                ++n2;
            }
            if (this.c) {
                l = (System.nanoTime() - l) / 1000000L;
                b.debug("Setup of not erasable groups took " + l);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final void run() {
            try {
                Object object;
                File[] fileArray;
                int n;
                Object object2;
                Serializable serializable;
                Thread.currentThread().setPriority(1);
                String string = this.d.e.substring(0, this.d.e.indexOf(64, 1) + 1).toLowerCase(Locale.getDefault());
                StringBuilder stringBuilder = null;
                long l = 0L;
                if (this.c) {
                    stringBuilder = new StringBuilder("Initialization of cache took (cleanup/content registration/cache structures/disk space check) ");
                    l = System.nanoTime();
                }
                Object object3 = new File(String.valueOf(this.d.d.getLocation()) + File.separatorChar);
                b.info("Cache Folder:" + ((File)object3).getAbsolutePath());
                if (this.d.d.isPermanent()) {
                    b.info("Session persistence activated. (Cache will be cleared on shutdown: {})", (Object)this.d.d.clearCacheOnShutdown());
                }
                if (((File)object3).exists()) {
                    File[] fileArray2 = ((File)object3).listFiles();
                    object3 = fileArray2;
                    object3 = fileArray2;
                    int n2 = fileArray2.length;
                    int n3 = 0;
                    while (n3 < n2) {
                        serializable = object3[n3];
                        object2 = ((File)serializable).getName().toLowerCase(Locale.getDefault());
                        n = 0;
                        if (((String)object2).startsWith(string)) {
                            n = 1;
                        }
                        if ((!this.d.d.isPermanent() || this.d.d.clearCacheOnShutdown()) && ((String)object2).equals(IDataCacheProvider.persistenceModifiers[1])) {
                            n = 1;
                        }
                        if (n != 0 && (this.a.isEmpty() || !this.a.containsKey(((String)object2).substring(0, ((String)object2).lastIndexOf(64) + 1)))) {
                            fileArray = ((File)serializable).listFiles();
                            if (fileArray != null) {
                                n = fileArray.length;
                                int n4 = 0;
                                while (n4 < n) {
                                    Object object4;
                                    object = fileArray[n4];
                                    if (((File)object).isDirectory() && (object4 = ((File)object).listFiles()) != null) {
                                        File[] fileArray3 = object4;
                                        int n5 = ((File[])object4).length;
                                        int n6 = 0;
                                        while (n6 < n5) {
                                            object4 = fileArray3[n6];
                                            object4.delete();
                                            ++n6;
                                        }
                                    }
                                    ((File)object).delete();
                                    ++n4;
                                }
                            }
                            ((File)serializable).delete();
                        }
                        ++n3;
                    }
                } else {
                    ((File)object3).mkdirs();
                }
                if (this.c) {
                    l = (System.nanoTime() - l) / 1000000L;
                    stringBuilder.append(l);
                    l = System.nanoTime();
                }
                if (!((File)(object3 = new File(String.valueOf(this.d.d.getLocation()) + File.separatorChar + IDataCacheProvider.persistenceModifiers[1]))).exists()) {
                    ((File)object3).mkdirs();
                }
                object3 = ((File)object3).listFiles();
                serializable = new ArrayList();
                long l2 = 0L;
                if (object3 != null) {
                    fileArray = object3;
                    n = fileArray.length;
                    int n7 = 0;
                    while (n7 < n) {
                        object3 = fileArray[n7];
                        if (((File)object3).isDirectory()) {
                            object = ((File)object3).listFiles();
                            if (((File[])object).length == 0 && ((File)object3).lastModified() < this.b) {
                                ((File)object3).delete();
                            } else {
                                ((ArrayList)serializable).add(object3);
                                l2 += com.agfa.pacs.memcache.internal.DiskItemsHash$a.a((File[])object);
                            }
                        }
                        ++n7;
                    }
                }
                if (this.c) {
                    l = (System.nanoTime() - l) / 1000000L;
                    stringBuilder.append("/").append(l);
                    l = System.nanoTime();
                }
                Collections.sort(serializable, new b(0));
                object3 = this.d.a;
                synchronized (object3) {
                    Iterator iterator = ((ArrayList)serializable).iterator();
                    while (iterator.hasNext()) {
                        object2 = (File)iterator.next();
                        if (this.d.a.containsKey(((File)object2).getName())) continue;
                        this.d.a.put(((File)object2).getName(), DiskItemsHash.NOT_TOUCHED);
                    }
                }
                this.d.a(l2);
                if (this.c) {
                    l = (System.nanoTime() - l) / 1000000L;
                    stringBuilder.append("/").append(l);
                    l = System.nanoTime();
                }
                this.d.ensureDiskSizeWithFree();
                if (this.c) {
                    l = (System.nanoTime() - l) / 1000000L;
                    stringBuilder.append("/").append(l);
                    b.debug(stringBuilder.toString());
                }
                b.info("data in persistent files:" + this.d.diskCacheSize);
            }
            finally {
                this.d.h = true;
            }
        }

        private static long a(File[] object) {
            long l = 0L;
            File[] fileArray = object;
            int n = ((File[])object).length;
            int n2 = 0;
            while (n2 < n) {
                object = fileArray[n2];
                l += ((File)object).length();
                ++n2;
            }
            return l;
        }

        /* synthetic */ a(DiskItemsHash diskItemsHash, File file, byte by) {
            this(diskItemsHash, file);
        }
    }

    private static final class b
    implements Comparator<File> {
        private b() {
        }

        @Override
        public final /* synthetic */ int compare(Object object, Object object2) {
            long l;
            object2 = (File)object2;
            long l2 = ((File)(object = (File)object)).lastModified();
            if (l2 < (l = ((File)object2).lastModified())) {
                return -1;
            }
            if (l2 > l) {
                return 1;
            }
            return 0;
        }

        /* synthetic */ b(byte by) {
            this();
        }
    }
}

