/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.memcache.internal;

import com.agfa.pacs.logging.ALogger;
import com.agfa.pacs.memcache.DataCache;
import com.agfa.pacs.memcache.DistinctFileGroup;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.Arrays;

public class CachedShortGroup
extends DistinctFileGroup {
    private static final ALogger a = ALogger.getLogger(CachedShortGroup.class);

    public CachedShortGroup(long l, DataCache dataCache) {
        super(l, dataCache);
    }

    @Override
    public void clear(Object object) {
        short[] sArray = (short[])object;
        object = sArray;
        Arrays.fill(sArray, (short)0);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public Object allocateNew() {
        try {
            return new short[(int)this.length];
        }
        catch (OutOfMemoryError v0) {
            this.dataCache.ensureFreeMemory(this.length * 3L);
            try {
                return new short[(int)this.length];
            }
            catch (OutOfMemoryError v1) {
                this.dataCache.ensureFreeMemory(-1L);
                try {
                    return new short[(int)this.length];
                }
                catch (OutOfMemoryError var1_1) {
                    CachedShortGroup.a.info("VERY low memory, repeating allocation attempt...");
                    var2_2 = 0;
                    ** while (var2_2 < 20)
                }
            }
        }
lbl-1000:
        // 1 sources

        {
            try {
                Thread.sleep((long)(300.0 * Math.random()));
                this.dataCache.ensureFreeMemory(-1L);
                System.gc();
            }
            catch (InterruptedException v2) {}
            try {
                return new short[(int)this.length];
            }
            catch (OutOfMemoryError v3) {
                ++var2_2;
            }
            continue;
        }
lbl26:
        // 1 sources

        CachedShortGroup.a.info("allocation of " + 2L * this.length + " failed");
        throw var1_1;
    }

    @Override
    public void readNative(Object object, String string) throws IOException {
        this.readNativeShorts((short[])object, string);
    }

    @Override
    public void readNIO(Object object, String object2) throws IOException {
        object = (short[])object;
        object2 = new RandomAccessFile((String)object2, "r");
        try {
            MappedByteBuffer mappedByteBuffer = ((RandomAccessFile)object2).getChannel().map(FileChannel.MapMode.READ_ONLY, 0L, ((Object)object).length << 1);
            mappedByteBuffer.order(ByteOrder.nativeOrder());
            mappedByteBuffer.asShortBuffer().get((short[])object);
        }
        finally {
            ((RandomAccessFile)object2).close();
        }
    }

    @Override
    public void writeNative(Object object, String string) throws IOException {
        this.writeNativeShorts((short[])object, string);
    }

    @Override
    public void writeNIO(Object object, String string) throws IOException {
        object = (short[])object;
        try {
            RandomAccessFile randomAccessFile;
            try {
                randomAccessFile = new RandomAccessFile(string, "rw");
            }
            catch (FileNotFoundException fileNotFoundException) {
                new File(string).getParentFile().mkdirs();
                randomAccessFile = new RandomAccessFile(string, "rw");
            }
            try {
                Object object2 = randomAccessFile.getChannel();
                if (object == null) {
                    throw new NullPointerException();
                }
                if (object2 == null) {
                    throw new NullPointerException();
                }
                object2 = ((FileChannel)object2).map(FileChannel.MapMode.READ_WRITE, 0L, ((Object)object).length << 1);
                ((ByteBuffer)object2).order(ByteOrder.nativeOrder());
                ((ByteBuffer)object2).asShortBuffer().put((short[])object);
            }
            finally {
                randomAccessFile.close();
            }
            return;
        }
        catch (IOException iOException) {
            new File(string).delete();
            throw iOException;
        }
    }

    @Override
    public long getSizeEstimate(Object object) {
        if (object != null) {
            return ((short[])object).length << 1;
        }
        return 2L * this.length;
    }
}

