/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.memcache.internal;

import com.agfa.pacs.memcache.DataCache;
import com.agfa.pacs.memcache.DistinctFileGroup;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteOrder;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.Arrays;

public class CachedDoubleGroup
extends DistinctFileGroup {
    public CachedDoubleGroup(long l, DataCache dataCache) {
        super(l, dataCache);
    }

    @Override
    public void clear(Object object) {
        double[] dArray = (double[])object;
        object = dArray;
        Arrays.fill(dArray, 0.0);
    }

    @Override
    public Object allocateNew() {
        try {
            return new double[(int)this.length];
        }
        catch (OutOfMemoryError outOfMemoryError) {
            this.dataCache.ensureFreeMemory(this.length * 12L);
            try {
                return new double[(int)this.length];
            }
            catch (OutOfMemoryError outOfMemoryError2) {
                this.dataCache.ensureFreeMemory(-1L);
                return new double[(int)this.length];
            }
        }
    }

    @Override
    public void readNative(Object object, String string) throws IOException {
        this.readNativeDoubles((double[])object, string);
    }

    @Override
    public void readNIO(Object object, String object2) throws IOException {
        object = (double[])object;
        object2 = new RandomAccessFile((String)object2, "r");
        try {
            MappedByteBuffer mappedByteBuffer = ((RandomAccessFile)object2).getChannel().map(FileChannel.MapMode.READ_ONLY, 0L, ((Object)object).length << 3);
            mappedByteBuffer.order(ByteOrder.nativeOrder());
            mappedByteBuffer.asDoubleBuffer().get((double[])object);
        }
        finally {
            ((RandomAccessFile)object2).close();
        }
    }

    @Override
    public void writeNative(Object object, String string) throws IOException {
        this.writeNativeDoubles((double[])object, string);
    }

    @Override
    public void writeNIO(Object object, String string) throws IOException {
        object = (double[])object;
        try {
            RandomAccessFile randomAccessFile;
            try {
                randomAccessFile = new RandomAccessFile(string, "rw");
            }
            catch (FileNotFoundException fileNotFoundException) {
                new File(string).getParentFile().mkdirs();
                randomAccessFile = new RandomAccessFile(string, "rw");
            }
            try {
                MappedByteBuffer mappedByteBuffer = randomAccessFile.getChannel().map(FileChannel.MapMode.READ_WRITE, 0L, ((Object)object).length << 3);
                mappedByteBuffer.order(ByteOrder.nativeOrder());
                mappedByteBuffer.asDoubleBuffer().put((double[])object);
            }
            finally {
                randomAccessFile.close();
            }
            return;
        }
        catch (IOException iOException) {
            new File(string).delete();
            throw iOException;
        }
    }

    @Override
    public long getSizeEstimate(Object object) {
        if (object != null) {
            return ((double[])object).length << 3;
        }
        return this.length << 3;
    }
}

