/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.memcache.blocked;

import com.agfa.pacs.cache.CacheID;
import com.agfa.pacs.memcache.ArrayIO;
import com.agfa.pacs.memcache.BlockedFileGroup;
import com.agfa.pacs.memcache.CacheItem;
import com.agfa.pacs.memcache.DataCache;
import com.agfa.pacs.memcache.ICachedObjectGroup;
import com.agfa.pacs.memcache.internal.CachedShortGroup;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.nio.ByteOrder;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.BitSet;

public class BlockedShortArrayGroup
extends BlockedFileGroup {
    private CachedShortGroup a;

    public BlockedShortArrayGroup(DataCache dataCache, String string, boolean bl, long l) {
        super(dataCache, string, bl, l << 1);
    }

    @Override
    public void setLength(long l) {
        super.setLength(l);
        if (l >= 0L) {
            this.a = this.dataCache.getShortGroup(l / 2L);
        }
    }

    @Override
    public Object readItem(InputStream inputStream, long l) throws IOException {
        Object object;
        inputStream = new ObjectInputStream(inputStream);
        try {
            try {
                object = ((ObjectInputStream)inputStream).readObject();
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new IOException(classNotFoundException.getMessage());
            }
        }
        finally {
            ((ObjectInputStream)inputStream).close();
        }
        return object;
    }

    @Override
    public void writeItem(DataOutputStream dataOutputStream, Object object) throws IOException {
        throw new UnsupportedOperationException("not implemented");
    }

    @Override
    public boolean isAllocationAllowed() {
        return this.dataCache.getParameters().isAllocationAllowed(this.length);
    }

    @Override
    public Object allocateNew() {
        return this.a.allocateNew();
    }

    @Override
    public void clear(Object object) {
    }

    @Override
    public void readNIO(Object object, long l) throws IOException {
        object = (short[])object;
        MappedByteBuffer mappedByteBuffer = this.df.getChannel().map(FileChannel.MapMode.READ_ONLY, l, this.length);
        mappedByteBuffer.order(ByteOrder.nativeOrder());
        mappedByteBuffer.asShortBuffer().get((short[])object);
    }

    @Override
    public void readNative(Object object, long l) throws IOException {
        short[] sArray = (short[])object;
        object = sArray;
        long l2 = ArrayIO.readShortArray(sArray, l, 0, ((Object)object).length, this.nativeFileHandle);
        if (l2 != 0L) {
            throw new IOException(ArrayIO.getErrorMessage(l2));
        }
    }

    @Override
    public void writeNIO(Object object, long l) throws IOException {
        object = (short[])object;
        try {
            FileChannel fileChannel = this.df.getChannel();
            if (object == null) {
                throw new NullPointerException();
            }
            if (fileChannel == null) {
                throw new NullPointerException();
            }
            MappedByteBuffer mappedByteBuffer = fileChannel.map(FileChannel.MapMode.READ_WRITE, l, this.length);
            mappedByteBuffer.order(ByteOrder.nativeOrder());
            mappedByteBuffer.asShortBuffer().put((short[])object);
            mappedByteBuffer.force();
            return;
        }
        catch (IOException iOException) {
            IOException iOException2 = iOException;
            throw iOException;
        }
    }

    @Override
    public void writeNative(Object object, long l) throws IOException {
        short[] sArray = (short[])object;
        object = sArray;
        long l2 = ArrayIO.writeShortArray(sArray, l, 0, ((Object)object).length, this.nativeFileHandle);
        if (l2 != 0L) {
            throw new IOException(ArrayIO.getErrorMessage(l2));
        }
    }

    @Override
    public long getSizeEstimate(Object object) {
        if (object != null) {
            return ((short[])object).length << 1;
        }
        return this.length;
    }

    @Override
    public boolean isDestroyed() {
        BitSet bitSet = this.getPresence();
        return bitSet != null && bitSet.isEmpty();
    }

    @Override
    public CacheItem createItem(Object object, CacheID cacheID, int n) {
        return new CacheItem(object, cacheID, this, (ICachedObjectGroup)this.a, n);
    }

    @Override
    public void addPersistent(Object object, CacheID cacheID, int n) {
        if (this.length < 0L) {
            this.setLength(this.getSizeEstimate(object));
            this.createInfoFile(String.valueOf(this.dataFile.substring(0, this.dataFile.length() - 3)) + "nfo");
        }
        if ((object = this.addPersistentInternal(object, cacheID, n)) != null) {
            this.a.addPersistent((CacheItem)object);
        }
    }

    @Override
    public Object getPersistent(CacheItem cacheItem, CacheID cacheID) {
        this.a.touchLocally(cacheItem, cacheID);
        return this.getPersistentInternal(cacheItem, cacheID);
    }
}

