/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.memcache;

import com.agfa.pacs.cache.CacheID;
import com.agfa.pacs.memcache.DataCache;
import com.agfa.pacs.memcache.ICachedObjectGroup;
import com.agfa.pacs.memcache.ICachedObjectHandler;

public abstract class PrimitiveArrayHandler
implements ICachedObjectHandler {
    protected long prefix;
    protected long sizeMultiplier;
    protected DataCache dataCache;

    public PrimitiveArrayHandler(long l, int n, DataCache dataCache) {
        this.prefix = l;
        this.sizeMultiplier = n;
        this.dataCache = dataCache;
    }

    @Override
    public Object getGroupID(CacheID cacheID, long l) {
        if (l < 0L) {
            return null;
        }
        return this.prefix | l / this.sizeMultiplier;
    }

    @Override
    public abstract ICachedObjectGroup createGroup(CacheID var1, long var2);

    @Override
    public abstract Object getGroupID(CacheID var1, Object var2);

    @Override
    public abstract ICachedObjectGroup createGroup(Object var1, Object var2);

    @Override
    public Object getGroupID(Object[] objectArray) {
        return this.prefix | (Long)objectArray[0];
    }

    @Override
    public void init(DataCache dataCache) {
        this.dataCache = dataCache;
    }
}

