/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.memcache;

import com.agfa.pacs.cache.CacheID;
import com.agfa.pacs.core.ApplicationManagement;
import com.agfa.pacs.logging.ALogger;
import com.agfa.pacs.memcache.ICachedObjectGroup;
import com.agfa.pacs.memcache.ItemState;
import com.agfa.pacs.memcache.internal.GlobalLRU;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;

public class CacheItem {
    private static final ALogger a = ALogger.getLogger(CacheItem.class);
    private static final boolean b = ApplicationManagement.getInstance().getApplicationType().isAgility();
    private static Reference c = new a((Object)null);
    public static final ReferenceQueue<Object> collectedItems = new ReferenceQueue();
    private ItemState d;
    protected Object item;
    protected int referenceCount;
    private ICachedObjectGroup e;
    private ICachedObjectGroup f;
    private CacheID g;
    private int h;

    public CacheItem(Object object, ICachedObjectGroup iCachedObjectGroup) {
        this.d = ItemState.ANONYMOUS;
        this.item = new b(object, collectedItems, this);
        this.e = iCachedObjectGroup;
        this.f = iCachedObjectGroup;
        this.h = 15;
    }

    public CacheItem(Object object, CacheID cacheID, ItemState itemState, ICachedObjectGroup iCachedObjectGroup, int n) {
        this.d = itemState;
        if (itemState == ItemState.PERSISTENT) {
            this.item = object;
        } else if (itemState == ItemState.PERSONALIZED) {
            this.item = new a(object, collectedItems, this);
        } else {
            throw new IllegalArgumentException();
        }
        this.g = cacheID;
        this.e = iCachedObjectGroup;
        this.f = iCachedObjectGroup;
        this.h = n;
    }

    public CacheItem(Object object, CacheID cacheID, ICachedObjectGroup iCachedObjectGroup, int n) {
        this.g = cacheID;
        this.item = object;
        this.h = n;
        this.d = this.item == null ? ItemState.PERSONALIZED : ItemState.PERSISTENT;
        this.e = iCachedObjectGroup;
        this.f = iCachedObjectGroup;
    }

    public CacheItem(Object object, CacheID cacheID, ICachedObjectGroup iCachedObjectGroup, ICachedObjectGroup iCachedObjectGroup2, int n) {
        this(object, cacheID, iCachedObjectGroup2, n);
        if (object == null) {
            this.d = ItemState.PERSONALIZED;
            this.item = c;
        }
        this.f = iCachedObjectGroup;
    }

    public Object getItemUnsynced() {
        if (this.item == null) {
            return null;
        }
        if (this.item instanceof b) {
            Object t = ((Reference)this.item).get();
            return t;
        }
        if (this.item instanceof a) {
            return ((Reference)this.item).get();
        }
        return this.item;
    }

    public boolean dataAvailableUnsynced() {
        if (this.item == null) {
            return false;
        }
        if (this.item instanceof Reference) {
            return ((Reference)this.item).get() != null;
        }
        return true;
    }

    public synchronized Object claimItemSynced() {
        if (this.item == null) {
            return null;
        }
        if (this.d == ItemState.ANONYMOUS) {
            Object t = ((Reference)this.item).get();
            this.item = null;
            return t;
        }
        if (this.d == ItemState.PERSONALIZED) {
            if (this.referenceCount > 0) {
                return null;
            }
            if (!(this.item instanceof Reference)) {
                a.warn("oops... this is a message from mem cache CacheItem");
            }
            Object t = ((Reference)this.item).get();
            this.item = null;
            return t;
        }
        return null;
    }

    public synchronized Object releaseReferenceAndClaimItemSynced() {
        --this.referenceCount;
        if (this.item == null) {
            return null;
        }
        if (this.d == ItemState.ANONYMOUS) {
            Object t = ((Reference)this.item).get();
            this.item = null;
            return t;
        }
        if (this.d == ItemState.PERSONALIZED) {
            if (this.referenceCount > 0) {
                return null;
            }
            Object t = ((Reference)this.item).get();
            this.item = null;
            return t;
        }
        return null;
    }

    public synchronized Object getItemReferenceSynced() {
        if (this.item == null) {
            return null;
        }
        if (this.item instanceof b) {
            throw new IllegalStateException();
        }
        if (this.item instanceof a) {
            Object t = ((Reference)this.item).get();
            if (t != null) {
                ++this.referenceCount;
            }
            return t;
        }
        Object object = this.item;
        ++this.referenceCount;
        return object;
    }

    public boolean isClaimableUnsynced() {
        return this.referenceCount == 0 && this.d.isClaimable();
    }

    public boolean isClaimableAndHasDataUnsynced() {
        if (this.referenceCount != 0 || !this.d.isClaimable()) {
            return false;
        }
        Object object = this.item;
        if (object instanceof Reference) {
            return ((Reference)object).get() != null;
        }
        return object != null;
    }

    public synchronized void releaseReferenceSynced() {
        --this.referenceCount;
        if (this.referenceCount < 0) {
            this.referenceCount = 0;
            throw new IllegalStateException("reference count underrun for " + this.g);
        }
        if (this.referenceCount == 0 && this.d == ItemState.DELETED) {
            this.removeUnsynced(false);
        }
    }

    public ItemState getUnsyncedState() {
        return this.d;
    }

    public ICachedObjectGroup getManagementGroup() {
        return this.e;
    }

    public ICachedObjectGroup getPersistenceGroup() {
        return this.f;
    }

    public void writePersistent() {
        if (!b && this.f.isDestroyed()) {
            return;
        }
        this.f.writePersistent(this);
    }

    public synchronized void setStateSynced(ItemState itemState) {
        if (itemState == ItemState.WRITING && (this.item == null || this.item instanceof Reference)) {
            throw new Error("trying to write null item:" + this.toString());
        }
        if (this.d == ItemState.DELETED) {
            return;
        }
        this.d = itemState;
        if (itemState == ItemState.PERSONALIZED && !(this.item instanceof a)) {
            this.item = new a(this.getItemUnsynced(), collectedItems, this);
        }
        if (itemState == ItemState.ANONYMOUS && !(this.item instanceof b)) {
            this.item = new b(this.getItemUnsynced(), collectedItems, this);
        }
    }

    public void resurrect(Object object) {
        if (this.d != ItemState.DELETED) {
            throw new IllegalStateException();
        }
        this.d = ItemState.PERSISTENT;
        this.item = object;
    }

    public void setStateUnsynced(ItemState itemState) {
        if (itemState == ItemState.WRITING && (this.item == null || this.item instanceof Reference)) {
            throw new Error("trying to write null item:" + this.toString());
        }
        if (this.d == ItemState.DELETED) {
            return;
        }
        this.d = itemState;
        if (itemState == ItemState.PERSONALIZED && !(this.item instanceof a)) {
            this.item = new a(this.getItemUnsynced(), collectedItems, this);
            return;
        }
        if (itemState == ItemState.ANONYMOUS && !(this.item instanceof b)) {
            this.item = new b(this.getItemUnsynced(), collectedItems, this);
        }
    }

    public CacheID getID() {
        return this.g;
    }

    public void setDataUnsynced(Object object) {
        assert (this.d == ItemState.READING);
        this.item = new a(object, collectedItems, this);
    }

    public boolean isReferencedUnsynced() {
        return this.referenceCount > 0;
    }

    public String toString() {
        if (this.d == ItemState.ANONYMOUS) {
            return "ANONYMOUS   :" + (this.item == null ? null : ((Reference)this.item).get());
        }
        if (this.d == ItemState.PERSONALIZED) {
            return "PERSONALIZED:" + this.g + " Refs:" + this.referenceCount + ":(R)" + (this.item == null ? null : ((Reference)this.item).get());
        }
        if (this.d == ItemState.PERSISTENT) {
            return "PERSISTENT:" + this.g + " Refs:" + this.referenceCount + ":" + this.item;
        }
        return (Object)((Object)this.d) + ":" + this.g + " Refs:" + this.referenceCount + ":" + this.item;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeUnsynced(boolean bl) {
        boolean bl2;
        CacheItem cacheItem = this;
        synchronized (cacheItem) {
            bl2 = this.referenceCount == 0;
            if (bl2) {
                ++this.referenceCount;
            }
            this.item = null;
            this.d = ItemState.DELETED;
            this.f.removeFromDisk(this, bl);
        }
        if (bl2) {
            this.e.removeGlobally(this);
        }
    }

    public void removeFromGroupUnsynced() {
        this.e.removeItem(this);
    }

    public synchronized void updateAndReleaseReferenceSynced() {
        --this.referenceCount;
        if (this.referenceCount < 0) {
            throw new IllegalStateException("reference count underrun for " + this.g);
        }
        if (this.d == ItemState.DELETED) {
            if (this.referenceCount == 0) {
                this.removeUnsynced(false);
            }
            throw new IllegalStateException("modified deleted object of " + this.g);
        }
        if (this.d == ItemState.WRITING) {
            this.d = ItemState.MODIFIED;
            return;
        }
        this.item = this.getItemUnsynced();
        this.d = ItemState.PERSISTENT;
    }

    public void touch() {
        this.e.touch(this, this.g);
    }

    public void addReferenceUnsynced() {
        ++this.referenceCount;
    }

    public void checkSanity() {
        if (this.item != null && !(this.item instanceof Reference) && this.referenceCount == 0 && this.d != ItemState.WRITING) {
            a.warn((Object)((Object)this.d) + " hard ref without referrers:" + this.g);
        }
    }

    public void setPriority(int n) {
        boolean bl = this.h != n;
        if (bl) {
            this.h = n;
            this.e.priorityChanged(this);
        }
    }

    public int getPriority() {
        return this.h;
    }

    public static void referenceDisposed(Reference<? extends Object> reference, GlobalLRU globalLRU) {
        if (reference instanceof b) {
            ((b)reference).a().a(globalLRU);
            return;
        }
        if (reference instanceof a) {
            ((a)reference).a().a(globalLRU);
        }
    }

    private void a(GlobalLRU globalLRU) {
        if (this.g == null) {
            this.e.removeAnonymousItem(this);
            return;
        }
        globalLRU.remove(this);
    }

    private static final class a
    extends SoftReference<Object> {
        private final CacheItem a;

        public a(Object object, ReferenceQueue<Object> referenceQueue, CacheItem cacheItem) {
            super(object, referenceQueue);
            this.a = cacheItem;
        }

        public a(Object object) {
            super(null);
            this.a = null;
        }

        public final CacheItem a() {
            return this.a;
        }
    }

    private static final class b
    extends WeakReference<Object> {
        private final CacheItem a;

        public b(Object object, ReferenceQueue<Object> referenceQueue, CacheItem cacheItem) {
            super(object, referenceQueue);
            this.a = cacheItem;
        }

        public final CacheItem a() {
            return this.a;
        }
    }
}

