/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.memcache;

import com.agfa.pacs.cache.CacheID;
import com.agfa.pacs.cache.CacheWriteProblem;
import com.agfa.pacs.event.ActionInfo;
import com.agfa.pacs.event.EventEngineFactory;
import com.agfa.pacs.event.IEvent;
import com.agfa.pacs.logging.ALogger;
import com.agfa.pacs.memcache.CacheItem;
import com.agfa.pacs.memcache.DataCache;
import com.agfa.pacs.memcache.ICachedObjectGroup;
import com.agfa.pacs.memcache.ItemState;
import com.agfa.pacs.memcache.internal.GlobalLRU;
import java.io.IOException;

public abstract class AbstractCacheGroup
implements ICachedObjectGroup {
    protected static final ALogger log = ALogger.getLogger(AbstractCacheGroup.class);
    protected static final boolean DEBUG_LOG_ENABLED = log.isDebugEnabled();
    protected static final boolean TRACE_LOG_ENABLED = log.isTraceEnabled();
    private static int a = 0;
    private static boolean b = false;
    protected DataCache dataCache;

    public AbstractCacheGroup(DataCache dataCache) {
        this.dataCache = dataCache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected CacheItem addPersistentInternal(Object object, CacheID object2, int n) {
        CacheItem cacheItem;
        block11: {
            GlobalLRU globalLRU = this.dataCache.getGlobalLRU();
            cacheItem = globalLRU.get((CacheID)object2);
            if (cacheItem != null && cacheItem.getPersistenceGroup() != this) {
                cacheItem.getPersistenceGroup().removeGlobally(cacheItem);
            }
            globalLRU.lockForWrite();
            try {
                cacheItem = globalLRU.getUnsynced((CacheID)object2);
                if (cacheItem != null) {
                    object2 = cacheItem;
                    synchronized (object2) {
                        if (cacheItem.getUnsyncedState() != ItemState.DELETED) {
                            return null;
                        }
                        cacheItem.resurrect(object);
                        cacheItem.setStateUnsynced(ItemState.PERSISTENT);
                        cacheItem.setPriority(n);
                        break block11;
                    }
                }
                cacheItem = this.createItem(object, (CacheID)object2, n);
                globalLRU.putUnsynced((CacheID)object2, cacheItem);
            }
            finally {
                globalLRU.unlockForWrite();
            }
        }
        object2 = this.dataCache.getPersistenceQueue();
        object2.addAtBottom(cacheItem);
        return cacheItem;
    }

    @Override
    public CacheItem createItem(Object object, CacheID cacheID, int n) {
        return new CacheItem(object, cacheID, this, n);
    }

    @Override
    public Object getPersistent(CacheItem cacheItem, CacheID cacheID) {
        return this.getPersistentInternal(cacheItem, cacheID);
    }

    protected Object getPersistentInternal(CacheItem cacheItem, CacheID object) {
        object = cacheItem.getItemReferenceSynced();
        if (object != null) {
            this.dataCache.getGlobalLRU().touch(cacheItem);
            return object;
        }
        this.readPersistent(cacheItem);
        this.dataCache.getGlobalLRU().touch(cacheItem);
        object = cacheItem.getItemReferenceSynced();
        cacheItem.releaseReferenceSynced();
        if (object == null) {
            throw new NullPointerException();
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readPersistent(CacheItem cacheItem) {
        Object object = cacheItem;
        synchronized (object) {
            if (cacheItem.getUnsyncedState() == ItemState.DELETED) {
                throw new IllegalArgumentException("id not known to cache " + cacheItem.getID());
            }
            cacheItem.addReferenceUnsynced();
            if (cacheItem.getUnsyncedState() == ItemState.READING) {
                while (cacheItem.getUnsyncedState() == ItemState.READING) {
                    try {
                        cacheItem.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
                return;
            }
            if (cacheItem.dataAvailableUnsynced()) {
                return;
            }
            cacheItem.setStateUnsynced(ItemState.READING);
            cacheItem.notify();
        }
        try {
            object = this.allocateObject(false, cacheItem.getPriority());
            Object object2 = this;
            synchronized (object2) {
                if (TRACE_LOG_ENABLED) {
                    log.trace("Start reading from disk: " + cacheItem.getID());
                }
                object = this.readPersistent(cacheItem.getID(), object);
                this.notifyAll();
            }
            object2 = cacheItem;
            synchronized (object2) {
                cacheItem.setDataUnsynced(object);
                cacheItem.setStateUnsynced(ItemState.PERSONALIZED);
                cacheItem.notifyAll();
                return;
            }
        }
        catch (Exception exception) {
            object = cacheItem;
            synchronized (object) {
                cacheItem.setDataUnsynced(null);
                if (cacheItem.getUnsyncedState() != ItemState.DELETED) {
                    cacheItem.setStateUnsynced(ItemState.PERSONALIZED);
                }
                cacheItem.releaseReferenceSynced();
                cacheItem.notifyAll();
            }
            if (cacheItem.getUnsyncedState() == ItemState.DELETED) {
                throw new IllegalArgumentException();
            }
            log.error("Critical problem:", (Throwable)exception);
            throw new RuntimeException(exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writePersistent(CacheItem cacheItem) {
        Object object;
        Object object2 = cacheItem;
        synchronized (object2) {
            if (cacheItem.getUnsyncedState() == ItemState.PERSONALIZED) {
                return;
            }
            if (cacheItem.getUnsyncedState() == ItemState.DELETED) {
                return;
            }
            if (cacheItem.getUnsyncedState() == ItemState.PERSISTENT) {
                cacheItem.setStateUnsynced(ItemState.WRITING);
            } else if (cacheItem.getUnsyncedState().waitWhileWriting()) {
                while (cacheItem.getUnsyncedState().waitWhileWriting()) {
                    try {
                        cacheItem.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                    if (cacheItem.getUnsyncedState() != ItemState.DELETED) continue;
                    return;
                }
                return;
            }
            cacheItem.addReferenceUnsynced();
            object = cacheItem.getItemUnsynced();
            cacheItem.notify();
        }
        try {
            object2 = this;
            synchronized (object2) {
                if (TRACE_LOG_ENABLED) {
                    log.trace("Start writing to disk: " + cacheItem.getID());
                }
                this.writePersistent(object, cacheItem.getID());
                this.notify();
            }
            object2 = cacheItem;
            synchronized (object2) {
                if (cacheItem.getUnsyncedState() == ItemState.WRITING) {
                    cacheItem.setStateUnsynced(ItemState.PERSONALIZED);
                    this.dataCache.getOnDisk().put(cacheItem, this.getSizeEstimate(object));
                } else if (cacheItem.getUnsyncedState() == ItemState.MODIFIED) {
                    cacheItem.setStateUnsynced(ItemState.PERSISTENT);
                }
                cacheItem.releaseReferenceSynced();
                cacheItem.notify();
                return;
            }
        }
        catch (Exception exception) {
            object = cacheItem;
            synchronized (object) {
                cacheItem.setStateUnsynced(ItemState.PERSONALIZED);
                cacheItem.releaseReferenceSynced();
                cacheItem.notify();
            }
            log.error("error writing persistence", (Throwable)exception);
            if (!b && ++a > 10) {
                b = true;
                object = EventEngineFactory.getInstance();
                cacheItem = object.createEvent(object.getEventID("ERROR_NOTIFICATION"));
                cacheItem.setActionInfo(ActionInfo.SINGLE);
                cacheItem.setPayload(new CacheWriteProblem());
                cacheItem.setDestination(null, "lta.error");
                object.sendEvent((IEvent)cacheItem);
            }
            return;
        }
    }

    @Override
    public void removeGlobally(CacheItem cacheItem) {
        this.removeItem(cacheItem);
        this.dataCache.getGlobalLRU().remove(cacheItem);
    }

    @Override
    public void flush() {
    }

    @Override
    public String[] getItemMembers() {
        return null;
    }

    @Override
    public Object allocateObject(boolean bl, Object[] objectArray, int n) {
        return this.allocateObject(bl, n);
    }

    @Override
    public boolean isDestroyed() {
        return false;
    }

    public void dispose() {
    }

    @Override
    public String getGroupAttribute(String string) throws IOException {
        throw new UnsupportedOperationException("get group attributes is not supported in this cache group");
    }

    @Override
    public void setGroupAttribute(String string, String string2) throws IOException {
        throw new UnsupportedOperationException("set group attributes is not supported in this cache group");
    }

    @Override
    public void deleteGroupAttribute(String string) throws IOException {
        throw new UnsupportedOperationException("delete group attributes is not supported in this cache group");
    }
}

