/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.swingx.plaf.nimbus;

import com.agfa.pacs.listtext.swingx.plaf.nimbus.painters.AbstractCustomButtonPainter;
import com.agfa.pacs.listtext.swingx.plaf.nimbus.painters.AbstractCustomRegionPainter;
import com.agfa.pacs.listtext.swingx.plaf.nimbus.painters.AbstractCustomToggleButtonPainter;
import com.agfa.pacs.logging.ALogger;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.util.Hashtable;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.border.LineBorder;
import javax.swing.tree.DefaultTreeCellRenderer;
import sun.swing.DefaultLookup;

public class NimbusUtilities {
    private static Field fillBackground = null;
    private static Map<UIDefaultsCacheKey, UIDefaults> defaultsCache;

    static {
        try {
            fillBackground = DefaultTreeCellRenderer.class.getDeclaredField("fillBackground");
            fillBackground.setAccessible(true);
        }
        catch (Exception exception) {
            ALogger.getLogger(NimbusUtilities.class).error("Reflection problem", (Throwable)exception);
        }
        defaultsCache = new Hashtable<UIDefaultsCacheKey, UIDefaults>();
    }

    public static UIDefaults createDefaults() {
        return new UIDefaults(20, 0.75f);
    }

    public static void setNimbusProperty(JComponent jComponent, String string, Object object) {
        NimbusUtilities.setNimbusProperty(jComponent, string, object, true);
    }

    public static void setNimbusProperty(JComponent jComponent, String string, Object object, boolean bl) {
        UIDefaults uIDefaults = (UIDefaults)jComponent.getClientProperty("Nimbus.Overrides");
        UIDefaults uIDefaults2 = NimbusUtilities.createDefaults();
        if (uIDefaults != null) {
            uIDefaults2.putAll(uIDefaults);
        }
        uIDefaults2.put(string, object);
        jComponent.putClientProperty("Nimbus.Overrides.InheritDefaults", !bl);
        jComponent.putClientProperty("Nimbus.Overrides", uIDefaults2);
    }

    public static void setButtonPainter(JButton jButton, Insets insets, Class<? extends AbstractCustomButtonPainter> clazz) {
        NimbusUtilities.setButtonPainter(jButton, insets, clazz, true);
    }

    public static void setButtonPainter(JButton jButton, Insets insets, Class<? extends AbstractCustomButtonPainter> clazz, boolean bl) {
        NimbusUtilities.setButtonPainter(jButton, insets, null, clazz, bl);
    }

    public static void setButtonPainter(JButton jButton, Insets insets, Insets insets2, Class<? extends AbstractCustomButtonPainter> clazz, boolean bl) {
        UIDefaults uIDefaults = jButton.getClientProperty("Nimbus.Overrides") != null ? (UIDefaults)jButton.getClientProperty("Nimbus.Overrides") : NimbusUtilities.createDefaults();
        UIDefaultsCacheKey uIDefaultsCacheKey = new UIDefaultsCacheKey(clazz, insets);
        UIDefaults uIDefaults2 = defaultsCache.get(uIDefaultsCacheKey);
        if (uIDefaults2 != null) {
            uIDefaults.putAll(uIDefaults2);
        } else {
            uIDefaults.put("Button[Default].backgroundPainter", NimbusUtilities.createPainter(clazz, 1, AbstractCustomRegionPainter.CustomPaintContext.createNineSquareScaleInstance(insets, new Dimension(104, 33), false, Double.POSITIVE_INFINITY, 2.0)));
            uIDefaults.put("Button[Default+Focused].backgroundPainter", NimbusUtilities.createPainter(clazz, 2, AbstractCustomRegionPainter.CustomPaintContext.createNineSquareScaleInstance(insets, new Dimension(104, 33), false, Double.POSITIVE_INFINITY, 2.0)));
            uIDefaults.put("Button[Default+MouseOver].backgroundPainter", NimbusUtilities.createPainter(clazz, 3, AbstractCustomRegionPainter.CustomPaintContext.createNineSquareScaleInstance(insets, new Dimension(104, 33), false, Double.POSITIVE_INFINITY, 2.0)));
            uIDefaults.put("Button[Default+Focused+MouseOver].backgroundPainter", NimbusUtilities.createPainter(clazz, 4, AbstractCustomRegionPainter.CustomPaintContext.createNineSquareScaleInstance(insets, new Dimension(104, 33), false, Double.POSITIVE_INFINITY, 2.0)));
            uIDefaults.put("Button[Default+Pressed].backgroundPainter", NimbusUtilities.createPainter(clazz, 5, AbstractCustomRegionPainter.CustomPaintContext.createNineSquareScaleInstance(insets, new Dimension(104, 33), false, Double.POSITIVE_INFINITY, 2.0)));
            uIDefaults.put("Button[Default+Focused+Pressed].backgroundPainter", NimbusUtilities.createPainter(clazz, 6, AbstractCustomRegionPainter.CustomPaintContext.createNineSquareScaleInstance(insets, new Dimension(104, 33), false, Double.POSITIVE_INFINITY, 2.0)));
            uIDefaults.put("Button[Disabled].backgroundPainter", NimbusUtilities.createPainter(clazz, 7, AbstractCustomRegionPainter.CustomPaintContext.createNineSquareScaleInstance(insets, new Dimension(104, 33), false, Double.POSITIVE_INFINITY, 2.0)));
            uIDefaults.put("Button[Enabled].backgroundPainter", NimbusUtilities.createPainter(clazz, 8, AbstractCustomRegionPainter.CustomPaintContext.createNineSquareScaleInstance(insets, new Dimension(104, 33), false, Double.POSITIVE_INFINITY, 2.0)));
            uIDefaults.put("Button[Focused].backgroundPainter", NimbusUtilities.createPainter(clazz, 9, AbstractCustomRegionPainter.CustomPaintContext.createNineSquareScaleInstance(insets, new Dimension(104, 33), false, Double.POSITIVE_INFINITY, 2.0)));
            uIDefaults.put("Button[MouseOver].backgroundPainter", NimbusUtilities.createPainter(clazz, 10, AbstractCustomRegionPainter.CustomPaintContext.createNineSquareScaleInstance(insets, new Dimension(104, 33), false, Double.POSITIVE_INFINITY, 2.0)));
            uIDefaults.put("Button[Focused+MouseOver].backgroundPainter", NimbusUtilities.createPainter(clazz, 11, AbstractCustomRegionPainter.CustomPaintContext.createNineSquareScaleInstance(insets, new Dimension(104, 33), false, Double.POSITIVE_INFINITY, 2.0)));
            uIDefaults.put("Button[Pressed].backgroundPainter", NimbusUtilities.createPainter(clazz, 12, AbstractCustomRegionPainter.CustomPaintContext.createNineSquareScaleInstance(insets, new Dimension(104, 33), false, Double.POSITIVE_INFINITY, 2.0)));
            uIDefaults.put("Button[Focused+Pressed].backgroundPainter", NimbusUtilities.createPainter(clazz, 13, AbstractCustomRegionPainter.CustomPaintContext.createNineSquareScaleInstance(insets, new Dimension(104, 33), false, Double.POSITIVE_INFINITY, 2.0)));
            uIDefaults2 = NimbusUtilities.createDefaults();
            uIDefaults2.putAll(uIDefaults);
            defaultsCache.put(uIDefaultsCacheKey, uIDefaults2);
        }
        if (insets2 != null) {
            uIDefaults.put("Button.contentMargins", insets2);
        }
        jButton.putClientProperty("Nimbus.Overrides.InheritDefaults", !bl);
        jButton.putClientProperty("Nimbus.Overrides", uIDefaults);
    }

    public static void setToggleButtonPainter(JToggleButton jToggleButton, Insets insets, Class<? extends AbstractCustomToggleButtonPainter> clazz) {
        NimbusUtilities.setToggleButtonPainter(jToggleButton, insets, clazz, true);
    }

    public static void setToggleButtonPainter(JToggleButton jToggleButton, Insets insets, Class<? extends AbstractCustomToggleButtonPainter> clazz, boolean bl) {
        NimbusUtilities.setToggleButtonPainter(jToggleButton, insets, null, clazz, bl);
    }

    public static void setToggleButtonPainter(JToggleButton jToggleButton, Insets insets, Insets insets2, Class<? extends AbstractCustomToggleButtonPainter> clazz, boolean bl) {
        UIDefaults uIDefaults = jToggleButton.getClientProperty("Nimbus.Overrides") != null ? (UIDefaults)jToggleButton.getClientProperty("Nimbus.Overrides") : NimbusUtilities.createDefaults();
        UIDefaultsCacheKey uIDefaultsCacheKey = new UIDefaultsCacheKey(clazz, insets);
        UIDefaults uIDefaults2 = defaultsCache.get(uIDefaultsCacheKey);
        if (uIDefaults2 != null) {
            uIDefaults.putAll(uIDefaults2);
        } else {
            uIDefaults.put("ToggleButton[Enabled].backgroundPainter", NimbusUtilities.createPainter(clazz, 2, AbstractCustomRegionPainter.CustomPaintContext.createNineSquareScaleInstance(insets, new Dimension(104, 33), false, Double.POSITIVE_INFINITY, 2.0)));
            uIDefaults.put("ToggleButton[Disabled].backgroundPainter", NimbusUtilities.createPainter(clazz, 1, AbstractCustomRegionPainter.CustomPaintContext.createNineSquareScaleInstance(insets, new Dimension(104, 33), false, Double.POSITIVE_INFINITY, 2.0)));
            uIDefaults.put("ToggleButton[Pressed].backgroundPainter", NimbusUtilities.createPainter(clazz, 6, AbstractCustomRegionPainter.CustomPaintContext.createNineSquareScaleInstance(insets, new Dimension(104, 33), false, Double.POSITIVE_INFINITY, 2.0)));
            uIDefaults.put("ToggleButton[Selected].backgroundPainter", NimbusUtilities.createPainter(clazz, 8, AbstractCustomRegionPainter.CustomPaintContext.createNineSquareScaleInstance(insets, new Dimension(72, 24), false, Double.POSITIVE_INFINITY, 2.0)));
            uIDefaults.put("ToggleButton[MouseOver].backgroundPainter", NimbusUtilities.createPainter(clazz, 4, AbstractCustomRegionPainter.CustomPaintContext.createNineSquareScaleInstance(insets, new Dimension(104, 33), false, Double.POSITIVE_INFINITY, 2.0)));
            uIDefaults.put("ToggleButton[Focused].backgroundPainter", NimbusUtilities.createPainter(clazz, 3, AbstractCustomRegionPainter.CustomPaintContext.createNineSquareScaleInstance(insets, new Dimension(104, 33), false, Double.POSITIVE_INFINITY, 2.0)));
            uIDefaults.put("ToggleButton[Focused+MouseOver].backgroundPainter", NimbusUtilities.createPainter(clazz, 5, AbstractCustomRegionPainter.CustomPaintContext.createNineSquareScaleInstance(insets, new Dimension(104, 33), false, Double.POSITIVE_INFINITY, 2.0)));
            uIDefaults.put("ToggleButton[Focused+Pressed].backgroundPainter", NimbusUtilities.createPainter(clazz, 7, AbstractCustomRegionPainter.CustomPaintContext.createNineSquareScaleInstance(insets, new Dimension(104, 33), false, Double.POSITIVE_INFINITY, 2.0)));
            uIDefaults.put("ToggleButton[Focused+Selected].backgroundPainter", NimbusUtilities.createPainter(clazz, 9, AbstractCustomRegionPainter.CustomPaintContext.createNineSquareScaleInstance(insets, new Dimension(72, 24), false, Double.POSITIVE_INFINITY, 2.0)));
            uIDefaults.put("ToggleButton[Disabled+Selected].backgroundPainter", NimbusUtilities.createPainter(clazz, 14, AbstractCustomRegionPainter.CustomPaintContext.createNineSquareScaleInstance(insets, new Dimension(72, 24), false, Double.POSITIVE_INFINITY, 2.0)));
            uIDefaults.put("ToggleButton[MouseOver+Selected].backgroundPainter", NimbusUtilities.createPainter(clazz, 12, AbstractCustomRegionPainter.CustomPaintContext.createNineSquareScaleInstance(insets, new Dimension(72, 24), false, Double.POSITIVE_INFINITY, 2.0)));
            uIDefaults.put("ToggleButton[Pressed+Selected].backgroundPainter", NimbusUtilities.createPainter(clazz, 10, AbstractCustomRegionPainter.CustomPaintContext.createNineSquareScaleInstance(insets, new Dimension(72, 24), false, Double.POSITIVE_INFINITY, 2.0)));
            uIDefaults.put("ToggleButton[Focused+MouseOver+Selected].backgroundPainter", NimbusUtilities.createPainter(clazz, 13, AbstractCustomRegionPainter.CustomPaintContext.createNineSquareScaleInstance(insets, new Dimension(72, 24), false, Double.POSITIVE_INFINITY, 2.0)));
            uIDefaults.put("ToggleButton[Focused+Pressed+Selected].backgroundPainter", NimbusUtilities.createPainter(clazz, 11, AbstractCustomRegionPainter.CustomPaintContext.createNineSquareScaleInstance(insets, new Dimension(72, 24), false, Double.POSITIVE_INFINITY, 2.0)));
            uIDefaults2 = NimbusUtilities.createDefaults();
            uIDefaults2.putAll(uIDefaults);
            defaultsCache.put(uIDefaultsCacheKey, uIDefaults2);
        }
        if (insets2 != null) {
            uIDefaults.put("ToggleButton.contentMargins", insets2);
        }
        jToggleButton.putClientProperty("Nimbus.Overrides.InheritDefaults", false);
        jToggleButton.putClientProperty("Nimbus.Overrides", uIDefaults);
    }

    public static void setTableHeaderPainter(JPanel jPanel) {
        UIDefaults uIDefaults = jPanel.getClientProperty("Nimbus.Overrides") != null ? (UIDefaults)jPanel.getClientProperty("Nimbus.Overrides") : NimbusUtilities.createDefaults();
        uIDefaults.put("Panel[Enabled].backgroundPainter", UIManager.getDefaults().get("TableHeader:\"TableHeader.renderer\"[Enabled].backgroundPainter"));
        jPanel.putClientProperty("Nimbus.Overrides.InheritDefaults", false);
        jPanel.putClientProperty("Nimbus.Overrides", uIDefaults);
    }

    public static final AbstractCustomRegionPainter createPainter(Class<? extends AbstractCustomRegionPainter> clazz, int n, AbstractCustomRegionPainter.CustomPaintContext customPaintContext) {
        try {
            Constructor<? extends AbstractCustomRegionPainter> constructor = clazz.getDeclaredConstructor(Integer.TYPE, AbstractCustomRegionPainter.CustomPaintContext.class);
            if (constructor == null) {
                throw new NullPointerException("Failed to find the constructor for the nimbus painter class: " + clazz);
            }
            return constructor.newInstance(n, customPaintContext);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static final AbstractCustomRegionPainter.CustomLazyPainter createLazyPainter(Class<? extends AbstractCustomRegionPainter> clazz, int n, AbstractCustomRegionPainter.CustomPaintContext customPaintContext) {
        return new AbstractCustomRegionPainter.CustomLazyPainter(clazz, n, customPaintContext);
    }

    public static void fixJTreeCellRendererBackgroundJava7(DefaultTreeCellRenderer defaultTreeCellRenderer) {
        try {
            fillBackground.set(defaultTreeCellRenderer, DefaultLookup.getBoolean(defaultTreeCellRenderer, defaultTreeCellRenderer.getUI(), "Tree.rendererFillBackground", fillBackground.getBoolean(defaultTreeCellRenderer)));
        }
        catch (Exception exception) {
            ALogger.getLogger(NimbusUtilities.class).error(null, (Throwable)exception);
        }
    }

    public static final class CustomDefaultTableCellEditor
    extends DefaultCellEditor {
        Class<?>[] argTypes = new Class[]{String.class};
        Constructor<?> constructor;
        Object value;

        public CustomDefaultTableCellEditor() {
            this(new JTextField());
        }

        public CustomDefaultTableCellEditor(JTextField jTextField) {
            super(jTextField);
            this.getComponent().setName("Table.editor");
        }

        @Override
        public boolean stopCellEditing() {
            String string = (String)super.getCellEditorValue();
            if ("".equals(string)) {
                if (this.constructor.getDeclaringClass() == String.class) {
                    this.value = string;
                }
                super.stopCellEditing();
            }
            try {
                this.value = this.constructor.newInstance(string);
            }
            catch (Exception exception) {
                ((JComponent)this.getComponent()).setBorder(new LineBorder(Color.red));
                return false;
            }
            return super.stopCellEditing();
        }

        @Override
        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            this.value = null;
            ((JComponent)this.getComponent()).setBorder(BorderFactory.createCompoundBorder(new LineBorder(UIManager.getColor("nimbusFocus")), new LineBorder(UIManager.getColor("color.primary.2"))));
            try {
                Class<Object> clazz = jTable.getColumnClass(n2);
                if (clazz == Object.class) {
                    clazz = String.class;
                }
                this.constructor = clazz.getConstructor(this.argTypes);
            }
            catch (Exception exception) {
                return null;
            }
            return super.getTableCellEditorComponent(jTable, object, bl, n, n2);
        }

        @Override
        public Object getCellEditorValue() {
            return this.value;
        }
    }

    private static final class UIDefaultsCacheKey {
        private Class<?> clazz;
        private Insets insets;

        public UIDefaultsCacheKey(Class<?> clazz, Insets insets) {
            this.clazz = clazz;
            this.insets = insets;
        }

        public boolean equals(Object object) {
            if (object instanceof UIDefaultsCacheKey) {
                Class<?> clazz = ((UIDefaultsCacheKey)object).clazz;
                Insets insets = ((UIDefaultsCacheKey)object).insets;
                return this.clazz.equals(clazz) && this.insets.equals(insets);
            }
            return super.equals(object);
        }

        public int hashCode() {
            String string = Integer.toString(this.clazz.hashCode());
            String string2 = Integer.toString(this.insets.hashCode());
            return (String.valueOf(string) + string2).hashCode();
        }
    }
}

