/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.swingx.plaf.agfa;

import com.agfa.pacs.base.swing.util.GUI;
import com.agfa.pacs.listtext.swingx.plaf.LookAndFeelManager;
import com.agfa.pacs.listtext.swingx.util.graphics.ColorUtils;
import com.agfa.pacs.listtext.swingx.util.graphics.IconLoader;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.io.Serializable;
import javax.swing.Icon;
import javax.swing.UIManager;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.metal.MetalIconFactory;

public class AgfaIconFactory
extends MetalIconFactory {
    private static final long serialVersionUID = 3112995517141043729L;
    public static final int BASIC_SIZE = 12;
    private static String iconPath = "/com/agfa/pacs/listtext/swingx/plaf/basic/icons/";

    public static void initIcons(int n) {
        UIManager.put("Tree.expandedIcon", new TreeExpandedIcon(n));
        UIManager.put("Tree.collapsedIcon", new TreeCollapsedIcon(n));
        UIManager.put("window.expanded", new WindowExpandedIcon(n));
        UIManager.put("window.collapsed", new WindowCollapsedIcon(n));
        UIManager.put("cancel.lta", AgfaIconFactory.getCancelIcon(n));
        UIManager.put("Common.triangleupIcon", new TriangleUpIcon(n));
        UIManager.put("Common.triangledownIcon", new TriangleDownIcon(n));
        UIManager.put("Common.triangleleftIcon", new TriangleLeftIcon(n));
        UIManager.put("Common.trianglerightIcon", new TriangleRightIcon(n));
        UIManager.put("triangle.up.filled", new FilledTriangleUpIcon(n));
        UIManager.put("triangle.down.filled", new FilledTriangleDownIcon(n));
        UIManager.put("triangle.up.halffilled", new HalfFilledTriangleUpIcon(n));
        UIManager.put("triangle.down.halffilled", new HalfFilledTriangleDownIcon(n));
        UIManager.put("triangle.left.filled", new FilledTriangleLeftIcon(n));
        UIManager.put("triangle.right.filled", new FilledTriangleRightIcon(n));
        UIManager.put("circle.filled", new FilledCircleIcon(n - 4));
        UIManager.put("stop.enabled", new RedSquareIcon(n));
        UIManager.put("stop.disabled", new GraySquareIcon(n));
        UIManager.put("calendar", IconLoader.loadScaledIcon(String.valueOf(iconPath) + "calendar.gif", n, n));
        UIManager.put("image.loading", IconLoader.loadScaledIcon(String.valueOf(iconPath) + "loading.gif", n * 10, n * 10));
        UIManager.put("sync", IconLoader.loadScaledIcon(String.valueOf(iconPath) + "in_sync.png", GUI.getScaledInt((int)22), GUI.getScaledInt((int)22)));
        UIManager.put("desync", IconLoader.loadScaledIcon(String.valueOf(iconPath) + "de_sync.png", GUI.getScaledInt((int)22), GUI.getScaledInt((int)22)));
        UIManager.put("synctext", IconLoader.loadScaledIcon(String.valueOf(iconPath) + "sync_text.png", GUI.getScaledInt((int)22), GUI.getScaledInt((int)22)));
        UIManager.put("syncimg", IconLoader.loadScaledIcon(String.valueOf(iconPath) + "sync_img.png", GUI.getScaledInt((int)22), GUI.getScaledInt((int)22)));
    }

    public static Icon getCancelIcon(int n) {
        return IconLoader.loadScaledIcon(String.valueOf(iconPath) + "cancel_mono.gif", n, n);
    }

    private static abstract class AbstractIcon
    implements Icon,
    UIResource {
        protected int size;

        public AbstractIcon(int n) {
            this.size = n;
        }

        @Override
        public int getIconWidth() {
            return this.size;
        }

        @Override
        public int getIconHeight() {
            return this.size;
        }

        protected Color getWhite() {
            return LookAndFeelManager.getInstance().getTheme().getWhite();
        }

        protected Color getBlack() {
            return LookAndFeelManager.getInstance().getTheme().getBlack();
        }

        protected Color getControl() {
            return LookAndFeelManager.getInstance().getTheme().getControl();
        }
    }

    private static class FilledCircleIcon
    extends AbstractIcon
    implements Serializable {
        public FilledCircleIcon(int n) {
            super(n);
        }

        @Override
        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            Color color = graphics.getColor();
            Color color2 = component.getBackground();
            Color color3 = ColorUtils.isBright(color2) ? this.getBlack() : this.getWhite();
            graphics.setColor(color3);
            graphics.fillOval(n, n2, this.size, this.size);
            graphics.setColor(color);
        }
    }

    public static class FilledTriangleDownIcon
    extends AbstractIcon
    implements Serializable {
        private static final long serialVersionUID = -7127966424010693635L;

        public FilledTriangleDownIcon(int n) {
            super(n);
        }

        @Override
        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            Color color = component.getBackground();
            if (color == null) {
                color = this.getControl();
            }
            graphics.setColor(color);
            Color color2 = ColorUtils.isBright(color, 0.6f) ? this.getBlack() : this.getWhite();
            graphics.setColor(color2);
            int n3 = this.size / 2;
            int n4 = this.size / 2;
            int n5 = this.size / 3;
            graphics.fillPolygon(new int[]{n + n3 - n5, n + n3, n + n3 + n5}, new int[]{n2 + n4 - n5, n2 + n4 + n5, n2 + n4 - n5}, 3);
        }
    }

    private static class FilledTriangleLeftIcon
    extends AbstractIcon
    implements Serializable {
        private static final long serialVersionUID = -7127966424010693635L;

        public FilledTriangleLeftIcon(int n) {
            super(n);
        }

        @Override
        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            Color color = component.getBackground();
            if (color == null) {
                color = UIManager.getColor("control");
            }
            graphics.setColor(color);
            Color color2 = ColorUtils.isBright(color, 0.6f) ? Color.black : Color.white;
            graphics.setColor(color2);
            int n3 = this.size / 2;
            int n4 = this.size / 2;
            int n5 = this.size / 3;
            graphics.fillPolygon(new int[]{n + n3 - n5, n + n3 + n5, n + n3 + n5}, new int[]{n2 + n4, n2 + n4 - n5, n2 + n4 + n5}, 3);
        }
    }

    private static class FilledTriangleRightIcon
    extends AbstractIcon
    implements Serializable {
        private static final long serialVersionUID = 753756614529307648L;

        public FilledTriangleRightIcon(int n) {
            super(n);
        }

        @Override
        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            Color color = component.getBackground();
            if (color == null) {
                color = UIManager.getColor("control");
            }
            graphics.setColor(color);
            Color color2 = ColorUtils.isBright(color, 0.6f) ? Color.black : Color.white;
            graphics.setColor(color2);
            int n3 = this.size / 2;
            int n4 = this.size / 2;
            int n5 = this.size / 3;
            graphics.fillPolygon(new int[]{n + n3 - n5, n + n3 - n5, n + n3 + n5}, new int[]{n2 + n4 - n5, n2 + n4 + n5, n2 + n4}, 3);
        }
    }

    public static class FilledTriangleUpIcon
    extends AbstractIcon
    implements Serializable {
        private static final long serialVersionUID = 753756614529307648L;

        public FilledTriangleUpIcon(int n) {
            super(n);
        }

        @Override
        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            Color color = component.getBackground();
            if (color == null) {
                color = this.getControl();
            }
            graphics.setColor(color);
            Color color2 = ColorUtils.isBright(color, 0.6f) ? this.getBlack() : this.getWhite();
            graphics.setColor(color2);
            int n3 = this.size / 2;
            int n4 = this.size / 2;
            int n5 = this.size / 3;
            graphics.fillPolygon(new int[]{n + n3 - n5, n + n3, n + n3 + n5}, new int[]{n2 + n4 + n5, n2 + n4 - n5, n2 + n4 + n5}, 3);
        }
    }

    private static class GraySquareIcon
    extends SquareIcon {
        private static final long serialVersionUID = -2116494306790483443L;

        public GraySquareIcon(int n) {
            super(Color.GRAY, n);
        }
    }

    private static class HalfFilledTriangleDownIcon
    extends AbstractIcon
    implements Serializable {
        private static final long serialVersionUID = -7127966424010693635L;

        public HalfFilledTriangleDownIcon(int n) {
            super(n);
        }

        @Override
        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            Color color = component.getBackground();
            if (color == null) {
                color = this.getControl();
            }
            graphics.setColor(color);
            Color color2 = ColorUtils.isBright(color) ? this.getBlack() : this.getWhite();
            graphics.setColor(color2);
            int n3 = this.size / 2;
            int n4 = this.size / 2;
            int n5 = this.size / 3;
            graphics.drawPolygon(new int[]{n + n3 - n5, n + n3, n + n3 + n5}, new int[]{n2 + n4 - n5, n2 + n4 + n5, n2 + n4 - n5}, 3);
            graphics.drawPolygon(new int[]{n + n3 - n5 + 1, n + n3, n + n3 + n5 - 1}, new int[]{n2 + n4 - n5 + 1, n2 + n4 + n5 - 1, n2 + n4 - n5 + 1}, 3);
        }
    }

    private static class HalfFilledTriangleUpIcon
    extends AbstractIcon
    implements Serializable {
        private static final long serialVersionUID = 753756614529307648L;

        public HalfFilledTriangleUpIcon(int n) {
            super(n);
        }

        @Override
        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            Color color = component.getBackground();
            if (color == null) {
                color = this.getControl();
            }
            graphics.setColor(color);
            Color color2 = ColorUtils.isBright(color) ? this.getBlack() : this.getWhite();
            graphics.setColor(color2);
            int n3 = this.size / 2;
            int n4 = this.size / 2;
            int n5 = this.size / 3;
            graphics.drawPolygon(new int[]{n + n3 - n5, n + n3, n + n3 + n5}, new int[]{n2 + n4 + n5, n2 + n4 - n5, n2 + n4 + n5}, 3);
            graphics.drawPolygon(new int[]{n + n3 - n5 + 1, n + n3, n + n3 + n5 - 1}, new int[]{n2 + n4 + n5 - 1, n2 + n4 - n5 + 1, n2 + n4 + n5 - 1}, 3);
        }
    }

    private static class RedSquareIcon
    extends SquareIcon {
        private static final long serialVersionUID = 753756614529307648L;

        public RedSquareIcon(int n) {
            super(Color.RED, n);
        }
    }

    private static class SquareIcon
    extends AbstractIcon
    implements Serializable {
        private static final long serialVersionUID = 753756614529307648L;
        private Color fillColor;

        public SquareIcon(Color color, int n) {
            super(n);
            this.fillColor = color;
        }

        @Override
        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            Color color = graphics.getColor();
            graphics.setColor(this.fillColor);
            graphics.fill3DRect(n, n2, this.size, this.size, true);
            graphics.setColor(color);
        }
    }

    public static class TreeCollapsedIcon
    extends TreeExpandedIcon {
        private static final long serialVersionUID = -6854004515363229664L;

        public TreeCollapsedIcon(int n) {
            super(n);
        }

        @Override
        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            super.paintIcon(component, graphics, n, n2);
            graphics.drawLine(n + this.size / 2, n2 + 2, n + this.size / 2, n2 + (this.size - 3));
        }
    }

    public static class TreeExpandedIcon
    extends AbstractIcon
    implements Serializable {
        private static final long serialVersionUID = 923162837940975205L;

        public TreeExpandedIcon(int n) {
            super(n - 2);
        }

        @Override
        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            Color color = component.getBackground();
            if (color == null) {
                color = this.getControl();
            }
            graphics.setColor(color);
            graphics.fillRect(n, n2, this.size - 1, this.size - 1);
            Color color2 = ColorUtils.isBright(color) ? this.getBlack().brighter() : this.getWhite().darker();
            graphics.setColor(color2);
            graphics.drawRect(n, n2, this.size - 1, this.size - 1);
            graphics.setColor(color2);
            graphics.drawLine(n + 2, n2 + this.size / 2, n + (this.size - 3), n2 + this.size / 2);
        }
    }

    private static class TriangleDownIcon
    extends AbstractIcon
    implements Serializable {
        private static final long serialVersionUID = -7127966424010693635L;

        public TriangleDownIcon(int n) {
            super(n);
        }

        @Override
        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            Color color = component.getBackground();
            if (color == null) {
                color = this.getControl();
            }
            graphics.setColor(color);
            Color color2 = ColorUtils.isBright(color) ? this.getBlack() : this.getWhite();
            graphics.setColor(color2);
            int n3 = this.size / 2;
            int n4 = this.size / 2;
            int n5 = this.size / 3;
            graphics.drawPolygon(new int[]{n + n3 - n5, n + n3, n + n3 + n5}, new int[]{n2 + n4 - n5, n2 + n4 + n5, n2 + n4 - n5}, 3);
        }
    }

    private static class TriangleLeftIcon
    extends AbstractIcon
    implements Serializable {
        private static final long serialVersionUID = -7127966424010693635L;

        public TriangleLeftIcon(int n) {
            super(n);
        }

        @Override
        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            Color color = component.getBackground();
            if (color == null) {
                color = UIManager.getColor("control");
            }
            graphics.setColor(color);
            Color color2 = ColorUtils.isBright(color) ? Color.black : Color.white;
            graphics.setColor(color2);
            int n3 = this.size / 2;
            int n4 = this.size / 2;
            int n5 = this.size / 3;
            graphics.drawPolygon(new int[]{n + n3 - n5, n + n3 + n5, n + n3 + n5}, new int[]{n2 + n4, n2 + n4 - n5, n2 + n4 + n5}, 3);
        }
    }

    private static class TriangleRightIcon
    extends AbstractIcon
    implements Serializable {
        private static final long serialVersionUID = 753756614529307648L;

        public TriangleRightIcon(int n) {
            super(n);
        }

        @Override
        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            Color color = component.getBackground();
            if (color == null) {
                color = UIManager.getColor("control");
            }
            graphics.setColor(color);
            Color color2 = ColorUtils.isBright(color) ? Color.black : Color.white;
            graphics.setColor(color2);
            int n3 = this.size / 2;
            int n4 = this.size / 2;
            int n5 = this.size / 3;
            graphics.drawPolygon(new int[]{n + n3 - n5, n + n3 - n5, n + n3 + n5}, new int[]{n2 + n4 - n5, n2 + n4 + n5, n2 + n4}, 3);
        }
    }

    private static class TriangleUpIcon
    extends AbstractIcon
    implements Serializable {
        private static final long serialVersionUID = 753756614529307648L;

        public TriangleUpIcon(int n) {
            super(n);
        }

        @Override
        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            Color color = component.getBackground();
            if (color == null) {
                color = this.getControl();
            }
            graphics.setColor(color);
            Color color2 = ColorUtils.isBright(color) ? this.getBlack() : this.getWhite();
            graphics.setColor(color2);
            int n3 = this.size / 2;
            int n4 = this.size / 2;
            int n5 = this.size / 3;
            graphics.drawPolygon(new int[]{n + n3 - n5, n + n3, n + n3 + n5}, new int[]{n2 + n4 + n5, n2 + n4 - n5, n2 + n4 + n5}, 3);
        }
    }

    public static class WindowCollapsedIcon
    extends AbstractIcon
    implements Serializable {
        private static final long serialVersionUID = 1L;

        public WindowCollapsedIcon(int n) {
            super(n);
        }

        @Override
        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            Color color = component.getBackground();
            Color color2 = ColorUtils.isBright(color, 0.85) ? this.getBlack() : this.getWhite();
            graphics.setColor(color2);
            graphics.fillRect(n + 1, n2 + this.size / 2 - 2, this.size - 2, 3);
        }
    }

    public static class WindowExpandedIcon
    extends AbstractIcon
    implements Serializable {
        private static final long serialVersionUID = 1L;

        public WindowExpandedIcon(int n) {
            super(n);
        }

        @Override
        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            Color color = component.getBackground();
            if (color == null) {
                color = this.getControl();
            }
            graphics.setColor(color);
            Color color2 = ColorUtils.isBright(color, 0.85) ? this.getBlack() : this.getWhite();
            graphics.setColor(color2);
            graphics.drawRect(n + 1, n2 + 1, this.size - 2, this.size - 2);
            graphics.fillRect(n + 1, n2 + 2, this.size - 2, 2);
        }
    }
}

