/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.swingx.impl;

import com.agfa.pacs.base.swing.IComponentFactory;
import com.agfa.pacs.base.util.DateTimeUtils;
import com.agfa.pacs.data.shared.store.StoreProviderFactory;
import com.agfa.pacs.data.shared.worklist.IWorklistContext;
import com.agfa.pacs.listtext.swingx.controls.Messages;
import com.agfa.pacs.logging.ALogger;
import java.awt.BorderLayout;
import java.awt.Component;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionListener;
import javax.swing.plaf.basic.BasicComboBoxRenderer;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;

public class WorklistChooserPanel
extends JPanel {
    private static final ALogger log = ALogger.getLogger(WorklistChooserPanel.class);
    private static final int POSSIBLE_SCHEDULEDATE_WEEKS_FORWARD = 4;
    private final JTable table;
    private final List<IWorklistContext> worklistContexts;
    private Map<IWorklistContext, ScheduledDateList> possibleScheduleDates;

    public WorklistChooserPanel(IComponentFactory iComponentFactory, List<IWorklistContext> list) {
        super(new BorderLayout());
        this.worklistContexts = this.filterWorklistContexts(list);
        this.table = this.createTable(iComponentFactory);
        this.table.setDefaultRenderer(List.class, new ListCellRenderer(iComponentFactory));
        this.table.setDefaultEditor(List.class, new ListCellEditor(iComponentFactory));
        TableRowSorter<?> tableRowSorter = this.createRowSorter(this.table);
        if (tableRowSorter != null) {
            this.table.setRowSorter(tableRowSorter);
            this.table.getRowSorter().allRowsChanged();
        }
        this.add((Component)iComponentFactory.createScrollPane((Component)this.table, Integer.valueOf(20), Integer.valueOf(30), Boolean.valueOf(true), Boolean.valueOf(true)), "Center");
    }

    public WorklistChooserPanel(IComponentFactory iComponentFactory) {
        this(iComponentFactory, WorklistChooserPanel.getAvailableWorklists());
    }

    public Map<IWorklistContext, Date> getSelectedWorklistContexts() {
        int[] nArray = this.table.getSelectedRows();
        if (nArray != null) {
            HashMap<IWorklistContext, Date> hashMap = new HashMap<IWorklistContext, Date>();
            int[] nArray2 = nArray;
            int n = nArray.length;
            int n2 = 0;
            while (n2 < n) {
                int n3 = nArray2[n2];
                if (n3 >= 0) {
                    Date date = null;
                    Object object = this.table.getValueAt(n3, 1);
                    if (object instanceof ScheduledDateList && (date = ((ScheduledDateList)object).getSelectedDate()) == null && !((ScheduledDateList)object).isEmpty()) {
                        date = (Date)((ScheduledDateList)object).get(0);
                    }
                    hashMap.put(this.worklistContexts.get(this.table.convertRowIndexToModel(n3)), date);
                }
                ++n2;
            }
            return hashMap;
        }
        return null;
    }

    public void setSelectedWorklistContexts(Collection<IWorklistContext> collection) {
        try {
            this.table.clearSelection();
            if (collection != null) {
                for (IWorklistContext iWorklistContext : collection) {
                    int n = this.worklistContexts.indexOf(iWorklistContext);
                    if (n < 0) continue;
                    int n2 = this.table.convertRowIndexToView(n);
                    this.table.getSelectionModel().addSelectionInterval(n2, n2);
                    if (!iWorklistContext.isScheduled()) continue;
                    this.ensureScheduleDates();
                    this.possibleScheduleDates.get(iWorklistContext).setSelectedDate(iWorklistContext.getScheduledDate());
                }
            }
        }
        catch (Exception exception) {
            log.error(null, (Throwable)exception);
        }
    }

    public void setSelectedWorklistContexts(Map<IWorklistContext, Date> map) {
        try {
            this.table.clearSelection();
            if (map != null) {
                for (Map.Entry<IWorklistContext, Date> entry : map.entrySet()) {
                    IWorklistContext iWorklistContext = entry.getKey();
                    int n = this.worklistContexts.indexOf(entry.getKey());
                    if (n < 0) continue;
                    int n2 = this.table.convertRowIndexToView(n);
                    this.table.getSelectionModel().addSelectionInterval(n2, n2);
                    if (!iWorklistContext.isScheduled()) continue;
                    this.ensureScheduleDates();
                    this.possibleScheduleDates.get(iWorklistContext).setSelectedDate(entry.getValue());
                }
            }
        }
        catch (Exception exception) {
            log.error(null, (Throwable)exception);
        }
    }

    @Override
    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        if (this.table != null) {
            if (!bl) {
                this.table.getSelectionModel().clearSelection();
            }
            this.table.setEnabled(bl);
        }
    }

    public void addWorklistSelectionListener(ListSelectionListener listSelectionListener) {
        this.table.getSelectionModel().addListSelectionListener(listSelectionListener);
    }

    public void removeWorklistSelectionListener(ListSelectionListener listSelectionListener) {
        this.table.getSelectionModel().removeListSelectionListener(listSelectionListener);
    }

    private static String dateToString(Date date) {
        return DateFormat.getDateTimeInstance(2, 3).format(date);
    }

    public static List<IWorklistContext> getAvailableWorklists() {
        Collection collection = StoreProviderFactory.getInstance().getStoreProvider().getAvailableWorklistContexts();
        ArrayList<IWorklistContext> arrayList = new ArrayList<IWorklistContext>();
        for (IWorklistContext iWorklistContext : collection) {
            if (!"USER".equals(iWorklistContext.getType()) && !"SCHEDULED".equals(iWorklistContext.getType())) continue;
            arrayList.add(iWorklistContext);
        }
        return arrayList;
    }

    protected JTable createTable(IComponentFactory iComponentFactory) {
        JTable jTable = iComponentFactory.createTable((TableModel)new AbstractTableModel(){
            private static final int TITLE_COLUMN = 0;
            private static final int SCHEDULEDATE_COLUMN = 1;

            @Override
            public int getColumnCount() {
                return 2;
            }

            @Override
            public int getRowCount() {
                return WorklistChooserPanel.this.worklistContexts.size();
            }

            @Override
            public String getColumnName(int n) {
                if (!$assertionsDisabled && n != 0 && n != 1) {
                    throw new AssertionError((Object)"Please implement column name!");
                }
                return n == 0 ? Messages.getString("WorklistChooserPanel.Worklist") : (n == 1 ? Messages.getString("WorklistChooserPanel.ScheduledOn") : null);
            }

            @Override
            public Class<?> getColumnClass(int n) {
                return n == 0 ? String.class : (n == 1 ? List.class : super.getColumnClass(n));
            }

            @Override
            public boolean isCellEditable(int n, int n2) {
                return ((IWorklistContext)WorklistChooserPanel.this.worklistContexts.get(n)).isScheduled() ? n2 == 1 : false;
            }

            @Override
            public Object getValueAt(int n, int n2) {
                IWorklistContext iWorklistContext;
                WorklistChooserPanel.this.ensureScheduleDates();
                if (n >= 0 && (iWorklistContext = (IWorklistContext)WorklistChooserPanel.this.worklistContexts.get(n)) != null) {
                    if (n2 == 0) {
                        return iWorklistContext.getTitle();
                    }
                    return WorklistChooserPanel.this.possibleScheduleDates.get(iWorklistContext);
                }
                return null;
            }

            @Override
            public void setValueAt(Object object, int n, int n2) {
                ScheduledDateList scheduledDateList;
                if (!$assertionsDisabled && n2 != 1) {
                    throw new AssertionError((Object)("Please implement setValue for column " + n2));
                }
                WorklistChooserPanel.this.ensureScheduleDates();
                IWorklistContext iWorklistContext = (IWorklistContext)WorklistChooserPanel.this.worklistContexts.get(n);
                if (iWorklistContext != null && (scheduledDateList = (ScheduledDateList)WorklistChooserPanel.this.possibleScheduleDates.get(iWorklistContext)) != null && !scheduledDateList.isEmpty()) {
                    scheduledDateList.setSelectedDate((Date)object);
                }
            }
        });
        jTable.getSelectionModel().setSelectionMode(2);
        jTable.setRowHeight(iComponentFactory.scaleInt(24));
        return jTable;
    }

    private void ensureScheduleDates() {
        if (this.possibleScheduleDates == null) {
            this.possibleScheduleDates = new HashMap<IWorklistContext, ScheduledDateList>(this.table.getRowCount());
            int n = 0;
            while (n < this.table.getRowCount()) {
                IWorklistContext iWorklistContext = this.worklistContexts.get(n);
                if (iWorklistContext != null) {
                    ScheduledDateList scheduledDateList = this.buildPossibleScheduleDateList(this.worklistContexts.get(n));
                    this.possibleScheduleDates.put(iWorklistContext, scheduledDateList);
                }
                ++n;
            }
        }
    }

    protected TableRowSorter<?> createRowSorter(JTable jTable) {
        TableRowSorter<TableModel> tableRowSorter = new TableRowSorter<TableModel>(jTable.getModel());
        tableRowSorter.setComparator(1, new Comparator<List<Date>>(){

            @Override
            public int compare(List<Date> list, List<Date> list2) {
                Date date = null;
                Date date2 = null;
                if (list != null && !list.isEmpty()) {
                    date = list instanceof ScheduledDateList ? ((ScheduledDateList)list).getSelectedDate() : list.get(0);
                }
                if (list2 != null && !list2.isEmpty()) {
                    date2 = list2 instanceof ScheduledDateList ? ((ScheduledDateList)list2).getSelectedDate() : list2.get(0);
                }
                if (date == null && date2 == null) {
                    return -1;
                }
                if (date == null) {
                    return -1;
                }
                if (date2 == null) {
                    return 1;
                }
                return date.compareTo(date2);
            }
        });
        return tableRowSorter;
    }

    private List<IWorklistContext> filterWorklistContexts(List<IWorklistContext> list) {
        ArrayList<IWorklistContext> arrayList = new ArrayList<IWorklistContext>();
        for (IWorklistContext iWorklistContext : list) {
            if (iWorklistContext.isScheduled()) {
                ScheduledDateList scheduledDateList = this.buildPossibleScheduleDateList(iWorklistContext);
                if (scheduledDateList == null || scheduledDateList.isEmpty()) continue;
                arrayList.add(iWorklistContext);
                continue;
            }
            arrayList.add(iWorklistContext);
        }
        Collections.sort(arrayList, new Comparator<IWorklistContext>(){

            @Override
            public int compare(IWorklistContext iWorklistContext, IWorklistContext iWorklistContext2) {
                return iWorklistContext.getTitle().compareTo(iWorklistContext2.getTitle());
            }
        });
        return arrayList;
    }

    private ScheduledDateList buildPossibleScheduleDateList(IWorklistContext iWorklistContext) {
        if (!iWorklistContext.isScheduled() || iWorklistContext.getFirstScheduledDate() == null) {
            return null;
        }
        Date date = DateTimeUtils.now();
        Date date2 = iWorklistContext.getFirstScheduledDate();
        Date date3 = new Date(iWorklistContext.getScheduledTime().getTime());
        Date date4 = DateTimeUtils.youngerByDateOnly((Date)date, (Date)date2) ? date : date2;
        boolean bl = false;
        if (DateTimeUtils.youngerByTimeOnly((Date)date, (Date)(date3 = DateTimeUtils.addMinutes((Date)date3, (int)30))) && iWorklistContext.isSchedulableOn(date4)) {
            bl = true;
        }
        date3 = DateTimeUtils.addMinutes((Date)date3, (int)-30);
        Date date5 = DateTimeUtils.addWeeks((Date)date4, (int)4);
        Date date6 = iWorklistContext.getLastScheduledDate() != null ? iWorklistContext.getLastScheduledDate() : date5;
        date6 = DateTimeUtils.older((Date)date6, (Date)date5);
        date6 = DateTimeUtils.setTimeFrom((Date)date6, (Date)date3);
        date4 = DateTimeUtils.setTimeFrom((Date)date4, (Date)date3);
        ScheduledDateList scheduledDateList = new ScheduledDateList();
        int n = 0;
        Date date7 = date4;
        while (date7.getTime() <= date6.getTime()) {
            List list = iWorklistContext.getScheduledOnDay(date7);
            if (list != null) {
                for (Date date8 : list) {
                    if (scheduledDateList.getSelectedDate() == null) {
                        scheduledDateList.setSelectedDate(date8);
                    } else if (bl && n == 1) {
                        scheduledDateList.setSelectedDate(date8);
                    }
                    scheduledDateList.add(date8);
                    ++n;
                }
            }
            date7 = DateTimeUtils.addDays((Date)date7, (int)1);
        }
        return scheduledDateList;
    }

    private static class ListCellEditor
    extends DefaultCellEditor {
        private JComboBox combo;
        private JLabel label;

        public ListCellEditor(IComponentFactory iComponentFactory) {
            super(iComponentFactory.createComboBox());
            this.label = iComponentFactory.createLabel("");
            this.combo = (JComboBox)this.editorComponent;
            this.combo.setMaximumRowCount(7);
            this.setClickCountToStart(1);
            this.combo.setRenderer(new BasicComboBoxRenderer(){

                @Override
                public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
                    Component component = super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
                    if (bl) {
                        this.setBackground(UIManager.getColor("Table.selectionBackground"));
                        this.setForeground(UIManager.getColor("Table.selectionForeground"));
                    } else {
                        this.setBackground(UIManager.getColor("Table.background"));
                        this.setForeground(UIManager.getColor("Table.foreground"));
                    }
                    return component;
                }
            });
        }

        @Override
        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            this.combo.removeAllItems();
            if (!(object instanceof List) || ((List)object).size() <= 0) {
                this.label.setText("");
                this.label.setFont(jTable.getFont());
                this.label.setBorder(UIManager.getBorder("Table.focusCellHighlightBorder"));
                this.label.setForeground(bl ? jTable.getSelectionForeground() : jTable.getForeground());
                this.label.setBackground(bl ? jTable.getSelectionBackground() : jTable.getBackground());
                return this.label;
            }
            Iterator iterator = ((List)object).iterator();
            while (iterator != null && iterator.hasNext()) {
                this.combo.addItem(WorklistChooserPanel.dateToString((Date)iterator.next()));
            }
            this.combo.setBackground(jTable.getBackground());
            this.combo.setForeground(jTable.getForeground());
            this.combo.setFont(jTable.getFont());
            return this.combo;
        }

        @Override
        public Object getCellEditorValue() {
            String string = (String)super.getCellEditorValue();
            try {
                return DateFormat.getDateTimeInstance(2, 3).parse(string);
            }
            catch (ParseException parseException) {
                log.error("Cell editor value could not be parsed: " + string + ", message was " + parseException.getMessage(), (Throwable)parseException);
                return null;
            }
        }
    }

    private static class ListCellRenderer
    extends DefaultTableCellRenderer {
        public ListCellRenderer(IComponentFactory iComponentFactory) {
            iComponentFactory.scaleFont((Component)this);
        }

        @Override
        protected void setValue(Object object) {
            if (object instanceof ScheduledDateList && ((ScheduledDateList)object).getSelectedDate() != null) {
                String string = WorklistChooserPanel.dateToString(((ScheduledDateList)object).getSelectedDate());
                super.setValue(string);
            } else {
                super.setValue("");
            }
        }
    }

    private static class ScheduledDateList
    extends ArrayList<Date> {
        private Date selectedDate;

        private ScheduledDateList() {
        }

        public Date getSelectedDate() {
            if (this.selectedDate != null) {
                return this.selectedDate;
            }
            if (!this.isEmpty()) {
                return (Date)this.get(0);
            }
            return null;
        }

        public void setSelectedDate(Date date) {
            this.selectedDate = date;
        }
    }
}

