/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.swingx.controls.treetable;

import com.agfa.pacs.listtext.swingx.controls.treetable.ITreeTableModel;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.tree.TreePath;

public class TreeTableModelAdapter
extends AbstractTableModel {
    private static final long serialVersionUID = 5514944856848917191L;
    JTree tree;
    ITreeTableModel treeTableModel;

    public TreeTableModelAdapter(ITreeTableModel iTreeTableModel, JTree jTree) {
        this.tree = jTree;
        this.treeTableModel = iTreeTableModel;
        jTree.addTreeExpansionListener(new TreeExpansionListener(){

            @Override
            public void treeExpanded(TreeExpansionEvent treeExpansionEvent) {
                TreeTableModelAdapter.this.delayedFireTableDataChanged();
            }

            @Override
            public void treeCollapsed(TreeExpansionEvent treeExpansionEvent) {
                TreeTableModelAdapter.this.delayedFireTableDataChanged();
            }
        });
        iTreeTableModel.addTreeModelListener(new TreeModelListener(){

            @Override
            public void treeNodesChanged(TreeModelEvent treeModelEvent) {
                TreeTableModelAdapter.this.delayedFireTableDataChanged();
            }

            @Override
            public void treeNodesInserted(TreeModelEvent treeModelEvent) {
                TreeTableModelAdapter.this.delayedFireTableDataChanged();
            }

            @Override
            public void treeNodesRemoved(TreeModelEvent treeModelEvent) {
                TreeTableModelAdapter.this.delayedFireTableDataChanged();
            }

            @Override
            public void treeStructureChanged(TreeModelEvent treeModelEvent) {
                TreeTableModelAdapter.this.delayedFireTableDataChanged();
            }
        });
    }

    @Override
    public int getColumnCount() {
        return this.treeTableModel.getColumnCount();
    }

    @Override
    public String getColumnName(int n) {
        return this.treeTableModel.getColumnName(n);
    }

    public Class getColumnClass(int n) {
        return this.treeTableModel.getColumnClass(n);
    }

    @Override
    public int getRowCount() {
        return this.tree.getRowCount();
    }

    public Object nodeForRow(int n) {
        TreePath treePath = this.tree.getPathForRow(n);
        return treePath != null ? treePath.getLastPathComponent() : null;
    }

    @Override
    public Object getValueAt(int n, int n2) {
        return this.treeTableModel.getValueAt(this.nodeForRow(n), n2);
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        return this.treeTableModel.isCellEditable(this.nodeForRow(n), n2);
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
        this.treeTableModel.setValueAt(object, this.nodeForRow(n), n2);
        this.fireTableCellUpdated(n, n2);
    }

    public ITreeTableModel getTreeTableModel() {
        return this.treeTableModel;
    }

    protected void delayedFireTableDataChanged() {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    TreeTableModelAdapter.this.fireTableDataChanged();
                }
            });
        } else {
            this.fireTableDataChanged();
        }
    }
}

