/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.swingx.controls.treetable;

import com.agfa.pacs.listtext.swingx.controls.treetable.AbstractCellEditor;
import com.agfa.pacs.listtext.swingx.controls.treetable.ITreeTableModel;
import com.agfa.pacs.listtext.swingx.controls.treetable.JTreeTable;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.EventObject;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.TableCellEditor;
import javax.swing.tree.TreePath;

public class TreeTableCellEditor
extends AbstractCellEditor
implements TableCellEditor {
    private JTreeTable treeTable;

    public TreeTableCellEditor(JTreeTable jTreeTable) {
        this.treeTable = jTreeTable;
    }

    @Override
    public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
        return this.treeTable.getTree();
    }

    @Override
    public boolean isCellEditable(EventObject eventObject) {
        if (eventObject instanceof MouseEvent) {
            MouseEvent mouseEvent = (MouseEvent)eventObject;
            int n = -1;
            int n2 = this.treeTable.getColumnCount() - 1;
            while (n2 >= 0) {
                if (this.treeTable.getColumnClass(n2) == ITreeTableModel.class) {
                    n = n2;
                    break;
                }
                --n2;
            }
            if (n >= 0) {
                boolean bl;
                Rectangle rectangle = this.treeTable.getCellRect(0, n, true);
                int n3 = mouseEvent.getX() - rectangle.x;
                int n4 = mouseEvent.getY();
                TreePath treePath = this.treeTable.getTree().getPathForLocation(rectangle.x + rectangle.width / 2, n4);
                boolean bl2 = bl = treePath != null && this.treeTable.isLocationInExpandControl(treePath, n3, n4);
                if (!bl && mouseEvent.getModifiersEx() == 1024 || bl && SwingUtilities.isLeftMouseButton(mouseEvent)) {
                    MouseEvent mouseEvent2 = new MouseEvent(this.treeTable.getTree(), mouseEvent.getID(), mouseEvent.getWhen(), mouseEvent.getModifiers(), n3, n4, mouseEvent.getClickCount(), mouseEvent.isPopupTrigger());
                    this.treeTable.getTree().dispatchEvent(mouseEvent2);
                }
            }
        }
        return false;
    }
}

