/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.swingx.controls.timetable;

import com.agfa.pacs.listtext.swingx.controls.timetable.ITimeTableItem;
import com.agfa.pacs.listtext.swingx.controls.timetable.ITimeTableItemProvider;
import com.agfa.pacs.listtext.swingx.controls.timetable.TimeTableItemComparator;
import com.agfa.pacs.tools.DateUtilities;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;

public class TimeTableItemProvider
implements ITimeTableItemProvider {
    private HashMap<Date, TreeSet<ITimeTableItem>> objects = new HashMap();

    public TimeTableItemProvider() {
        this(null);
    }

    public TimeTableItemProvider(List<? extends ITimeTableItem> list) {
        if (list != null) {
            for (ITimeTableItem iTimeTableItem : list) {
                this.put(iTimeTableItem);
            }
        }
    }

    @Override
    public SortedSet<? extends ITimeTableItem> getScheduledItems(Date date) {
        return this.objects.get(DateUtilities.resetTime((Date)date));
    }

    public void put(ITimeTableItem iTimeTableItem) {
        Date date = DateUtilities.resetTime((Date)iTimeTableItem.getStartDateTime());
        TreeSet<ITimeTableItem> treeSet = this.objects.get(date);
        if (treeSet == null) {
            treeSet = new TreeSet<ITimeTableItem>(TimeTableItemComparator.getDateComparator());
            this.objects.put(date, treeSet);
        }
        if (!treeSet.contains(iTimeTableItem)) {
            treeSet.add(iTimeTableItem);
        }
    }

    public void remove(ITimeTableItem iTimeTableItem) {
        Date date = DateUtilities.resetTime((Date)iTimeTableItem.getStartDateTime());
        TreeSet<ITimeTableItem> treeSet = this.objects.get(date);
        if (treeSet != null && treeSet.remove(iTimeTableItem) && treeSet.isEmpty()) {
            this.objects.remove(date);
        }
    }

    public void removeAll() {
        this.objects.clear();
    }
}

