/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.swingx.controls.timetable;

import com.agfa.pacs.base.swing.util.EventUtil;
import com.agfa.pacs.listtext.swingx.controls.timetable.ITimeTableItem;
import com.agfa.pacs.listtext.swingx.controls.timetable.ITimeTablePopupListener;
import com.agfa.pacs.listtext.swingx.controls.timetable.TimeTableModel;
import com.agfa.pacs.listtext.swingx.controls.timetable.TimeTableToolPanel;
import com.agfa.pacs.listtext.swingx.controls.timetable.TimeTableWeekTable;
import com.agfa.pacs.listtext.swingx.util.SwingUtilities2;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.table.TableCellRenderer;

public final class TimeTable
extends JPanel
implements ITimeTablePopupListener {
    private TimeTableModel model;
    private TimeTableToolPanel toolPanel;
    private ITimeTableContent content;
    private ITimeTablePopupListener popupHandler;

    public TimeTable() {
        this((TimeTableModel)null);
    }

    public TimeTable(TimeTableModel timeTableModel) {
        super(new BorderLayout());
        this.model = timeTableModel != null ? timeTableModel : new TimeTableModel();
        this.model.addListener(new TimeTableModelListener());
        this.toolPanel = new TimeTableToolPanel(this.model);
        this.content = this.createContent(this.model);
        this.add((Component)SwingUtilities2.createScrollPane(this.content.getContentComponent(), 20, 30, true, true), "Center");
    }

    public TimeTableModel getModel() {
        return this.model;
    }

    public TimeTableToolPanel getToolPanel() {
        return this.toolPanel;
    }

    public TableCellRenderer getItemRenderer() {
        return this.content != null ? this.content.getItemRenderer() : null;
    }

    public void setItemRenderer(TableCellRenderer tableCellRenderer) {
        if (this.content != null) {
            this.content.setItemRenderer(tableCellRenderer);
        }
    }

    public ITimeTablePopupListener getPopupHandler() {
        return this.popupHandler;
    }

    public void setPopupHandler(ITimeTablePopupListener iTimeTablePopupListener) {
        this.popupHandler = iTimeTablePopupListener;
    }

    @Override
    public void setBackground(Color color) {
        super.setBackground(color);
        if (this.content != null) {
            this.content.getContentComponent().setBackground(color);
        }
    }

    @Override
    public void setForeground(Color color) {
        super.setForeground(color);
        if (this.content != null) {
            this.content.getContentComponent().setForeground(color);
        }
    }

    @Override
    public void handlePopupRequest(MouseEvent mouseEvent, ITimeTableItem iTimeTableItem) {
        if (this.popupHandler != null) {
            this.popupHandler.handlePopupRequest(mouseEvent, iTimeTableItem);
        }
    }

    private ITimeTableContent createContent(TimeTableModel timeTableModel) {
        if (timeTableModel.getType().equals(TimeTableModel.TimeTableType.Days7) || timeTableModel.getType().equals(TimeTableModel.TimeTableType.Week)) {
            TimeTableWeekTable timeTableWeekTable = new TimeTableWeekTable(timeTableModel);
            timeTableWeekTable.setPopupListener(this);
            return timeTableWeekTable;
        }
        return null;
    }

    public static interface ITimeTableContent {
        public JComponent getContentComponent();

        public TableCellRenderer getItemRenderer();

        public void setItemRenderer(TableCellRenderer var1);

        public void init(TimeTableModel var1);
    }

    private class TimeTableModelListener
    implements TimeTableModel.ITimeTableModelListener {
        private TimeTableModelListener() {
        }

        @Override
        public void modelChanged() {
            EventUtil.invoke((Runnable)new Runnable(){

                @Override
                public void run() {
                    TimeTable.this.content.init(TimeTable.this.model);
                    TimeTable.this.toolPanel.init(TimeTable.this.model);
                }
            });
        }
    }
}

