/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.swingx.controls.taskpane;

import com.agfa.pacs.listtext.swingx.controls.taskpane.JTaskPane;
import com.agfa.pacs.listtext.swingx.controls.taskpane.TaskPaneTab;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.Vector;

public class TaskPaneModel {
    private Map<TaskPaneTab, JTaskPane.TabConstraint> tabs;
    private PropertyChangeSupport changeSupport = new PropertyChangeSupport(this);
    public static final String TAB_ADDED = "TAB_ADDED";
    public static final String TAB_REMOVED = "TAB_REMOVED";
    public static final String ALL_TABS_REMOVED = "ALL_TABS_REMOVED";
    public static final String TAB_CONSTRAINT_CHANGED = "TAB_CONSTRAINT_CHANGED";

    public TaskPaneModel(Comparator<TaskPaneTab> comparator) {
        this.tabs = comparator != null ? new TreeMap(comparator) : new LinkedHashMap();
    }

    public TaskPaneModel() {
        this(null);
    }

    public List<TaskPaneTab> getTabs() {
        ArrayList<TaskPaneTab> arrayList = new ArrayList<TaskPaneTab>();
        for (TaskPaneTab taskPaneTab : this.tabs.keySet()) {
            arrayList.add(taskPaneTab);
        }
        return arrayList;
    }

    public void addTab(TaskPaneTab taskPaneTab, JTaskPane.TabConstraint tabConstraint) {
        if (taskPaneTab == null) {
            throw new IllegalArgumentException("Argument is null");
        }
        this.tabs.put(taskPaneTab, tabConstraint);
        this.changeSupport.firePropertyChange(TAB_ADDED, null, taskPaneTab);
    }

    public void removeTab(TaskPaneTab taskPaneTab) {
        if (taskPaneTab == null) {
            throw new IllegalArgumentException("Argument is null");
        }
        this.tabs.remove(taskPaneTab);
        this.changeSupport.firePropertyChange(TAB_REMOVED, null, taskPaneTab);
    }

    public void removeAllTabs() {
        this.tabs.clear();
        this.changeSupport.firePropertyChange(ALL_TABS_REMOVED, false, true);
    }

    public Vector<TaskPaneTab> getExpandedTabs() {
        Vector<TaskPaneTab> vector = new Vector<TaskPaneTab>();
        for (TaskPaneTab taskPaneTab : this.tabs.keySet()) {
            if (!taskPaneTab.isExpanded()) continue;
            vector.add(taskPaneTab);
        }
        return vector;
    }

    public int getTabCount() {
        return this.tabs.size();
    }

    public JTaskPane.TabConstraint getTabConstraint(TaskPaneTab taskPaneTab) {
        return this.tabs.get(taskPaneTab);
    }

    public void setTabConstraint(TaskPaneTab taskPaneTab, JTaskPane.TabConstraint tabConstraint) {
        if (!this.tabs.containsKey(taskPaneTab)) {
            return;
        }
        JTaskPane.TabConstraint tabConstraint2 = this.tabs.get(taskPaneTab);
        if (this.tabs.get(taskPaneTab) == tabConstraint) {
            return;
        }
        this.tabs.put(taskPaneTab, tabConstraint);
        this.changeSupport.firePropertyChange(TAB_CONSTRAINT_CHANGED, (Object)tabConstraint2, (Object)tabConstraint);
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.changeSupport.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.changeSupport.removePropertyChangeListener(propertyChangeListener);
    }
}

