/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.swingx.controls.taskpane;

import com.agfa.pacs.listtext.swingx.controls.taskpane.TaskPaneModel;
import com.agfa.pacs.listtext.swingx.controls.taskpane.TaskPaneTab;
import com.agfa.pacs.listtext.swingx.layout.FlowLayout2;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JViewport;
import javax.swing.Scrollable;
import javax.swing.Timer;

public class JTaskPane
extends JComponent
implements Scrollable {
    private static final long serialVersionUID = -7759654360139745133L;
    private TaskPaneModel model = null;
    private FlowLayout2 layout = null;
    private boolean multiExpandable = false;
    private boolean animated = false;
    private int animDelay = 1;
    private int animSteps = 10;
    private ModelListener modelListener = null;
    private TabListener tabListener = null;

    public JTaskPane(TaskPaneModel taskPaneModel, boolean bl, boolean bl2) {
        this.model = taskPaneModel != null ? taskPaneModel : new TaskPaneModel();
        this.layout = new FlowLayout2(1, 4);
        this.multiExpandable = bl;
        this.animated = bl2;
        this.tabListener = new TabListener();
        this.modelListener = new ModelListener();
        this.setLayout(this.layout);
        this.model.addPropertyChangeListener(this.modelListener);
    }

    public JTaskPane(boolean bl, boolean bl2) {
        this(null, bl, bl2);
    }

    public JTaskPane() {
        this(false, false);
    }

    public List<TaskPaneTab> getTabs() {
        return this.model.getTabs();
    }

    public List<TaskPaneTab> getOrderedTabs() {
        Vector<TaskPaneTab> vector = new Vector<TaskPaneTab>();
        for (Component component : this.layout.getComponents()) {
            vector.addElement((TaskPaneTab)component);
        }
        return vector;
    }

    public void addTab(TaskPaneTab taskPaneTab) {
        this.addTab(taskPaneTab, TabConstraint.PREFERRED_SIZED);
        this.moveTab(taskPaneTab, this.getTabs().indexOf(taskPaneTab));
    }

    public void addTab(TaskPaneTab taskPaneTab, TabConstraint tabConstraint) {
        this.model.addTab(taskPaneTab, tabConstraint);
        this.moveTab(taskPaneTab, this.getTabs().indexOf(taskPaneTab));
    }

    public void addTab(TaskPaneTab taskPaneTab, int n, TabConstraint tabConstraint) {
        this.model.addTab(taskPaneTab, tabConstraint);
        this.moveTab(taskPaneTab, n);
    }

    public void removeTab(TaskPaneTab taskPaneTab) {
        this.model.removeTab(taskPaneTab);
        this.revalidate();
        this.repaint();
    }

    public void removeAllTabs() {
        this.model.removeAllTabs();
        this.revalidate();
        this.repaint();
    }

    public int getTabViewIndex(TaskPaneTab taskPaneTab) {
        return this.layout.getComponentIndex(taskPaneTab);
    }

    public void moveTab(TaskPaneTab taskPaneTab, int n) {
        this.layout.moveComponent(taskPaneTab, n);
        this.revalidate();
        this.repaint();
    }

    public int getTabGap() {
        return this.layout.getGap();
    }

    public void setTabGap(int n) {
        if (this.layout.getGap() != n) {
            this.layout.setGap(n);
            this.revalidate();
        }
    }

    public boolean isMultiExpandable() {
        return this.multiExpandable;
    }

    public void setMultiExpandable(boolean bl) {
        if (this.multiExpandable != bl) {
            this.multiExpandable = bl;
        }
    }

    public boolean isAnimated() {
        return this.animated;
    }

    public void setAnimated(boolean bl) {
        if (this.animated != bl) {
            this.animated = bl;
        }
    }

    public int getAnimationDelay() {
        return this.animDelay;
    }

    public void setAnimationDelay(int n) {
        if (this.animDelay != n) {
            this.animDelay = n;
        }
    }

    public int getAnimationSteps() {
        return this.animSteps;
    }

    public void setAnimationSteps(int n) {
        if (this.animSteps != n) {
            this.animSteps = n;
        }
    }

    @Override
    public Dimension getPreferredScrollableViewportSize() {
        return this.getPreferredSize();
    }

    @Override
    public int getScrollableBlockIncrement(Rectangle rectangle, int n, int n2) {
        return 1;
    }

    @Override
    public int getScrollableUnitIncrement(Rectangle rectangle, int n, int n2) {
        return 1;
    }

    @Override
    public boolean getScrollableTracksViewportWidth() {
        if (this.getParent() instanceof JViewport) {
            return this.layout.getOrientation() == 1;
        }
        return true;
    }

    @Override
    public boolean getScrollableTracksViewportHeight() {
        if (this.getParent() instanceof JViewport) {
            return this.layout.getOrientation() == 0;
        }
        return true;
    }

    private void updateOnTabExpansionStateChange(TaskPaneTab taskPaneTab) {
        if (this.animated) {
            this.updateOnTabExpansionStateChange_Dynamic(taskPaneTab);
        } else {
            this.updateOnTabExpansionStateChange_Static(taskPaneTab);
        }
    }

    private void updateOnTabExpansionStateChange_Static(TaskPaneTab taskPaneTab) {
        HashMap<TaskPaneTab, Boolean> hashMap = new HashMap<TaskPaneTab, Boolean>(2);
        if (this.multiExpandable) {
            this.layout.setConstraint(taskPaneTab, this.createLayoutConstraint(taskPaneTab));
            hashMap.put(taskPaneTab, true);
        } else if (taskPaneTab.isExpanded()) {
            for (TaskPaneTab object : this.model.getExpandedTabs()) {
                if (object == taskPaneTab) continue;
                object.removePropertyChangeListener(this.tabListener);
                object.setExpanded(false);
                this.layout.setConstraint(object, this.layout.new FlowLayout2.MinimizedSizeConstraint());
                hashMap.put(object, false);
                object.addPropertyChangeListener(this.tabListener);
            }
            this.layout.setConstraint(taskPaneTab, this.createLayoutConstraint(taskPaneTab));
            hashMap.put(taskPaneTab, true);
        } else {
            this.layout.setConstraint(taskPaneTab, this.layout.new FlowLayout2.MinimizedSizeConstraint());
            hashMap.put(taskPaneTab, true);
        }
        for (Map.Entry entry : hashMap.entrySet()) {
            if (Boolean.TRUE.equals(entry.getValue())) {
                ((TaskPaneTab)entry.getKey()).firePropertyChange("TAB_EXPANDING_STARTED", false, true);
                continue;
            }
            ((TaskPaneTab)entry.getKey()).firePropertyChange("TAB_COLLAPSING_STARTED", false, true);
        }
        this.revalidate();
        for (Map.Entry entry : hashMap.entrySet()) {
            if (((Boolean)entry.getValue()).equals(Boolean.TRUE)) {
                ((TaskPaneTab)entry.getKey()).firePropertyChange("TAB_EXPANDING_FINISHED", false, true);
                continue;
            }
            ((TaskPaneTab)entry.getKey()).firePropertyChange("TAB_COLLAPSING_FINISHED", false, true);
        }
    }

    private void updateOnTabExpansionStateChange_Dynamic(TaskPaneTab taskPaneTab) {
        TabAnimator tabAnimator = new TabAnimator(this.animSteps, this.animDelay);
        if (this.multiExpandable) {
            if (taskPaneTab.isExpanded()) {
                this.layout.setConstraint(taskPaneTab, this.createLayoutConstraint(taskPaneTab));
                tabAnimator.animate(null, taskPaneTab);
            } else {
                this.layout.setConstraint(taskPaneTab, this.layout.new FlowLayout2.MinimizedSizeConstraint());
                tabAnimator.animate(taskPaneTab, null);
            }
        } else if (taskPaneTab.isExpanded()) {
            Vector<TaskPaneTab> vector = this.model.getExpandedTabs();
            TaskPaneTab taskPaneTab2 = null;
            for (TaskPaneTab taskPaneTab3 : vector) {
                if (taskPaneTab3 == taskPaneTab) continue;
                taskPaneTab2 = taskPaneTab3;
                taskPaneTab2.removePropertyChangeListener(this.tabListener);
                taskPaneTab2.setExpanded(false);
                this.layout.setConstraint(taskPaneTab3, this.layout.new FlowLayout2.MinimizedSizeConstraint());
                taskPaneTab2.addPropertyChangeListener(this.tabListener);
                break;
            }
            this.layout.setConstraint(taskPaneTab, this.createLayoutConstraint(taskPaneTab));
            tabAnimator.animate(taskPaneTab2, taskPaneTab);
        } else {
            this.layout.setConstraint(taskPaneTab, this.layout.new FlowLayout2.MinimizedSizeConstraint());
            tabAnimator.animate(taskPaneTab, null);
        }
    }

    private FlowLayout2.Constraint createLayoutConstraint(TaskPaneTab taskPaneTab) {
        if (!taskPaneTab.isExpanded()) {
            return this.layout.new FlowLayout2.MinimizedSizeConstraint();
        }
        TabConstraint tabConstraint = this.model.getTabConstraint(taskPaneTab);
        if (tabConstraint == TabConstraint.PREFERRED_SIZED) {
            return this.layout.new FlowLayout2.PreferredSizeConstraint();
        }
        if (tabConstraint == TabConstraint.MAXIMIZED) {
            return this.layout.new FlowLayout2.MaximizedSizeConstraint();
        }
        return null;
    }

    private class ModelListener
    implements PropertyChangeListener {
        private ModelListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if ("TAB_ADDED".equals(string)) {
                TaskPaneTab taskPaneTab = (TaskPaneTab)propertyChangeEvent.getNewValue();
                if (taskPaneTab.isExpanded()) {
                    JTaskPane.this.add((Component)taskPaneTab, JTaskPane.this.createLayoutConstraint(taskPaneTab));
                } else {
                    JTaskPane.this.add((Component)taskPaneTab, JTaskPane.this.layout.new FlowLayout2.MinimizedSizeConstraint());
                }
                JTaskPane.this.revalidate();
                JTaskPane.this.repaint();
                taskPaneTab.addPropertyChangeListener(JTaskPane.this.tabListener);
                JTaskPane.this.firePropertyChange("TAB_ADDED", null, taskPaneTab);
            } else if ("TAB_REMOVED".equals(string)) {
                TaskPaneTab taskPaneTab = (TaskPaneTab)propertyChangeEvent.getNewValue();
                JTaskPane.this.remove(taskPaneTab);
                JTaskPane.this.revalidate();
                JTaskPane.this.repaint();
                taskPaneTab.removePropertyChangeListener(JTaskPane.this.tabListener);
                JTaskPane.this.firePropertyChange("TAB_REMOVED", null, taskPaneTab);
            } else if ("ALL_TABS_REMOVED".equals(string)) {
                for (TaskPaneTab taskPaneTab : JTaskPane.this.model.getTabs()) {
                    taskPaneTab.removePropertyChangeListener(JTaskPane.this.tabListener);
                }
                JTaskPane.this.removeAll();
                JTaskPane.this.revalidate();
                JTaskPane.this.repaint();
                JTaskPane.this.firePropertyChange("ALL_TABS_REMOVED", false, true);
            } else if ("TAB_CONSTRAINT_CHANGED".equals(string)) {
                TaskPaneTab taskPaneTab = (TaskPaneTab)propertyChangeEvent.getNewValue();
                TabConstraint tabConstraint = JTaskPane.this.model.getTabConstraint(taskPaneTab);
                if (tabConstraint != null) {
                    JTaskPane.this.layout.setConstraint(taskPaneTab, (Object)tabConstraint);
                    JTaskPane.this.revalidate();
                    JTaskPane.this.repaint();
                }
                JTaskPane.this.firePropertyChange("TAB_CONSTRAINT_CHANGED", null, taskPaneTab);
            }
        }
    }

    private class TabAnimator
    implements ActionListener {
        Timer timer = null;
        int animationSteps = 5;
        int delay = 1;
        TaskPaneTab collapse = null;
        TaskPaneTab expand = null;
        int finalExpandingSize = 0;
        int startCollapsingSize = 0;
        float delta = 0.2f;
        boolean locked = false;

        public TabAnimator(int n, int n2) {
            this.timer = new Timer(n2, this);
            this.animationSteps = n <= 0 ? 10 : n;
            this.delay = n2;
        }

        public void animate(TaskPaneTab taskPaneTab, TaskPaneTab taskPaneTab2) {
            this.collapse = taskPaneTab;
            this.expand = taskPaneTab2;
            this.delta = 1.0f / (float)this.animationSteps;
            if (this.expand != null) {
                TabConstraint tabConstraint = JTaskPane.this.model.getTabConstraint(this.expand);
                this.finalExpandingSize = tabConstraint == TabConstraint.PREFERRED_SIZED ? this.expand.getPreferredSize().height : JTaskPane.this.layout.getLayoutComponentSize(JTaskPane.this, this.expand);
            }
            if (this.collapse != null) {
                this.startCollapsingSize = this.collapse.getHeight();
            }
            if (this.collapse != null) {
                this.collapse.firePropertyChange("TAB_COLLAPSING_STARTED", false, true);
            }
            if (this.expand != null) {
                this.expand.firePropertyChange("TAB_EXPANDING_STARTED", false, true);
            }
            this.timer.setCoalesce(true);
            this.timer.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (this.locked) {
                this.delta = 1.0f;
            }
            if ((double)this.delta >= 1.0 && this.timer.isRunning()) {
                this.timer.stop();
            } else if ((double)this.delta >= 1.0) {
                return;
            }
            TabAnimator tabAnimator = this;
            synchronized (tabAnimator) {
                int n;
                int n2;
                this.locked = true;
                if (this.expand != null) {
                    if ((double)this.delta >= 1.0) {
                        JTaskPane.this.layout.setConstraint(this.expand, JTaskPane.this.createLayoutConstraint(this.expand));
                    } else {
                        n2 = this.expand.getMinimumSize().height;
                        n = (int)((float)(this.finalExpandingSize - n2) * this.delta);
                        FlowLayout2 flowLayout2 = JTaskPane.this.layout;
                        FlowLayout2 flowLayout22 = JTaskPane.this.layout;
                        flowLayout22.getClass();
                        flowLayout2.setConstraint(this.expand, flowLayout22.new FlowLayout2.SizeConstraint(n2 + n));
                    }
                }
                if (this.collapse != null) {
                    if (1.0 - (double)this.delta <= 0.0) {
                        JTaskPane.this.layout.setConstraint(this.collapse, JTaskPane.this.layout.new FlowLayout2.MinimizedSizeConstraint());
                    } else {
                        n2 = this.collapse.getMinimumSize().height;
                        n = (int)((double)(this.startCollapsingSize - n2) * (1.0 - (double)this.delta));
                        FlowLayout2 flowLayout2 = JTaskPane.this.layout;
                        FlowLayout2 flowLayout23 = JTaskPane.this.layout;
                        flowLayout23.getClass();
                        flowLayout2.setConstraint(this.collapse, flowLayout23.new FlowLayout2.SizeConstraint(n2 + n));
                    }
                }
                this.delta += 1.0f / (float)this.animationSteps;
                long l = System.currentTimeMillis();
                JTaskPane.this.revalidate();
                if (System.currentTimeMillis() - l > (long)(this.delay * 50)) {
                    this.timer.stop();
                    this.delta = 1.05f;
                }
                this.locked = false;
            }
            if ((double)this.delta >= 1.0) {
                if (this.collapse != null) {
                    this.collapse.firePropertyChange("TAB_COLLAPSING_FINISHED", false, true);
                }
                if (this.expand != null) {
                    this.expand.firePropertyChange("TAB_EXPANDING_FINISHED", false, true);
                }
            }
        }
    }

    public static enum TabConstraint {
        PREFERRED_SIZED,
        MAXIMIZED;

    }

    private class TabListener
    implements PropertyChangeListener {
        private TabListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            boolean bl;
            String string = propertyChangeEvent.getPropertyName();
            if ("TAB_EXPANSION_FLAG_CHANGED".equals(string)) {
                JTaskPane.this.updateOnTabExpansionStateChange((TaskPaneTab)propertyChangeEvent.getSource());
            } else if ("TAB_CLOSURE_FLAG_CHANGED".equals(string) && (bl = ((Boolean)propertyChangeEvent.getNewValue()).booleanValue())) {
                JTaskPane.this.removeTab((TaskPaneTab)propertyChangeEvent.getSource());
            }
        }
    }
}

