/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.swingx.controls;

import com.agfa.pacs.base.swing.IComponentFactory;
import com.agfa.pacs.listtext.swingx.controls.JMultiThumbSlider;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class JIntervalSlider
extends JPanel
implements ChangeListener {
    private static final int LOWER_BOUND_INDEX = 0;
    private static final int UPPER_BOUND_INDEX = 1;
    private final JMultiThumbSlider slider;
    private final JSpinner lowerBoundSpinner;
    private final JSpinner upperBoundSpinner;
    private final List<ChangeListener> listeners;

    public JIntervalSlider(IComponentFactory iComponentFactory, int n, int n2, int n3, int n4) {
        super(new BorderLayout());
        this.slider = new JMultiThumbSlider(iComponentFactory, n3, n4, n, n2);
        this.lowerBoundSpinner = iComponentFactory.createSpinner((SpinnerModel)new SpinnerNumberModel(n, n3, n4, 1));
        this.upperBoundSpinner = iComponentFactory.createSpinner((SpinnerModel)new SpinnerNumberModel(n2, n3, n4, 1));
        this.listeners = new ArrayList<ChangeListener>(2);
        this.slider.addChangeListener(this);
        this.lowerBoundSpinner.addChangeListener(this);
        this.upperBoundSpinner.addChangeListener(this);
        this.add((Component)this.lowerBoundSpinner, "Before");
        this.add((Component)this.slider, "Center");
        this.add((Component)this.upperBoundSpinner, "After");
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        if (changeEvent.getSource() == this.lowerBoundSpinner) {
            this.stateChangedSpinner(0, this.getLowerBound(), this.upperBoundSpinner);
        } else if (changeEvent.getSource() == this.upperBoundSpinner) {
            this.stateChangedSpinner(1, this.getUpperBound(), this.lowerBoundSpinner);
        } else {
            this.setSpinnerValue(this.lowerBoundSpinner, this.slider.getModel().getValue(0));
            this.setSpinnerValue(this.upperBoundSpinner, this.slider.getModel().getValue(1));
        }
        this.fireStateChanged();
    }

    private void fireStateChanged() {
        ChangeEvent changeEvent = new ChangeEvent(this);
        for (ChangeListener changeListener : this.listeners) {
            changeListener.stateChanged(changeEvent);
        }
    }

    private void stateChangedSpinner(int n, int n2, JSpinner jSpinner) {
        if (this.getLowerBound() > this.getUpperBound()) {
            this.slider.setValue(n2);
            this.setSpinnerValue(jSpinner, n2);
        } else {
            this.setSliderValue(n, n2);
        }
    }

    private void setSliderValue(int n, int n2) {
        this.slider.removeChangeListener(this);
        this.slider.getModel().setValue(n, n2);
        this.slider.addChangeListener(this);
    }

    private void setSpinnerValue(JSpinner jSpinner, int n) {
        jSpinner.removeChangeListener(this);
        jSpinner.setValue(n);
        jSpinner.addChangeListener(this);
    }

    public int getLowerBound() {
        return (Integer)this.lowerBoundSpinner.getValue();
    }

    public int getUpperBound() {
        return (Integer)this.upperBoundSpinner.getValue();
    }

    public void setValues(int n, int n2) {
        this.setSpinnerValue(this.lowerBoundSpinner, n);
        this.setSpinnerValue(this.upperBoundSpinner, n2);
        this.slider.removeChangeListener(this);
        this.slider.getModel().setValues(n, n2);
        this.slider.addChangeListener(this);
        this.fireStateChanged();
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.listeners.add(changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.listeners.remove(changeListener);
    }
}

