/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.swingx.controls;

import com.agfa.pacs.listtext.swingx.controls.AbstractComponent;
import com.agfa.pacs.listtext.swingx.controls.DateValue;
import com.agfa.pacs.listtext.swingx.controls.IDateEditor;
import com.agfa.pacs.listtext.swingx.controls.IDateValue;
import com.agfa.pacs.listtext.swingx.controls.MyDateRange;
import com.agfa.pacs.listtext.swingx.controls.plaf.DateBoxUI;
import com.agfa.pacs.listtext.swingx.util.SwingUtilities2;
import java.awt.Component;
import java.util.Date;
import java.util.Map;

public class DateBox
extends AbstractComponent
implements IDateEditor {
    public static final String DATE_VALUE_CHANGED_EVENT = "DATE_VALUE_CHANGED";
    public static final String INT_VALUE_CHANGED_EVENT = "INT_VALUE_CHANGED";
    public static final String RANGE_VALUE_CHANGED_EVENT = "RANGE_VALUE_CHANGED";
    public static final String VALUE_CHANGED_EVENT = "VALUE_CHANGED";
    public static final String INPUT_CHANGED_EVENT = "INPUT_CHANGED";
    private DateValue value;
    private boolean formatDate;
    private boolean formatTime;

    public DateBox(Date date, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5) {
        this.value = new DateValue(date, bl3, bl4, bl5);
        this.formatDate = bl;
        this.formatTime = bl2;
        this.initUI();
    }

    public DateBox(int n, boolean bl) {
        this(null, true, false, bl, true, false);
        this.value.setIntValue(n);
    }

    public DateBox(Date date, boolean bl, boolean bl2, boolean bl3) {
        this(date, bl, bl2, bl3, false, false);
    }

    public DateBox(Date date, boolean bl, boolean bl2) {
        this(date, bl, bl2, false);
    }

    public DateBox(Date date) {
        this(date, true, false);
    }

    public DateBox() {
        this(null);
    }

    @Override
    public Class<?> getComponentUIClass() {
        return DateBoxUI.class;
    }

    @Override
    public String getUIClassID() {
        return "DateBoxUI";
    }

    @Override
    public void registerUIClassPaths(Map<String, String> map) {
        map.put("Basic", "com.agfa.pacs.listtext.swingx.controls.plaf.basic.BasicDateBoxUI");
    }

    @Override
    public void setDate(Date date) throws IllegalArgumentException {
        this.value.setDate(date);
        this.firePropertyChange(DATE_VALUE_CHANGED_EVENT, (Object)false, date);
        this.firePropertyChange(VALUE_CHANGED_EVENT, (Object)false, date);
    }

    public void setIntValue(int n) throws UnsupportedOperationException {
        this.value.setIntValue(n);
        this.firePropertyChange(INT_VALUE_CHANGED_EVENT, (Object)false, (Object)n);
        this.firePropertyChange(VALUE_CHANGED_EVENT, (Object)false, (Object)n);
    }

    public void setRangeValue(MyDateRange myDateRange) throws UnsupportedOperationException {
        this.value.setRangeValue(myDateRange);
        this.firePropertyChange(RANGE_VALUE_CHANGED_EVENT, (Object)false, myDateRange);
        this.firePropertyChange(VALUE_CHANGED_EVENT, (Object)false, myDateRange);
    }

    @Override
    public Date getDate() {
        return this.value.getDate();
    }

    public IDateValue getValue() {
        return this.value;
    }

    @Override
    public Component getRootAWTComponent() {
        return this;
    }

    public boolean isDateFormatEnabled() {
        return this.formatDate;
    }

    public boolean isTimeFormatEnabled() {
        return this.formatTime;
    }

    public void inputChanged(String string) {
        this.firePropertyChange(INPUT_CHANGED_EVENT, (Object)false, string);
    }

    @Override
    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        SwingUtilities2.setComponentHierarchyEnabled(this, bl, new Component[0]);
    }
}

