/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.swingx.controls;

import com.agfa.pacs.base.swing.util.EventUtil;
import com.agfa.pacs.logging.ALogger;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;

public abstract class AbstractComponent
extends JComponent {
    private boolean registeredUI = false;
    private Map<String, String> uiClassPaths = new HashMap<String, String>(2);

    public abstract Class<?> getComponentUIClass();

    @Override
    public abstract String getUIClassID();

    public abstract void registerUIClassPaths(Map<String, String> var1);

    protected ComponentUI initUI() {
        EventUtil.invokeSynchronous((Runnable)new Runnable(){

            @Override
            public void run() {
                AbstractComponent.this.registerUIClassPaths(AbstractComponent.this.uiClassPaths);
                AbstractComponent.this.registerUI();
                AbstractComponent.this.updateUI();
            }
        });
        return this.ui;
    }

    @Override
    public void setUI(ComponentUI componentUI) {
        if (!this.getComponentUIClass().isAssignableFrom(componentUI.getClass())) {
            throw new IllegalArgumentException("Wrong UI class for component!");
        }
        super.setUI(componentUI);
    }

    @Override
    public void updateUI() {
        ComponentUI componentUI;
        if (!this.registeredUI) {
            this.registerUI();
        }
        if ((componentUI = UIManager.getUI(this)) == null) {
            String string = this.uiClassPaths.get("Basic");
            try {
                componentUI = (ComponentUI)this.getClass().getClassLoader().loadClass(string).newInstance();
            }
            catch (Exception exception) {
                ALogger.getLogger(AbstractComponent.class).error("UI Exception", (Throwable)exception);
            }
        }
        if (componentUI != null) {
            this.setUI(componentUI);
        }
    }

    private void registerUI() {
        String string = UIManager.getLookAndFeel().getID();
        if (this.uiClassPaths.containsKey(string)) {
            UIManager.put(this.getUIClassID(), this.uiClassPaths.get(string));
        } else if (this.uiClassPaths.containsKey("Basic")) {
            UIManager.put(this.getUIClassID(), this.uiClassPaths.get("Basic"));
        } else if (this.uiClassPaths.size() > 0) {
            UIManager.put(this.getUIClassID(), this.uiClassPaths.values().iterator().next());
        }
        this.registeredUI = true;
    }

    private class LAFChangeListener
    implements PropertyChangeListener {
        private LAFChangeListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if (string.equals("lookAndFeel")) {
                AbstractComponent.this.registerUI();
                AbstractComponent.this.updateUI();
            }
        }
    }
}

