/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.data.export.tce.keyword;

import com.agfa.pacs.data.export.tce.keyword.GenericKeyword;
import com.agfa.pacs.data.export.tce.keyword.GenericXMLKeywordProvider;
import com.agfa.pacs.data.shared.code.Code;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.TreeMap;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class GenericSimpleListXMLKeywordProvider
extends GenericXMLKeywordProvider {
    public static final String TYPE = "SIMPLE_XML";
    private Map<String, GenericKeyword> valueMap = new TreeMap<String, GenericKeyword>();

    private GenericSimpleListXMLKeywordProvider(String string, String string2, Collection<GenericKeyword> collection) {
        super(string, string2);
        if (collection != null) {
            for (GenericKeyword genericKeyword : collection) {
                this.valueMap.put(genericKeyword.getValueId(), genericKeyword);
            }
        }
    }

    public static GenericSimpleListXMLKeywordProvider createInstance(Document document) {
        Node node = document.getElementsByTagName("coding-system").item(0);
        NamedNodeMap namedNodeMap = node.getAttributes();
        String string = namedNodeMap.getNamedItem("id").getTextContent();
        String string2 = namedNodeMap.getNamedItem("designator-id").getTextContent();
        String string3 = namedNodeMap.getNamedItem("designator-name").getTextContent();
        String string4 = String.valueOf(string2) + "$" + string;
        ArrayList<GenericKeyword> arrayList = new ArrayList<GenericKeyword>();
        NodeList nodeList = document.getElementsByTagName("simple-list");
        if (nodeList != null && nodeList.getLength() > 0) {
            NodeList nodeList2 = nodeList.item(0).getChildNodes();
            int n = 0;
            while (n < nodeList2.getLength()) {
                Node node2 = nodeList2.item(n);
                if ("code".equals(node2.getNodeName())) {
                    NamedNodeMap namedNodeMap2 = nodeList2.item(n).getAttributes();
                    arrayList.add(new GenericKeyword(string4, namedNodeMap2.getNamedItem("value").getTextContent(), namedNodeMap2.getNamedItem("meaning").getTextContent()));
                }
                ++n;
            }
        }
        return new GenericSimpleListXMLKeywordProvider(string4, string3, arrayList);
    }

    public Collection<GenericKeyword> getKeywords() {
        return this.valueMap.values();
    }

    @Override
    public GenericKeyword findKeyword(Code code) {
        return this.findKeyword(code.getCodeValue());
    }

    @Override
    public GenericKeyword findKeyword(String string) {
        return this.valueMap.get(string);
    }

    @Override
    public boolean supportsDicomCodes() {
        return true;
    }

    @Override
    public String getType() {
        return TYPE;
    }
}

