/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.dicomstoragecommitment;

import com.agfa.pacs.data.dicom.DicomException;
import com.agfa.pacs.data.shared.dicom.IDicomNode;
import com.agfa.pacs.listtext.dicomstoragecommitment.IStorageCommitmentListener;
import com.agfa.pacs.listtext.dicomstoragecommitment.StorageCommitmentManager;
import com.agfa.pacs.listtext.dicomstoragecommitment.StorageCommitmentRequest;
import com.agfa.pacs.listtext.dicomstoragecommitment.StorageCommitmentResult;
import com.agfa.pacs.listtext.dicomstoragecommitment.comm.StorageCommitmentNServiceSCU;
import com.agfa.pacs.logging.ALogger;
import java.util.ArrayList;
import java.util.List;
import org.dcm4che3.util.UIDUtils;

public class StorageCommitmentHandler {
    private static final ALogger log = ALogger.getLogger(StorageCommitmentHandler.class);
    public static final int RESULT_SUCCESS = 1;
    public static final int RESULT_SOMEFAILED = 2;
    private String transactionUID;
    private StorageCommitmentRequest request;
    private StorageCommitmentResult result;
    private List<IStorageCommitmentListener> listener = new ArrayList<IStorageCommitmentListener>();
    private int requestStatus;
    private int resultStatus;

    public StorageCommitmentHandler(StorageCommitmentRequest storageCommitmentRequest) {
        this.transactionUID = UIDUtils.createUID();
        this.request = storageCommitmentRequest;
        this.request.setTransactionUID(this.transactionUID);
    }

    public synchronized void addListener(IStorageCommitmentListener iStorageCommitmentListener) {
        this.listener.add(iStorageCommitmentListener);
    }

    public synchronized void removeListener(IStorageCommitmentListener iStorageCommitmentListener) {
        this.listener.remove(iStorageCommitmentListener);
    }

    public synchronized StorageCommitmentRequest getRequest() {
        return this.request;
    }

    public synchronized StorageCommitmentResult getResult() {
        return this.result;
    }

    public synchronized void setResult(StorageCommitmentResult storageCommitmentResult) {
        this.result = storageCommitmentResult;
        for (IStorageCommitmentListener iStorageCommitmentListener : this.listener) {
            iStorageCommitmentListener.resultAvailable(this);
        }
    }

    public synchronized String getTransactionUID() {
        return this.transactionUID;
    }

    public int getRequestStatus() {
        return this.requestStatus;
    }

    public void setRequestStatus(int n) {
        this.requestStatus = n;
    }

    public int getResultStatus() {
        return this.resultStatus;
    }

    public void setResultStatus(int n) {
        this.resultStatus = n;
    }

    public void requestCommit(IDicomNode iDicomNode) throws DicomException {
        try (StorageCommitmentNServiceSCU storageCommitmentNServiceSCU = new StorageCommitmentNServiceSCU(iDicomNode);){
            storageCommitmentNServiceSCU.connect();
            storageCommitmentNServiceSCU.requestStorageCommitment(this.getRequest().toDataset());
            int n = storageCommitmentNServiceSCU.getLastStatus();
            if (n == 43009) {
                log.error("Could not obtain a commitment, as the move destination is unknown");
            } else if (n != 0) {
                log.error("Other error:" + n);
            }
            this.setRequestStatus(n);
            if (n == 0) {
                StorageCommitmentManager.getInstance().addHandler(this);
            }
        }
    }
}

