/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.auditing;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.dcm4che3.audit.AuditMessage;
import org.dcm4che3.audit.AuditMessages;
import org.dcm4che3.audit.ParticipantObjectContainsStudy;
import org.dcm4che3.audit.ParticipantObjectDescription;
import org.dcm4che3.audit.ParticipantObjectIDTypeCode;
import org.dcm4che3.audit.ParticipantObjectIdentification;
import org.dcm4che3.data.Attributes;

public class ReferencedData {
    private Map<String, PatientEntry> patients = new HashMap<String, PatientEntry>();
    private Map<String, ParticipantObjectDescription> studies = new HashMap<String, ParticipantObjectDescription>();

    private void addPatient(String string, String string2) {
        if (string2 != null) {
            this.patients.put(string2, new PatientEntry(string2, string));
        }
    }

    public void addData(List<? extends Attributes> list) {
        for (Attributes attributes : list) {
            Object object = attributes.getString(0x100020);
            if (attributes.containsValue(0x100021)) {
                object = String.valueOf(object) + "^^^" + attributes.getString(0x100021);
            }
            this.addPatient(attributes.getString(0x100010), (String)object);
        }
        HashMap<String, ParticipantObjectDescription> hashMap = new HashMap<String, ParticipantObjectDescription>();
        for (Attributes attributes : list) {
            String string = attributes.getString(0x20000D);
            if (this.studies.containsKey(string)) continue;
            ParticipantObjectDescription participantObjectDescription = new ParticipantObjectDescription();
            ParticipantObjectContainsStudy participantObjectContainsStudy = AuditMessages.createParticipantObjectContainsStudy((String)string);
            if (attributes.containsValue(524368) && !"".equals(attributes.getString(524368))) {
                participantObjectDescription.getAccession().add(AuditMessages.createAccession((String)attributes.getString(524368)));
            }
            participantObjectDescription.getParticipantObjectContainsStudy().add(participantObjectContainsStudy);
            hashMap.put(string, participantObjectDescription);
        }
        this.studies.putAll(hashMap);
    }

    public void addToMessage(AuditMessage auditMessage) {
        ParticipantObjectIdentification participantObjectIdentification;
        for (PatientEntry object : this.patients.values()) {
            participantObjectIdentification = new ParticipantObjectIdentification();
            participantObjectIdentification.setParticipantObjectName(object.name);
            participantObjectIdentification.setParticipantObjectID(object.id);
            participantObjectIdentification.setParticipantObjectIDTypeCode((ParticipantObjectIDTypeCode)AuditMessages.ParticipantObjectIDTypeCode.PatientNumber);
            participantObjectIdentification.setParticipantObjectTypeCode("1");
            participantObjectIdentification.setParticipantObjectTypeCodeRole("1");
            auditMessage.getParticipantObjectIdentification().add(participantObjectIdentification);
        }
        for (Map.Entry entry : this.studies.entrySet()) {
            participantObjectIdentification = new ParticipantObjectIdentification();
            participantObjectIdentification.setParticipantObjectDescription((ParticipantObjectDescription)entry.getValue());
            participantObjectIdentification.setParticipantObjectID((String)entry.getKey());
            participantObjectIdentification.setParticipantObjectIDTypeCode((ParticipantObjectIDTypeCode)AuditMessages.ParticipantObjectIDTypeCode.StudyInstanceUID);
            participantObjectIdentification.setParticipantObjectTypeCode("2");
            participantObjectIdentification.setParticipantObjectTypeCodeRole("3");
            auditMessage.getParticipantObjectIdentification().add(participantObjectIdentification);
        }
    }

    private static class PatientEntry {
        String id;
        String name;

        PatientEntry(String string, String string2) {
            this.id = string;
            this.name = string2;
        }
    }
}

