/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.lta.print.util;

import com.agfa.pacs.config.ConfigurationProviderFactory;
import com.agfa.pacs.config.IConfigurationProvider;
import com.agfa.pacs.data.shared.dicom.YesNo;
import com.agfa.pacs.listtext.dicomobject.module.print.ImageFormat;
import com.agfa.pacs.listtext.dicomobject.module.print.Media;
import com.agfa.pacs.listtext.dicomobject.module.print.PrinterConfigurationItem;
import com.agfa.pacs.listtext.dicomobject.type.print.DecimateCropResult;
import com.agfa.pacs.listtext.dicomobject.type.print.Density;
import com.agfa.pacs.listtext.dicomobject.type.print.FilmDestination;
import com.agfa.pacs.listtext.dicomobject.type.print.FilmOrientation;
import com.agfa.pacs.listtext.dicomobject.type.print.FilmSizeID;
import com.agfa.pacs.listtext.dicomobject.type.print.MagnificationType;
import com.agfa.pacs.listtext.dicomobject.type.print.MediumType;
import com.agfa.pacs.listtext.dicomobject.type.print.imagedisplayformat.ImageDisplayFormat;
import com.agfa.pacs.listtext.lta.print.Messages;
import com.agfa.pacs.listtext.lta.print.remote.DicomPrinterWrapper;
import com.agfa.pacs.logging.ALogger;
import java.io.ByteArrayInputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ConfigurationUtils {
    private static final String DENSITY_BLACK = "BLACK";
    private static ALogger log = ALogger.getLogger(ConfigurationUtils.class);
    private static ConfigurationUtils instance = new ConfigurationUtils();
    private int maxMemory;
    private int maxCollatedFilms;
    private int memoryBitDepth;
    private int printingBitDepth;
    private boolean cropImages;
    private MagnificationType defaultMagnification;
    private String defaultSmoothing;
    private String defaultLabel;
    private String[] allMagnifications;
    private DicomPrinterWrapper printer = null;

    public ConfigurationUtils() {
        IConfigurationProvider iConfigurationProvider = ConfigurationProviderFactory.getConfig();
        iConfigurationProvider = iConfigurationProvider.getNode("listtext.print.default_dicom");
        this.maxMemory = (int)iConfigurationProvider.getLong("memory");
        this.maxCollatedFilms = (int)iConfigurationProvider.getLong("collated_films");
        this.memoryBitDepth = (int)iConfigurationProvider.getLong("memory_bit_depth");
        this.printingBitDepth = (int)iConfigurationProvider.getLong("printing_bit_depth");
        this.cropImages = iConfigurationProvider.getBoolean("crop_images");
        this.defaultMagnification = MagnificationType.get((String)iConfigurationProvider.getString("magnification"));
        this.defaultSmoothing = iConfigurationProvider.getString("smoothing");
        this.allMagnifications = new String[4];
        this.allMagnifications[0] = MagnificationType.Bilinear.toString();
        this.allMagnifications[1] = MagnificationType.Cubic.toString();
        this.allMagnifications[2] = MagnificationType.None.toString();
        this.allMagnifications[3] = MagnificationType.Replicate.toString();
        this.defaultLabel = iConfigurationProvider.getString("label");
    }

    public static boolean testXML(String string) throws Exception {
        if (string == null) {
            return false;
        }
        DicomPrinterWrapper dicomPrinterWrapper = new DicomPrinterWrapper("dummy", "dummy", 1, "dummy", "dummy", null);
        instance.extractXML_Impl(dicomPrinterWrapper, string);
        return true;
    }

    public static void extractXML(DicomPrinterWrapper dicomPrinterWrapper, String string) throws Exception {
        if (string == null) {
            return;
        }
        instance.extractXML_Impl(dicomPrinterWrapper, string);
    }

    private void extractXML_Impl(DicomPrinterWrapper dicomPrinterWrapper, String string) throws Exception {
        try {
            String string2;
            Media media;
            int n;
            Boolean bl;
            Boolean bl2;
            Object object;
            Boolean bl3;
            String string3;
            String string4;
            String string5;
            String string6;
            log.debug("Another Printer Config");
            this.printer = dicomPrinterWrapper;
            string = string.trim();
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(string.getBytes());
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setValidating(false);
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.parse(byteArrayInputStream);
            PrinterConfigurationItem printerConfigurationItem = new PrinterConfigurationItem();
            String string7 = this.getSingleItemContent(document, "agfaPrinter");
            try {
                dicomPrinterWrapper.setAgfaPrinter(Boolean.parseBoolean(string7));
            }
            catch (Exception exception) {
                dicomPrinterWrapper.setAgfaPrinter(false);
            }
            String string8 = this.getSingleItemContent(document, "configurationInformation");
            printerConfigurationItem.setConfigurationInformation(string8);
            String string9 = this.getSingleItemValue(document, "label");
            if (string9 == null) {
                string9 = this.defaultLabel;
            }
            dicomPrinterWrapper.setLabel(string9);
            String string10 = this.getSingleItemValue(document, "density", "border");
            dicomPrinterWrapper.setBorderDensity(string10 == null ? null : Density.get((String)string10));
            String string11 = this.getSingleItemValue(document, "ambient");
            if (string11 != null) {
                dicomPrinterWrapper.setAmbient(Integer.parseInt(string11));
            }
            if ((string6 = this.getSingleItemValue(document, "illumination")) != null) {
                dicomPrinterWrapper.setIllumination(Integer.parseInt(string6));
            }
            String string12 = this.getSingleItemValue(document, "density", "empty");
            dicomPrinterWrapper.setEmptyDensity(Density.get((String)string12));
            String string13 = this.getSingleItemValue(document, "support_real");
            if (string13 != null) {
                dicomPrinterWrapper.setSupportReal(Boolean.parseBoolean(string13));
            }
            if ((string5 = this.getSingleItemValue(document, "lut")) != null) {
                dicomPrinterWrapper.setPresentationLUT(DicomPrinterWrapper.PresentationLUT.valueOf(string5));
            }
            dicomPrinterWrapper.setTrim((string4 = this.getSingleItemValue(document, "trim")) == null ? null : Boolean.valueOf(string4));
            String string14 = this.getSingleItemValue(document, "decimateCrop");
            if (string14 != null) {
                printerConfigurationItem.setDecimateCropResult(DecimateCropResult.get((String)string14));
            }
            if ((string3 = this.getSingleItemValue(document, "memory")) == null) {
                string3 = Integer.toString(this.maxMemory);
            }
            printerConfigurationItem.setMaximumMemoryAllocation(Integer.valueOf(Integer.parseInt(string3)));
            String string15 = this.getSingleItemValue(document, "destination");
            if (string15 != null) {
                dicomPrinterWrapper.setDestination(FilmDestination.get((String)string15));
            }
            if ((bl3 = this.getSingleItemValueAsBool(document, "setCharacterSet", "value")) != null) {
                printerConfigurationItem.setSetCharacterSet(bl3.booleanValue());
            }
            if ((string3 = this.getSingleItemValue(document, "collated_films")) == null) {
                string3 = Integer.toString(this.maxCollatedFilms);
            }
            printerConfigurationItem.setMaximumCollatedFilms(Integer.valueOf(Integer.parseInt(string3)));
            string3 = this.getSingleItemValue(document, "memory_bit");
            if (string3 == null) {
                string3 = Integer.toString(this.memoryBitDepth);
            }
            printerConfigurationItem.setMemoryBitDepth(Integer.valueOf(Integer.parseInt(string3)));
            string3 = this.getSingleItemValue(document, "printing_bit");
            if (string3 == null) {
                string3 = Integer.toString(this.printingBitDepth);
            }
            printerConfigurationItem.setPrintingBitDepth(Integer.valueOf(Integer.parseInt(string3)));
            string3 = this.getSingleItemValue(document, "magnification");
            if (string3 == null) {
                string3 = this.defaultMagnification.toString();
            }
            printerConfigurationItem.setDefaultMagnificationType(MagnificationType.get((String)string3));
            string3 = this.getSingleItemValue(document, "resolution");
            printerConfigurationItem.setPrinterDPI(string3 != null ? Integer.valueOf(Integer.parseInt(string3)) : null);
            string3 = this.getSingleItemValue(document, "smoothing");
            if (string3 == null) {
                string3 = this.defaultSmoothing;
            }
            printerConfigurationItem.setDefaultSmoothingType(string3);
            String[] stringArray = this.getSubItems(document, "smoothing");
            if (stringArray != null) {
                printerConfigurationItem.setOtherSmoothingTypesAvailable(stringArray);
            }
            if ((stringArray = this.getSubItems(document, "magnification")) == null) {
                stringArray = this.allMagnifications;
            }
            Object object2 = stringArray;
            int n2 = stringArray.length;
            int n3 = 0;
            while (n3 < n2) {
                object = object2[n3];
                printerConfigurationItem.otherMagnificationTypesAvailable().add(MagnificationType.get((String)object));
                ++n3;
            }
            object = this.getSingleItemValueAsBool(document, "sop_classes", "color");
            if (object == null) {
                object = true;
            }
            if ((bl2 = this.getSingleItemValueAsBool(document, "sop_classes", "annotation")) == null) {
                bl2 = true;
            }
            if ((bl = this.getSingleItemValueAsBool(document, "sop_classes", "presentation_lut")) == null) {
                bl = true;
            }
            if ((object2 = this.getSingleItemValueAsBool(document, "sop_classes", "overlay")) == null) {
                object2 = true;
            }
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add("1.2.840.10008.5.1.1.9");
            arrayList.add("1.2.840.10008.5.1.1.9");
            if (((Boolean)object).booleanValue()) {
                arrayList.add("1.2.840.10008.5.1.1.4.1");
                arrayList.add("1.2.840.10008.5.1.1.18");
            }
            if (bl2.booleanValue()) {
                arrayList.add("1.2.840.10008.5.1.1.15");
            }
            if (((Boolean)object2).booleanValue()) {
                arrayList.add("1.2.840.10008.5.1.1.24.1");
            }
            if (bl.booleanValue()) {
                arrayList.add("1.2.840.10008.5.1.1.23");
            }
            printerConfigurationItem.setSopClassesSupported(arrayList.toArray(new String[0]));
            Media[] mediaArray = this.getMedias(document, "media");
            if (mediaArray == null || mediaArray.length == 0) {
                throw new Exception(Messages.getString("ConfigurationUtils.NOMediaDefined"));
            }
            if (mediaArray != null && mediaArray.length > 0) {
                Media[] mediaArray2 = mediaArray;
                n = mediaArray.length;
                int n4 = 0;
                while (n4 < n) {
                    media = mediaArray2[n4];
                    printerConfigurationItem.installedMedia().add(media);
                    ++n4;
                }
            }
            if ((media = this.getFormats(document, "formats")) != null && ((ImageFormat[])media).length > 0) {
                Media media2 = media;
                int n5 = ((ImageFormat[])media2).length;
                n = 0;
                while (n < n5) {
                    Media media3 = media2[n];
                    printerConfigurationItem.supportedImageFormats().add(media3);
                    ++n;
                }
            }
            if ((string2 = this.getAnnotationID(document, "annotations")) != null) {
                printerConfigurationItem.setAnnotationID(string2);
                Map<Integer, String> map = this.getAnnotations(document, "annotations");
                if (map != null) {
                    printerConfigurationItem.setAnnotationBoxes(map);
                }
            }
            dicomPrinterWrapper.setPrinterConfiguration(printerConfigurationItem);
        }
        catch (Exception exception) {
            log.error("Could not parse config", (Throwable)exception);
            throw exception;
        }
    }

    private String getAnnotationID(Document document, String string) {
        NodeList nodeList = document.getElementsByTagName(string);
        if (nodeList.getLength() > 1) {
            log.warn(String.valueOf(Messages.getString("ConfigurationUtils.MultipleOccurenceOf")) + string);
        }
        if (nodeList.getLength() == 0) {
            log.debug(String.valueOf(Messages.getString("ConfigurationUtils.NotSpecifiedValue")) + string);
            return null;
        }
        return this.getAttribute(nodeList.item(0), "ID");
    }

    private String[] getSubItems(Document document, String string) {
        NodeList nodeList = document.getElementsByTagName(string);
        if (nodeList.getLength() == 0) {
            return null;
        }
        nodeList = nodeList.item(0).getChildNodes();
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = 0;
        while (n < nodeList.getLength()) {
            if (nodeList.item(n).getNodeName().equals("item")) {
                arrayList.add(nodeList.item(n).getTextContent());
            }
            ++n;
        }
        return arrayList.toArray(new String[0]);
    }

    private Boolean getSingleItemValueAsBool(Document document, String string, String string2) {
        String string3 = this.getSingleItemValue(document, string, string2);
        if (string3 == null) {
            return null;
        }
        return Boolean.parseBoolean(string3);
    }

    private String getSingleItemValue(Document document, String string) {
        return this.getSingleItemValue(document, string, "value");
    }

    private String getSingleItemContent(Document document, String string) {
        NodeList nodeList = document.getElementsByTagName(string);
        if (nodeList.getLength() > 1) {
            log.warn(String.valueOf(Messages.getString("ConfigurationUtils.MultipleOccurence")) + string);
        }
        if (nodeList.getLength() == 0) {
            log.info(String.valueOf(Messages.getString("ConfigurationUtils.NotSpecifiedValue")) + string);
            return null;
        }
        return nodeList.item(0).getTextContent();
    }

    private String getSingleItemValue(Document document, String string, String string2) {
        NodeList nodeList = document.getElementsByTagName(string);
        if (nodeList.getLength() > 1) {
            log.warn(String.valueOf(Messages.getString("ConfigurationUtils.MultipleOccurence")) + string);
        }
        if (nodeList.getLength() == 0) {
            log.info(String.valueOf(Messages.getString("ConfigurationUtils.NotSpecifiedValue")) + string);
            return null;
        }
        Node node = nodeList.item(0).getAttributes().getNamedItem(string2);
        return node != null ? node.getTextContent() : null;
    }

    private ImageFormat[] getFormats(Document document, String string) throws Exception {
        NodeList nodeList = document.getElementsByTagName(string);
        if (nodeList.getLength() > 1) {
            log.warn(String.valueOf(Messages.getString("ConfigurationUtils.MultipleOccurence")) + string);
        }
        if (nodeList.getLength() == 0) {
            log.info(String.valueOf(Messages.getString("ConfigurationUtils.NotSpecifiedValue")) + string);
            return null;
        }
        nodeList = nodeList.item(0).getChildNodes();
        ArrayList<ImageFormat> arrayList = new ArrayList<ImageFormat>();
        int n = 0;
        while (n < nodeList.getLength()) {
            if (nodeList.item(n).getNodeName().equals("item")) {
                String string2 = this.getAttribute(nodeList.item(n), "orientation");
                FilmOrientation filmOrientation = string2 == null ? FilmOrientation.Portrait : FilmOrientation.get((String)string2);
                String string3 = this.getAttribute(nodeList.item(n), "size_flag");
                boolean bl = true;
                if (string3 == null) {
                    bl = Boolean.parseBoolean(string3);
                }
                YesNo yesNo = bl ? YesNo.Yes : YesNo.No;
                FilmSizeID filmSizeID = FilmSizeID.get((String)this.getAttribute(nodeList.item(n), "size"));
                String string4 = this.getAttribute(nodeList.item(n), "format");
                if (string4 == null) {
                    throw new Exception(Messages.getString("ConfigurationUtils.FormatNotSpecified"));
                }
                ImageDisplayFormat imageDisplayFormat = ImageDisplayFormat.get((String)string4);
                ImageFormat imageFormat = new ImageFormat(imageDisplayFormat, filmOrientation, filmSizeID, yesNo);
                arrayList.add(imageFormat);
            }
            ++n;
        }
        return arrayList.toArray(new ImageFormat[0]);
    }

    private Map<Integer, String> getAnnotations(Document document, String string) {
        NodeList nodeList = document.getElementsByTagName(string);
        if (nodeList.getLength() > 1) {
            log.warn(String.valueOf(Messages.getString("ConfigurationUtils.MultipleOccurenceOf")) + string);
        }
        if (nodeList.getLength() == 0) {
            log.info(String.valueOf(Messages.getString("ConfigurationUtils.NotSpecifiedValue")) + string);
            return null;
        }
        nodeList = nodeList.item(0).getChildNodes();
        HashMap<Integer, String> hashMap = new HashMap<Integer, String>();
        int n = 0;
        while (n < nodeList.getLength()) {
            try {
                if (nodeList.item(n).getNodeName().equals("item")) {
                    String string2 = this.getAttribute(nodeList.item(n), "position");
                    int n2 = Integer.parseInt(string2);
                    String string3 = this.getAttribute(nodeList.item(n), "text");
                    hashMap.put(n2, string3);
                }
            }
            catch (NumberFormatException numberFormatException) {
                log.warn("Error parsing annotations", (Throwable)numberFormatException);
            }
            ++n;
        }
        return hashMap;
    }

    private Media[] getMedias(Document document, String string) {
        NodeList nodeList = document.getElementsByTagName(string);
        if (nodeList.getLength() > 1) {
            log.warn(String.valueOf(Messages.getString("ConfigurationUtils.MultipleOccurenceOf")) + string);
        }
        if (nodeList.getLength() == 0) {
            log.info(String.valueOf(Messages.getString("ConfigurationUtils.NotSpecifiedValue")) + string);
            return null;
        }
        nodeList = nodeList.item(0).getChildNodes();
        ArrayList<Media> arrayList = new ArrayList<Media>();
        int n = 0;
        int n2 = 0;
        while (n2 < nodeList.getLength()) {
            if (nodeList.item(n2).getNodeName().equals("item")) {
                String string2 = this.getAttribute(nodeList.item(n2), "size");
                String string3 = this.getAttribute(nodeList.item(n2), "name");
                if (string2 != null) {
                    FilmSizeID filmSizeID = FilmSizeID.get((String)string2);
                    if (filmSizeID == null) {
                        log.warn(String.valueOf(Messages.getString("ConfigurationUtils.NotSupportedFilmSize")) + string2);
                    } else {
                        String string4 = this.getAttribute(nodeList.item(n2), "type");
                        MediumType mediumType = string4 == null ? MediumType.Paper : MediumType.get((String)string4);
                        String string5 = this.getAttribute(nodeList.item(n2), "width");
                        if (string5 != null) {
                            double d = Double.parseDouble(string5);
                            string5 = this.getAttribute(nodeList.item(n2), "height");
                            double d2 = Double.parseDouble(string5);
                            this.printer.putPageSetting(filmSizeID, d, d2);
                        }
                        arrayList.add(new Media(n++, mediumType, filmSizeID, null, null, string3));
                    }
                }
            }
            ++n2;
        }
        return arrayList.toArray(new Media[0]);
    }

    private String getAttribute(Node node, String string) {
        Node node2 = node.getAttributes().getNamedItem(string);
        if (node2 == null) {
            return null;
        }
        return node2.getTextContent();
    }
}

