/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.lta.print.remote;

import com.agfa.pacs.listtext.dicomobject.module.print.Media;
import com.agfa.pacs.listtext.dicomobject.type.print.PrintPriority;
import com.agfa.pacs.listtext.lta.print.Messages;
import com.agfa.pacs.listtext.lta.print.remote.DicomPrinterWrapper;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ButtonGroup;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;

public class DicomSettingPanel
extends JPanel {
    private static final long serialVersionUID = 1833092644655253872L;
    private DicomPrinterWrapper printer;
    private JLabel mediumLbl = null;
    private JComboBox cmbMedias = null;
    private JLabel copiesLabel = null;
    private JSpinner copies = null;
    private JLabel priorityLabel = null;
    private JComboBox priorities = null;
    private JLabel mediumLabelLbl = null;
    private JTextField mediumLabel = null;
    private JLabel lutLabel = null;
    private JComboBox luts = null;
    private JRadioButton portraitBtn = null;
    private JRadioButton landscapeBtn = null;

    public DicomSettingPanel(DicomPrinterWrapper dicomPrinterWrapper) {
        this.printer = dicomPrinterWrapper;
        this.initUI();
    }

    private void initUI() {
        this.createComponents();
        this.installListeners();
        this.installLayout();
    }

    private void createComponents() {
        this.mediumLbl = this.createLabel(String.valueOf(Messages.getString("Medium")) + ":");
        this.cmbMedias = new JComboBox<Media>(this.printer.getMedias());
        this.cmbMedias.setSelectedItem(this.printer.getSelectedMedium());
        ButtonGroup buttonGroup = new ButtonGroup();
        this.landscapeBtn = new JRadioButton(Messages.getString("Landscape"));
        buttonGroup.add(this.landscapeBtn);
        this.portraitBtn = new JRadioButton(Messages.getString("Portrait"));
        buttonGroup.add(this.portraitBtn);
        if (this.printer.isLandscape()) {
            this.landscapeBtn.setSelected(true);
        } else {
            this.portraitBtn.setSelected(true);
        }
        this.copiesLabel = this.createLabel(String.valueOf(Messages.getString("DicomSettingPanel.Copies")) + ":");
        this.copies = new JSpinner(new SpinnerNumberModel(this.printer.getCopies(), 1, 10, 1));
        this.priorityLabel = this.createLabel(String.valueOf(Messages.getString("DicomSettingPanel.Priority")) + ":");
        this.priorities = new JComboBox<PrintPriority>(PrintPriority.values());
        this.priorities.setSelectedItem(this.printer.getPriority());
        this.lutLabel = this.createLabel(String.valueOf(Messages.getString("DicomSettingPanel.PresentationLUT")) + ":");
        this.luts = new JComboBox<DicomPrinterWrapper.PresentationLUT>(DicomPrinterWrapper.PresentationLUT.values());
        if (this.printer.getPresentationLUT() != null) {
            this.luts.setSelectedItem((Object)this.printer.getPresentationLUT());
        }
        this.luts.setEnabled(false);
        this.mediumLabelLbl = this.createLabel(String.valueOf(Messages.getString("DicomSettingPanel.Label")) + ":");
        this.mediumLabel = new JTextField();
        this.mediumLabel.setText(this.printer.getLabel());
    }

    private void installListeners() {
        ComponentListener componentListener = new ComponentListener();
        this.cmbMedias.addActionListener(componentListener);
        this.landscapeBtn.addActionListener(componentListener);
        this.portraitBtn.addActionListener(componentListener);
        this.priorities.addActionListener(componentListener);
        this.copies.addChangeListener(componentListener);
        this.luts.addActionListener(componentListener);
        MyDocumentListener myDocumentListener = new MyDocumentListener();
        this.mediumLabel.getDocument().addDocumentListener(myDocumentListener);
    }

    private void installLayout() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.setLayout(gridBagLayout);
        gridBagLayout.addLayoutComponent(this.mediumLbl, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 5, 5, 5), 0, 0));
        gridBagLayout.addLayoutComponent(this.cmbMedias, new GridBagConstraints(1, 0, 2, 1, 1.0, 0.0, 18, 2, new Insets(5, 5, 5, 5), 0, 0));
        gridBagLayout.addLayoutComponent(this.portraitBtn, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 18, 2, new Insets(5, 5, 5, 5), 0, 0));
        gridBagLayout.addLayoutComponent(this.landscapeBtn, new GridBagConstraints(2, 1, 1, 1, 1.0, 0.0, 18, 2, new Insets(5, 5, 5, 5), 0, 0));
        gridBagLayout.addLayoutComponent(this.mediumLabelLbl, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 5, 5, 5), 0, 0));
        gridBagLayout.addLayoutComponent(this.mediumLabel, new GridBagConstraints(1, 3, 2, 1, 1.0, 0.0, 18, 2, new Insets(5, 5, 5, 5), 0, 0));
        gridBagLayout.addLayoutComponent(this.priorityLabel, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 5, 5, 5), 0, 0));
        gridBagLayout.addLayoutComponent(this.priorities, new GridBagConstraints(1, 4, 2, 1, 1.0, 0.0, 18, 2, new Insets(5, 5, 5, 5), 0, 0));
        gridBagLayout.addLayoutComponent(this.copiesLabel, new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 5, 5, 5), 0, 0));
        gridBagLayout.addLayoutComponent(this.copies, new GridBagConstraints(1, 5, 1, 1, 1.0, 0.0, 18, 2, new Insets(5, 5, 5, 5), 0, 0));
        gridBagLayout.addLayoutComponent(this.lutLabel, new GridBagConstraints(0, 6, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 5, 5, 5), 0, 0));
        gridBagLayout.addLayoutComponent(this.luts, new GridBagConstraints(1, 6, 2, 1, 1.0, 0.0, 18, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.add(this.mediumLabel);
        this.add(this.mediumLabelLbl);
        this.add(this.mediumLbl);
        this.add(this.cmbMedias);
        this.add(this.landscapeBtn);
        this.add(this.portraitBtn);
        this.add(this.copies);
        this.add(this.copiesLabel);
        this.add(this.priorities);
        this.add(this.priorityLabel);
        this.add(this.lutLabel);
        this.add(this.luts);
    }

    private JLabel createLabel(String string) {
        return new JLabel(string);
    }

    private class ComponentListener
    implements ActionListener,
    ChangeListener {
        private ComponentListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == DicomSettingPanel.this.cmbMedias) {
                DicomSettingPanel.this.printer.setSelectedMedium((Media)DicomSettingPanel.this.cmbMedias.getSelectedItem());
            } else if (actionEvent.getSource() == DicomSettingPanel.this.priorities) {
                DicomSettingPanel.this.printer.setPriority((PrintPriority)DicomSettingPanel.this.priorities.getSelectedItem());
            } else if (actionEvent.getSource() == DicomSettingPanel.this.luts) {
                DicomSettingPanel.this.printer.setPresentationLUT((DicomPrinterWrapper.PresentationLUT)((Object)DicomSettingPanel.this.luts.getSelectedItem()));
            } else {
                DicomSettingPanel.this.printer.setLandscape(DicomSettingPanel.this.landscapeBtn.isSelected());
            }
        }

        @Override
        public void stateChanged(ChangeEvent changeEvent) {
            DicomSettingPanel.this.printer.setCopies((Integer)DicomSettingPanel.this.copies.getModel().getValue());
        }
    }

    private class MyDocumentListener
    implements DocumentListener {
        private MyDocumentListener() {
        }

        @Override
        public void changedUpdate(DocumentEvent documentEvent) {
            this.save(documentEvent.getDocument());
        }

        @Override
        public void insertUpdate(DocumentEvent documentEvent) {
            this.save(documentEvent.getDocument());
        }

        @Override
        public void removeUpdate(DocumentEvent documentEvent) {
            this.save(documentEvent.getDocument());
        }

        private void save(Document document) {
            if (DicomSettingPanel.this.mediumLabel.getDocument() == document) {
                DicomSettingPanel.this.printer.setLabel(DicomSettingPanel.this.mediumLabel.getText());
            }
        }
    }
}

