/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.lta.print.plaf.basic;

import com.agfa.pacs.data.shared.dnd.DataInfoFlavor;
import com.agfa.pacs.data.shared.dnd.DataInfoTransferData;
import com.agfa.pacs.data.shared.dnd.DataInfoTransferable;
import com.agfa.pacs.data.shared.lw.IDataInfo;
import com.agfa.pacs.listtext.lta.print.IImageBoxInfo;
import com.agfa.pacs.listtext.lta.print.IPreview;
import com.agfa.pacs.listtext.lta.print.PrintManager;
import com.agfa.pacs.listtext.lta.print.plaf.basic.DataSorter;
import com.agfa.pacs.logging.ALogger;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.util.BitSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import javax.swing.JLabel;

public class DragnDropHandler
implements DragGestureListener,
DragSourceListener,
DropTargetListener {
    private static final ALogger log = ALogger.getLogger(DragnDropHandler.class);
    private JLabel label;
    private DragSource dragSource;
    private DropTarget dropTarget;
    private PrintManager manager;
    private IPreview preview;
    private boolean internalMove = false;

    public DragnDropHandler(JLabel jLabel, PrintManager printManager, IPreview iPreview) {
        this.label = jLabel;
        this.manager = printManager;
        this.preview = iPreview;
        this.dragSource = DragSource.getDefaultDragSource();
        this.dragSource.createDefaultDragGestureRecognizer(jLabel, 2, this);
        this.dropTarget = new DropTarget(jLabel, 2, this);
        this.dropTarget.setActive(true);
        this.label.setDropTarget(this.dropTarget);
    }

    private float[] getAsRelativeCoordinate(Component component, int n, int n2) {
        Dimension dimension = component.getSize();
        float[] fArray = new float[]{(float)n / (float)dimension.width, (float)n2 / (float)dimension.height};
        return fArray;
    }

    @Override
    public void dragGestureRecognized(DragGestureEvent dragGestureEvent) {
        int n = this.preview.getActualPage();
        Point point = dragGestureEvent.getDragOrigin();
        float[] fArray = this.getAsRelativeCoordinate(dragGestureEvent.getComponent(), point.x, point.y);
        IImageBoxInfo iImageBoxInfo = this.manager.getSelectedFormat().isDataOn(n, fArray[0], fArray[1]);
        if (iImageBoxInfo == null) {
            return;
        }
        HashMap<String, BitSet> hashMap = new HashMap<String, BitSet>();
        BitSet bitSet = new BitSet();
        bitSet.set(iImageBoxInfo.getFrameNumber());
        hashMap.put(iImageBoxInfo.getObjectInfo().getSOPInstanceUID(), bitSet);
        DataInfoTransferable dataInfoTransferable = new DataInfoTransferable(Collections.singletonList(iImageBoxInfo.getObjectInfo()), hashMap);
        dragGestureEvent.startDrag(DragSource.DefaultMoveNoDrop, (Transferable)dataInfoTransferable, this);
        this.internalMove = true;
    }

    @Override
    public void dragEnter(DragSourceDragEvent dragSourceDragEvent) {
        int n = dragSourceDragEvent.getDropAction();
        if ((n & 2) != 0) {
            dragSourceDragEvent.getDragSourceContext().setCursor(DragSource.DefaultMoveDrop);
        } else {
            dragSourceDragEvent.getDragSourceContext().setCursor(DragSource.DefaultCopyNoDrop);
        }
    }

    @Override
    public void dragOver(DragSourceDragEvent dragSourceDragEvent) {
        int n = dragSourceDragEvent.getDropAction();
        if ((n & 2) != 0) {
            dragSourceDragEvent.getDragSourceContext().setCursor(DragSource.DefaultMoveDrop);
        } else {
            dragSourceDragEvent.getDragSourceContext().setCursor(DragSource.DefaultCopyNoDrop);
        }
    }

    @Override
    public void dropActionChanged(DragSourceDragEvent dragSourceDragEvent) {
        int n = dragSourceDragEvent.getDropAction();
        if ((n & 2) != 0) {
            dragSourceDragEvent.getDragSourceContext().setCursor(DragSource.DefaultMoveDrop);
        } else {
            dragSourceDragEvent.getDragSourceContext().setCursor(DragSource.DefaultCopyNoDrop);
        }
    }

    @Override
    public void dragExit(DragSourceEvent dragSourceEvent) {
        dragSourceEvent.getDragSourceContext().setCursor(DragSource.DefaultCopyNoDrop);
    }

    @Override
    public void dragDropEnd(DragSourceDropEvent dragSourceDropEvent) {
        if (!dragSourceDropEvent.getDropSuccess()) {
            return;
        }
        try {
            DataInfoTransferData dataInfoTransferData;
            if (this.internalMove && (dataInfoTransferData = (DataInfoTransferData)dragSourceDropEvent.getDragSourceContext().getTransferable().getTransferData(DataInfoFlavor.FLAVOR)) != null) {
                List<IImageBoxInfo> list = this.manager.createImageBoxes(dataInfoTransferData.getDataInfo(), dataInfoTransferData.getFrameSelection());
                this.manager.deselectData(list);
                for (IImageBoxInfo iImageBoxInfo : list) {
                    this.manager.getSelectedFormat().removeData(iImageBoxInfo);
                }
                this.preview.drawPreview();
            }
        }
        catch (Exception exception) {
            log.warn("Could not Drag&Drop", (Throwable)exception);
        }
        this.internalMove = false;
    }

    @Override
    public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
        if (!this.acceptDrop(dropTargetDragEvent)) {
            dropTargetDragEvent.rejectDrag();
        }
    }

    @Override
    public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
        if (!this.acceptDrop(dropTargetDragEvent)) {
            dropTargetDragEvent.rejectDrag();
        }
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent dropTargetDragEvent) {
        if (!this.acceptDrop(dropTargetDragEvent)) {
            dropTargetDragEvent.rejectDrag();
        }
    }

    @Override
    public void dragExit(DropTargetEvent dropTargetEvent) {
    }

    @Override
    public void drop(DropTargetDropEvent dropTargetDropEvent) {
        try {
            final DataInfoTransferData dataInfoTransferData = (DataInfoTransferData)dropTargetDropEvent.getTransferable().getTransferData(DataInfoFlavor.FLAVOR);
            final boolean bl = this.internalMove;
            this.internalMove = false;
            if (dataInfoTransferData != null) {
                final Point point = dropTargetDropEvent.getLocation();
                new Thread(new Runnable(){

                    @Override
                    public void run() {
                        int n = DragnDropHandler.this.preview.getActualPage();
                        float[] fArray = DragnDropHandler.this.getAsRelativeCoordinate(DragnDropHandler.this.label, point.x, point.y);
                        if (bl) {
                            DragnDropHandler.this.manager.getSelectedFormat().moveData(n, fArray[0], fArray[1], (IDataInfo)dataInfoTransferData.getDataInfo().get(0));
                            DragnDropHandler.this.preview.drawPreview();
                        } else {
                            List<IImageBoxInfo> list = DragnDropHandler.this.manager.createImageBoxes(dataInfoTransferData.getDataInfo(), dataInfoTransferData.getFrameSelection());
                            Collections.sort(list, new DataSorter());
                            DragnDropHandler.this.manager.getSelectedFormat().insertData(n, fArray[0], fArray[1], list);
                            DragnDropHandler.this.manager.selectData(list);
                            DragnDropHandler.this.preview.drawPreview();
                        }
                    }
                }).start();
                dropTargetDropEvent.acceptDrop(dropTargetDropEvent.getDropAction());
                dropTargetDropEvent.dropComplete(true);
            } else {
                dropTargetDropEvent.rejectDrop();
                dropTargetDropEvent.dropComplete(false);
            }
        }
        catch (Exception exception) {
            log.error("Could not drop", (Throwable)exception);
            dropTargetDropEvent.rejectDrop();
            dropTargetDropEvent.dropComplete(false);
        }
    }

    private boolean acceptDrop(DropTargetDragEvent dropTargetDragEvent) {
        try {
            DataInfoTransferData dataInfoTransferData = (DataInfoTransferData)dropTargetDragEvent.getTransferable().getTransferData(DataInfoFlavor.FLAVOR);
            return dataInfoTransferData != null;
        }
        catch (Exception exception) {
            return false;
        }
    }
}

