/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.lta.print.plaf.basic;

import com.agfa.pacs.base.swing.util.GUI;
import com.agfa.pacs.listtext.lta.print.IFormat;
import com.agfa.pacs.listtext.lta.print.IImageBoxInfo;
import com.agfa.pacs.listtext.lta.print.IPrinter;
import com.agfa.pacs.listtext.lta.print.Messages;
import com.agfa.pacs.listtext.lta.print.PrintManager;
import com.agfa.pacs.listtext.lta.print.impl.PrintThumbnails;
import com.agfa.pacs.listtext.lta.print.plaf.PrintManagerUI;
import com.agfa.pacs.listtext.lta.print.plaf.basic.BasicPreviewPanel;
import com.agfa.pacs.listtext.lta.print.plaf.basic.DataSorter;
import com.agfa.pacs.listtext.lta.thumbnail.ThumbnailFrame;
import com.agfa.pacs.listtext.swingx.controls.taskpane.JTaskPane;
import com.agfa.pacs.listtext.swingx.controls.taskpane.TaskPaneTab;
import com.agfa.pacs.listtext.swingx.util.SwingUtilities2;
import com.agfa.pacs.listtext.swingx.util.graphics.IconLoader;
import info.clearthought.layout.TableLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;

public class BasicPrintManagerUI
extends PrintManagerUI {
    public static final String iconPath = "/com/agfa/pacs/listtext/lta/print/plaf/basic/icons/";
    private PrintManager manager = null;
    private JComboBox<IPrinter> cmbPrinters = null;
    private JComboBox<IFormat> cmbFormats = null;
    private JButton btnPrint = null;
    private JButton btnCancel = null;
    private BasicPreviewPanel previewPanel = null;
    private JPanel rightPanel = null;
    private JPanel leftPanel = null;
    private JTaskPane leftPane = null;
    private JPanel btnPanel = null;
    private JCheckBox includeMappings = null;
    private TaskPaneTab printerTab = null;
    private TaskPaneTab formatTab = null;
    private TaskPaneTab thumbnailTab = null;
    private JPanel printerPanel = null;
    private JPanel formatPanel = null;
    private JPanel thumbnailPanel = null;
    private PrintThumbnails thumbnails = null;
    private JButton addAllBtn = null;
    private JComboBox<PrintManager.SPLIT_TYPE> cmbSplit = null;
    private JCheckBox chkAddFootnote = null;
    private JCheckBox chkShowKeyImg = null;
    private PropertyChangeListener myModelListener = new ModelListener();
    private PropertyChangeListener expandingListener = new TabExpandingListener();

    public static ComponentUI createUI(JComponent jComponent) {
        return new BasicPrintManagerUI();
    }

    @Override
    public void installUI(JComponent jComponent) {
        this.manager = (PrintManager)((Object)jComponent);
        this.createComponents();
        this.installListeners();
        this.initComponents();
        this.installLayout();
    }

    @Override
    public void uninstallUI(JComponent jComponent) {
        this.uninstallLayout();
        this.uninstallListeners();
        this.rightPanel.removeAll();
        this.thumbnailPanel.removeAll();
        this.thumbnails = null;
        this.manager = null;
    }

    private void createComponents() {
        this.cmbFormats = new JComboBox<IFormat>(this.manager.getPrintFormats());
        this.cmbFormats.setEditable(false);
        this.cmbFormats.setSelectedItem(this.manager.getSelectedFormat());
        this.cmbPrinters = new JComboBox<IPrinter>(this.manager.getAvailablePrinters());
        IPrinter iPrinter = this.manager.getSelectedPrinter();
        this.cmbPrinters.setSelectedItem(iPrinter);
        if (iPrinter != null) {
            this.cmbPrinters.setToolTipText(iPrinter.toString());
        }
        this.cmbPrinters.setEditable(false);
        this.includeMappings = new JCheckBox(Messages.getString("BasicPrintManagerUI.IncludeMappings"), this.manager.isUsingDemographics());
        this.includeMappings.setSelected(this.manager.isUsingDemographics());
        this.chkAddFootnote = new JCheckBox(Messages.getString("BasicPrintManagerUI.AddFooter"));
        this.chkAddFootnote.setSelected(this.manager.isAddFooter());
        this.chkAddFootnote.setVisible(false);
        this.cmbSplit = new JComboBox<PrintManager.SPLIT_TYPE>(PrintManager.SPLIT_TYPE.values());
        this.cmbSplit.setSelectedItem((Object)this.manager.getSelectedSplitting());
        this.btnCancel = this.createButton(new CancelAction(), 60, 40);
        this.btnPrint = this.createButton(new PrintAction(), 60, 40);
        this.rightPanel = new JPanel(new BorderLayout(5, 5));
        this.leftPane = new JTaskPane(false, false);
        this.printerPanel = new JPanel(new BorderLayout(5, 5));
        this.printerTab = this.createTaskPaneTab("", this.printerPanel);
        this.formatPanel = new JPanel(new BorderLayout(5, 5));
        this.formatTab = this.createTaskPaneTab("", this.formatPanel);
        this.thumbnailPanel = new JPanel(new BorderLayout(5, 5));
        this.thumbnailTab = this.createTaskPaneTab(Messages.getString("BasicPrintManagerUI.ThumbnailsTitle"), this.thumbnailPanel);
        this.addAllBtn = SwingUtilities2.createButton((Action)new AddAllAction());
        this.addAllBtn.setPreferredSize(GUI.getScaledDimension((Dimension)new Dimension(150, 50)));
        this.btnPanel = new JPanel();
        this.btnPanel.setLayout(new FlowLayout(1));
        this.previewPanel = new BasicPreviewPanel(this.manager);
        this.leftPanel = new JPanel(new BorderLayout(5, 5));
        this.chkShowKeyImg = new JCheckBox(Messages.getString("BasicPrintManagerUI.ShowOnlyKeyImages"));
        this.chkShowKeyImg.setSelected(this.manager.isShowOnlyKeyimages());
        this.thumbnails = new PrintThumbnails();
        this.updatePrinter(this.manager.getSelectedPrinter());
        this.updateFormat(this.manager.getSelectedFormat());
    }

    private void initComponents() {
        this.chkAddFootnote.setEnabled(false);
        this.createCleanPreview();
    }

    private void installListeners() {
        this.manager.addPropertyChangeListener(this.myModelListener);
        this.cmbPrinters.addActionListener(new PrinterListener());
        this.cmbFormats.addActionListener(new FormatListener());
        this.includeMappings.addActionListener(new AnnotationListener());
        this.printerTab.addPropertyChangeListener("TAB_EXPANSION_FLAG_CHANGED", this.expandingListener);
        this.formatTab.addPropertyChangeListener("TAB_EXPANSION_FLAG_CHANGED", this.expandingListener);
        this.chkAddFootnote.addActionListener(new FooterListener());
        this.cmbSplit.addActionListener(new SplitOnSeriesListener());
        this.chkShowKeyImg.addActionListener(new ShowKeyImagesListener());
    }

    public void uninstallListeners() {
        this.manager.removePropertyChangeListener(this.myModelListener);
        this.printerTab.removePropertyChangeListener("TAB_EXPANSION_FLAG_CHANGED", this.expandingListener);
        this.formatTab.removePropertyChangeListener("TAB_EXPANSION_FLAG_CHANGED", this.expandingListener);
    }

    private void installLayout() {
        this.manager.setPreferredSize(GUI.getScaledDimension((Dimension)new Dimension(930, 700)));
        this.leftPanel.setPreferredSize(GUI.getScaledDimension((Dimension)new Dimension(340, 700)));
        this.leftPanel.setMaximumSize(GUI.getScaledDimension((Dimension)new Dimension(340, 700)));
        this.leftPanel.setLayout(new BorderLayout(5, 5));
        this.leftPane.addTab(this.printerTab);
        this.leftPane.addTab(this.formatTab);
        this.leftPane.addTab(this.thumbnailTab);
        this.leftPanel.add((Component)this.leftPane, "Center");
        this.rightPanel.setPreferredSize(GUI.getScaledDimension((Dimension)new Dimension(500, 600)));
        this.rightPanel.setVisible(true);
        this.rightPanel.add((Component)this.previewPanel, "Center");
        JPanel jPanel = new JPanel(new FlowLayout(1));
        jPanel.add(this.includeMappings);
        jPanel.add(this.chkAddFootnote);
        this.rightPanel.add((Component)jPanel, "South");
        TableLayout tableLayout = new TableLayout(new double[]{5.0, 0.25, 0.75}, new double[]{-2.0});
        JPanel jPanel2 = new JPanel((LayoutManager)tableLayout);
        JLabel jLabel = new JLabel(Messages.getString("BasicPrintManagerUI.Printer"));
        jPanel2.add((Component)jLabel, "1,0");
        jPanel2.add(this.cmbPrinters, "2,0");
        this.printerPanel.add((Component)jPanel2, "North");
        JPanel jPanel3 = new JPanel(new FlowLayout(0));
        this.formatPanel.add((Component)jPanel3, "North");
        this.thumbnails.setPreferredSize(GUI.getScaledDimension((Dimension)new Dimension(260, 440)));
        GridBagLayout gridBagLayout = new GridBagLayout();
        JPanel jPanel4 = new JPanel(gridBagLayout);
        gridBagLayout.addLayoutComponent(this.addAllBtn, new GridBagConstraints(1, 0, 1, 2, 0.0, 0.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        gridBagLayout.addLayoutComponent(this.cmbSplit, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 5, 5, 5), 0, 0));
        gridBagLayout.addLayoutComponent(this.chkShowKeyImg, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 5, 5, 5), 0, 0));
        jPanel4.add(this.addAllBtn);
        jPanel4.add(this.cmbSplit);
        jPanel4.add(this.chkShowKeyImg);
        this.addAllBtn.setPreferredSize(GUI.getScaledDimension((Dimension)new Dimension(150, 30)));
        this.thumbnailPanel.add((Component)((Object)this.thumbnails), "Center");
        this.thumbnailPanel.add((Component)jPanel4, "South");
        this.thumbnailTab.setExpanded(true);
        this.btnPanel.add(this.createPlaceholder(this.btnPrint, 20, 20));
        this.btnPanel.add(this.createPlaceholder(this.btnCancel, 20, 20));
        this.leftPanel.add((Component)this.leftPane, "Center");
        this.leftPanel.add((Component)this.btnPanel, "South");
        this.manager.setLayout(new BoxLayout((Container)((Object)this.manager), 0));
        this.manager.add(this.leftPanel);
        this.manager.add(this.rightPanel);
    }

    void createCleanPreview() {
        this.previewPanel.resetPreview();
    }

    private void updatePrinter(IPrinter iPrinter) {
        IPrinter iPrinter2 = this.manager.getSelectedPrinter();
        this.printerPanel.remove(iPrinter2.getUI());
        this.manager.setSelectedPrinter(iPrinter);
        this.printerPanel.add((Component)this.manager.getSelectedPrinter().getUI(), "Center");
        this.printerTab.setTitle(this.manager.getSelectedPrinter().getCompleteSetting());
    }

    private void updateFormat(IFormat iFormat) {
        IFormat iFormat2 = this.manager.getSelectedFormat();
        this.formatPanel.remove(iFormat2.getUI());
        this.manager.setSelectedFormat(iFormat);
        this.formatPanel.add((Component)this.manager.getSelectedFormat().getUI(), "Center");
        this.formatTab.setTitle(this.manager.getSelectedFormat().getCompleteSetting());
    }

    public void uninstallLayout() {
        this.previewPanel.uninstall();
        this.thumbnails.reset();
        this.manager.removeAll();
    }

    protected JCheckBox createCheckBox(String string, boolean bl) {
        JCheckBox jCheckBox = new JCheckBox();
        if (string != null) {
            jCheckBox.setText(string);
        }
        jCheckBox.setSelected(bl);
        return jCheckBox;
    }

    protected JRadioButton createRadioButton(String string) {
        JRadioButton jRadioButton = new JRadioButton();
        if (string != null) {
            jRadioButton.setText(string);
        }
        return jRadioButton;
    }

    protected TaskPaneTab createTaskPaneTab(String string, JComponent jComponent) {
        TaskPaneTab taskPaneTab = new TaskPaneTab(string, jComponent);
        taskPaneTab.setPrimaryHeaderColor(UIManager.getColor("color.primary.2"));
        taskPaneTab.setSecondaryHeaderColor(UIManager.getColor("color.primary.4"));
        taskPaneTab.setHeaderPaintingType(2);
        return taskPaneTab;
    }

    protected JLabel createLabel(String string) {
        JLabel jLabel = new JLabel();
        if (string != null) {
            jLabel.setText(string);
        }
        return jLabel;
    }

    protected JButton createButton(Action action, int n, int n2) {
        JButton jButton = SwingUtilities2.createButton((Action)action);
        Dimension dimension = GUI.getScaledDimension((Dimension)new Dimension(n, n2));
        jButton.setPreferredSize(dimension);
        return jButton;
    }

    protected JPanel createPlaceholder(JComponent jComponent, int n, int n2) {
        JPanel jPanel = new JPanel(new BorderLayout(n, n2));
        Dimension dimension = jComponent.getPreferredSize();
        dimension.width += 2 * n2;
        dimension.height += 2 * n;
        jPanel.setPreferredSize(dimension);
        jPanel.setMinimumSize(dimension);
        jPanel.add((Component)jComponent, "Center");
        return jPanel;
    }

    protected JTextField createTextField(String string) {
        JTextField jTextField = new JTextField();
        if (string != null) {
            jTextField.setText(string);
        }
        return jTextField;
    }

    protected JPanel createPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setOpaque(false);
        return jPanel;
    }

    protected JToggleButton createToggleButton(String string, Icon icon) {
        JToggleButton jToggleButton = new JToggleButton();
        if (string != null) {
            jToggleButton.setText(string);
        }
        if (icon != null) {
            jToggleButton.setIcon(icon);
        }
        Dimension dimension = new Dimension(120, 25);
        jToggleButton.setMinimumSize(dimension);
        jToggleButton.setPreferredSize(dimension);
        jToggleButton.setMaximumSize(dimension);
        return jToggleButton;
    }

    private void setToolIcon(Action action, String string, String string2) {
        action.putValue("ShortDescription", string);
        action.putValue("SmallIcon", IconLoader.getIcon((String)(iconPath + string2), (ClassLoader)this.getClass().getClassLoader(), (double)GUI.getScaleFactor()));
    }

    private class AddAllAction
    extends AbstractAction {
        private static final long serialVersionUID = 5063813571429202536L;

        public AddAllAction() {
            super(">>");
            super.putValue("ShortDescription", Messages.getString("BasicPrintManagerUI.AddAllTT"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            List<IImageBoxInfo> list = BasicPrintManagerUI.this.manager.getNotSelectedData();
            if (list.isEmpty()) {
                return;
            }
            List<IImageBoxInfo> list2 = BasicPrintManagerUI.this.manager.createImageBoxInfos(list, true, false);
            Collections.sort(list2, new DataSorter());
            BasicPrintManagerUI.this.manager.getSelectedFormat().addData(list2, BasicPrintManagerUI.this.manager.getSelectedSplitting());
            BasicPrintManagerUI.this.manager.selectData(list);
            BasicPrintManagerUI.this.previewPanel.drawPreview();
        }
    }

    private class AnnotationListener
    implements ActionListener {
        private AnnotationListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            BasicPrintManagerUI.this.manager.setUseDemogrpahics(BasicPrintManagerUI.this.includeMappings.isSelected());
        }
    }

    private class CancelAction
    extends AbstractAction {
        private static final long serialVersionUID = -3681077544828870624L;

        public CancelAction() {
            BasicPrintManagerUI.this.setToolIcon(this, Messages.getString("BasicPrintManagerUI.CancelTT"), "cancel.gif");
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            BasicPrintManagerUI.this.manager.closeWindow();
        }
    }

    private class FooterListener
    implements ActionListener {
        private FooterListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            BasicPrintManagerUI.this.manager.setAddFooter(BasicPrintManagerUI.this.chkAddFootnote.isSelected());
        }
    }

    private class FormatListener
    implements ActionListener {
        private FormatListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            BasicPrintManagerUI.this.updateFormat((IFormat)BasicPrintManagerUI.this.cmbFormats.getSelectedItem());
        }
    }

    private class ModelListener
    implements PropertyChangeListener {
        private ModelListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (propertyChangeEvent.getPropertyName().equals("UPDATE_ICONS")) {
                ArrayList<ThumbnailFrame> arrayList = new ArrayList<ThumbnailFrame>();
                for (IImageBoxInfo iImageBoxInfo : BasicPrintManagerUI.this.manager.getNotSelectedData()) {
                    arrayList.add(new ThumbnailFrame(iImageBoxInfo.getObjectInfo(), Integer.valueOf(iImageBoxInfo.getFrameNumber())));
                }
                BasicPrintManagerUI.this.thumbnails.initialize(arrayList);
            } else if (propertyChangeEvent.getPropertyName().equals("UPDATE_TITLES")) {
                BasicPrintManagerUI.this.updatePrinter(BasicPrintManagerUI.this.manager.getSelectedPrinter());
                BasicPrintManagerUI.this.updateFormat(BasicPrintManagerUI.this.manager.getSelectedFormat());
            }
        }
    }

    private class PrintAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        public PrintAction() {
            BasicPrintManagerUI.this.setToolIcon(this, Messages.getString("BasicPrintManagerUI.PrintTT"), "print.gif");
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            BasicPrintManagerUI.this.manager.print();
            BasicPrintManagerUI.this.manager.closeWindow();
        }
    }

    private class PrinterListener
    implements ActionListener {
        private PrinterListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            IPrinter iPrinter = (IPrinter)BasicPrintManagerUI.this.cmbPrinters.getSelectedItem();
            BasicPrintManagerUI.this.updatePrinter(iPrinter);
            if (iPrinter != null) {
                BasicPrintManagerUI.this.cmbPrinters.setToolTipText(iPrinter.toString());
            }
        }
    }

    private class ShowKeyImagesListener
    implements ActionListener {
        private ShowKeyImagesListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            BasicPrintManagerUI.this.manager.setShowOnlyKeyimages(BasicPrintManagerUI.this.chkShowKeyImg.isSelected());
        }
    }

    private class SplitOnSeriesListener
    implements ActionListener {
        private SplitOnSeriesListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            BasicPrintManagerUI.this.manager.setSplitting((PrintManager.SPLIT_TYPE)((Object)BasicPrintManagerUI.this.cmbSplit.getSelectedItem()));
        }
    }

    private class TabExpandingListener
    implements PropertyChangeListener {
        private TabExpandingListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (propertyChangeEvent.getPropertyName().equals("TAB_EXPANSION_FLAG_CHANGED")) {
                BasicPrintManagerUI.this.printerTab.setTitle(BasicPrintManagerUI.this.manager.getSelectedPrinter().getCompleteSetting());
                BasicPrintManagerUI.this.formatTab.setTitle(BasicPrintManagerUI.this.manager.getSelectedFormat().getCompleteSetting());
            }
        }
    }
}

