/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.lta.print.local;

import com.agfa.pacs.listtext.lta.print.Messages;
import com.agfa.pacs.listtext.lta.print.local.LocalPrinter;
import com.agfa.pacs.listtext.print.IFilmBoxResolution;
import com.agfa.pacs.listtext.print.IFilmSize;
import info.clearthought.layout.TableLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ButtonGroup;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class LocaleSettingPanel
extends JPanel {
    private static final long serialVersionUID = 995832589156686155L;
    private LocalPrinter printer;
    private JLabel resLabel = null;
    private JComboBox cmbResolutions = null;
    private JLabel mediumLabel = null;
    private JComboBox cmbMedias = null;
    private JLabel copiesLabel = null;
    private JSpinner copies = null;
    private JRadioButton portraitBtn = null;
    private JRadioButton landscapeBtn = null;

    public LocaleSettingPanel(LocalPrinter localPrinter) {
        this.printer = localPrinter;
        this.initUI();
    }

    private void initUI() {
        this.createComponents();
        this.installListeners();
        this.installLayout();
    }

    private void createComponents() {
        this.resLabel = this.createLabel(String.valueOf(Messages.getString("LocaleSettingPanel.Resolution")) + ":");
        this.cmbResolutions = new JComboBox<IFilmBoxResolution>(this.printer.getResolutions());
        this.cmbResolutions.setSelectedItem(this.printer.getSelectedResolution());
        this.mediumLabel = this.createLabel(String.valueOf(Messages.getString("Medium")) + ":");
        this.cmbMedias = new JComboBox<IFilmSize>(this.printer.getMedias());
        this.cmbMedias.setSelectedItem(this.printer.getSelectedMedium());
        ButtonGroup buttonGroup = new ButtonGroup();
        this.landscapeBtn = new JRadioButton(Messages.getString("Landscape"));
        buttonGroup.add(this.landscapeBtn);
        this.portraitBtn = new JRadioButton(Messages.getString("Portrait"));
        buttonGroup.add(this.portraitBtn);
        if (this.printer.isLandscape()) {
            this.landscapeBtn.setSelected(true);
        } else {
            this.portraitBtn.setSelected(true);
        }
        this.copiesLabel = this.createLabel(String.valueOf(Messages.getString("DicomSettingPanel.Copies")) + ":");
        this.copies = new JSpinner(new SpinnerNumberModel(this.printer.getCopies(), 1, 10, 1));
    }

    private void installListeners() {
        ComponentListener componentListener = new ComponentListener();
        this.cmbMedias.addActionListener(componentListener);
        this.cmbResolutions.addActionListener(componentListener);
        this.landscapeBtn.addActionListener(componentListener);
        this.portraitBtn.addActionListener(componentListener);
        this.copies.addChangeListener(componentListener);
    }

    private void installLayout() {
        TableLayout tableLayout = new TableLayout(new double[]{3.0, 0.25, 0.35, 0.4}, new double[]{-2.0, -2.0, -2.0, -2.0});
        tableLayout.setHGap(3);
        tableLayout.setVGap(5);
        this.setLayout((LayoutManager)tableLayout);
        this.add((Component)this.mediumLabel, "1 0");
        this.add((Component)this.cmbMedias, "2 0 3 0");
        this.add((Component)this.portraitBtn, "2 1");
        this.add((Component)this.landscapeBtn, "3 1");
        this.add((Component)this.resLabel, "1 2");
        this.add((Component)this.cmbResolutions, "2 2 3 2");
        this.add((Component)this.copiesLabel, "1 3");
        this.add((Component)this.copies, "2 3 3 3 ");
    }

    private JLabel createLabel(String string) {
        return new JLabel(string);
    }

    private class ComponentListener
    implements ActionListener,
    ChangeListener {
        private ComponentListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == LocaleSettingPanel.this.cmbMedias) {
                LocaleSettingPanel.this.printer.setMedium((IFilmSize)LocaleSettingPanel.this.cmbMedias.getSelectedItem());
            } else if (actionEvent.getSource() == LocaleSettingPanel.this.cmbResolutions) {
                LocaleSettingPanel.this.printer.setResolution((IFilmBoxResolution)LocaleSettingPanel.this.cmbResolutions.getSelectedItem());
            } else {
                LocaleSettingPanel.this.printer.setIsLandscape(LocaleSettingPanel.this.landscapeBtn.isSelected());
            }
        }

        @Override
        public void stateChanged(ChangeEvent changeEvent) {
            LocaleSettingPanel.this.printer.setCopies((Integer)LocaleSettingPanel.this.copies.getModel().getValue());
        }
    }
}

